/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.desktop;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.DefaultPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class MultiPageChangeStrategy
implements IPageChangeStrategy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MultiPageChangeStrategy.class);
    private IOutline m_outline;
    private IPage m_mainPage;
    private IPage m_subPage;
    private PageFormManager m_pageFormManager;
    private DefaultPageChangeStrategy m_defaultPageChangeStrategy = new DefaultPageChangeStrategy();

    public MultiPageChangeStrategy(PageFormManager pageFormManager) {
        this.m_pageFormManager = pageFormManager;
    }

    public void pageChanged(IOutline outline, IPage deselectedPage, IPage selectedPage) {
        if (outline == null) {
            return;
        }
        if (outline != this.m_outline) {
            this.m_mainPage = null;
            this.m_subPage = null;
            this.m_outline = outline;
        }
        if (selectedPage == null) {
            this.activateMainPage(deselectedPage, selectedPage);
        } else {
            String pageFormSlot = this.m_pageFormManager.computePageFormSlot(selectedPage);
            if (this.m_pageFormManager.getLeftPageSlotViewId().equals(pageFormSlot)) {
                this.activateMainPage(deselectedPage, selectedPage);
            } else {
                this.activateMainPage(deselectedPage, selectedPage.getParentPage());
                this.activateSubPage(selectedPage);
            }
        }
    }

    private void activateMainPage(IPage deselectedPage, IPage selectedPage) {
        if (this.m_mainPage == selectedPage) {
            return;
        }
        this.deactivateSubPage();
        this.m_defaultPageChangeStrategy.pageChanged(this.m_outline, deselectedPage, selectedPage);
        this.m_mainPage = selectedPage;
        LOG.debug("Main page activated: " + selectedPage);
    }

    private void activateSubPage(IPage selectedPage) {
        if (this.m_subPage == selectedPage) {
            return;
        }
        this.deactivateSubPage();
        this.m_subPage = selectedPage;
        if (this.m_subPage != null) {
            this.m_subPage.pageActivatedNotify();
            try {
                this.m_subPage.ensureChildrenLoaded();
            }
            catch (ProcessingException e1) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e1);
            }
            LOG.debug("Sub page activated: " + selectedPage);
        }
    }

    private void deactivateSubPage() {
        if (this.m_subPage == null) {
            return;
        }
        this.m_subPage.pageDeactivatedNotify();
        this.m_subPage = null;
    }

    private boolean isChildOfMainPage(IPage selectedPage) {
        if (selectedPage == null || this.m_mainPage == null || this.m_mainPage.getChildNodeCount() == 0) {
            return false;
        }
        for (IPage childPage : this.m_mainPage.getChildPages()) {
            if (!selectedPage.equals(childPage)) continue;
            return true;
        }
        return false;
    }
}

