/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.ui.action.ActionButtonBarUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.AbstractFormActionFetcher;
import org.eclipse.scout.rt.client.mobile.ui.form.IMobileAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;

public class FormHeaderActionFetcher
extends AbstractFormActionFetcher {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FormHeaderActionFetcher.class);

    public FormHeaderActionFetcher(IForm form) {
        super(form);
    }

    @Override
    public List<IMenu> fetch() {
        List<IMobileAction> leftActions;
        LinkedList<IMenu> formActions = new LinkedList<IMenu>();
        if (this.getForm().getRootGroupBox().getSystemProcessButtonCount() > 0 && (leftActions = this.createLeftActions()) != null) {
            for (IMobileAction action : leftActions) {
                action.setHorizontalAlignment(-1);
            }
            formActions.addAll(leftActions);
        }
        if (this.getForm().getRootGroupBox().getSystemProcessButtonCount() > 0 || this.getForm().getRootGroupBox().getCustomProcessButtonCount() > 0) {
            List<IMobileAction> rightActions = this.createRightActions();
            if (rightActions != null) {
                for (IMobileAction action : rightActions) {
                    action.setHorizontalAlignment(1);
                }
            }
            formActions.addAll(rightActions);
        }
        return formActions;
    }

    protected List<IMobileAction> convertSystemProcessButtons(final List<Integer> relevantSystemTypes) {
        if (relevantSystemTypes == null || relevantSystemTypes.size() == 0) {
            return null;
        }
        List systemProcessButtons = this.getForm().getRootGroupBox().getSystemProcessButtons();
        if (!CollectionUtility.hasElements((Collection)systemProcessButtons)) {
            return null;
        }
        IButton[] array = systemProcessButtons.toArray(new IButton[systemProcessButtons.size()]);
        Comparator<IButton> comparator = new Comparator<IButton>(){

            @Override
            public int compare(IButton button1, IButton button2) {
                int index2;
                int index1 = relevantSystemTypes.indexOf(button1.getSystemType());
                if (index1 >= (index2 = relevantSystemTypes.indexOf(button2.getSystemType()))) {
                    return 1;
                }
                return -1;
            }
        };
        Arrays.sort(array, comparator);
        ArrayList<IMobileAction> sortedActions = new ArrayList<IMobileAction>(array.length);
        IButton[] iButtonArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IButton scoutButton = iButtonArray[n2];
            if (relevantSystemTypes.contains(scoutButton.getSystemType())) {
                try {
                    sortedActions.add(ActionButtonBarUtility.convertButtonToAction(scoutButton));
                }
                catch (ProcessingException e) {
                    LOG.error("could not initialize actions.", (Throwable)e);
                }
            }
            ++n2;
        }
        return sortedActions;
    }

    protected List<IMobileAction> createLeftActions() {
        return this.convertSystemProcessButtons(this.getRelevantSystemTypesForLeftSide());
    }

    protected List<IMobileAction> createRightActions() {
        LinkedList<IMobileAction> actions = new LinkedList<IMobileAction>();
        List<IMobileAction> systemActions = this.convertSystemProcessButtons(this.getRelevantSystemTypesForRightSide());
        if (systemActions != null) {
            actions.addAll(systemActions);
        }
        try {
            actions.addAll(this.convertCustomProcessButtons());
        }
        catch (ProcessingException e) {
            LOG.error("could not initialze actions.", (Throwable)e);
        }
        return actions;
    }

    protected List<Integer> getRelevantSystemTypesForLeftSide() {
        LinkedList<Integer> systemTypesToConsider = new LinkedList<Integer>();
        systemTypesToConsider.add(1);
        systemTypesToConsider.add(2);
        systemTypesToConsider.add(100);
        return systemTypesToConsider;
    }

    protected List<Integer> getRelevantSystemTypesForRightSide() {
        LinkedList<Integer> systemTypesToConsider = new LinkedList<Integer>();
        systemTypesToConsider.add(3);
        systemTypesToConsider.add(5);
        systemTypesToConsider.add(6);
        systemTypesToConsider.add(4);
        return systemTypesToConsider;
    }
}

