/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.fields.tabbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.AbstractMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.ClearTableSelectionFormCloseListener;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.tabbox.TabForm;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class TabBoxTableField
extends AbstractTableField<Table> {
    private ITabBox m_tabBox;

    public ITabBox getTabBox() {
        return this.m_tabBox;
    }

    protected void initConfig() {
        super.initConfig();
        this.m_tabBox = this.getConfiguredTabBox();
    }

    protected ITabBox getConfiguredTabBox() {
        return null;
    }

    protected void execInitField() throws ProcessingException {
        if (this.m_tabBox == null) {
            return;
        }
        for (IGroupBox groupBox : this.m_tabBox.getGroupBoxes()) {
            groupBox.addPropertyChangeListener((PropertyChangeListener)new P_TabPropertyChangeListener());
        }
        this.rebuildTableRows();
    }

    public void rebuildTableRows() throws ProcessingException {
        if (this.m_tabBox == null) {
            return;
        }
        ((Table)this.getTable()).discardAllRows();
        for (IGroupBox groupBox : this.m_tabBox.getGroupBoxes()) {
            if (!groupBox.isVisible()) continue;
            ((Table)this.getTable()).addRowByArray(new Object[]{groupBox, groupBox.getLabel()});
        }
        this.getParentGroupBox().rebuildFieldGrid();
    }

    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    private class P_TabPropertyChangeListener
    implements PropertyChangeListener {
        private P_TabPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                if ("visible".equals(evt.getPropertyName())) {
                    TabBoxTableField.this.rebuildTableRows();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Order(value=10.0)
    public class Table
    extends AbstractMobileTable {
        protected void execRowsSelected(List<? extends ITableRow> rows) throws ProcessingException {
            if (this.getSelectedRow() == null) {
                return;
            }
            IGroupBox tab = (IGroupBox)this.getTabColumn().getValue(this.getSelectedRow());
            TabForm form = new TabForm(tab);
            form.setDisplayHint(TabBoxTableField.this.getForm().getDisplayHint());
            form.setDisplayViewId(TabBoxTableField.this.getForm().getDisplayViewId());
            form.setModal(form.getDisplayHint() == 0);
            form.start();
            form.addFormListener(new ClearTableSelectionFormCloseListener(this));
        }

        @Override
        protected boolean execIsAutoCreateTableRowForm() {
            return false;
        }

        protected boolean getConfiguredSortEnabled() {
            return false;
        }

        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        public TabColumn getTabColumn() {
            return (TabColumn)this.getColumnSet().getColumnByClass(TabColumn.class);
        }

        public LabelColumn getLabelColumn() {
            return (LabelColumn)this.getColumnSet().getColumnByClass(LabelColumn.class);
        }

        @Order(value=2.0)
        public class LabelColumn
        extends AbstractStringColumn {
        }

        @Order(value=1.0)
        public class TabColumn
        extends AbstractColumn<IGroupBox> {
            protected boolean getConfiguredDisplayable() {
                return false;
            }
        }
    }
}

