/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.outline;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;

public class PageFormInitFieldVisitor
implements IFormFieldVisitor {
    private ProcessingException m_firstEx;
    private Set<IForm> m_formsToIgnore = new HashSet<IForm>();

    public boolean visitField(IFormField field, int level, int fieldIndex) {
        block5: {
            try {
                if (this.allowInitField(field)) {
                    field.initField();
                }
            }
            catch (ProcessingException e) {
                if (this.m_firstEx == null) {
                    this.m_firstEx = e;
                }
            }
            catch (Throwable t) {
                if (this.m_firstEx != null) break block5;
                this.m_firstEx = new ProcessingException("Unexpected", t);
            }
        }
        return true;
    }

    public void handleResult() throws ProcessingException {
        this.m_formsToIgnore.clear();
        if (this.m_firstEx != null) {
            throw this.m_firstEx;
        }
    }

    private boolean allowInitField(IFormField field) {
        if (field instanceof IWrappedFormField) {
            IForm innerForm = ((IWrappedFormField)field).getInnerForm();
            if (innerForm != null) {
                this.m_formsToIgnore.add(innerForm);
            }
            return true;
        }
        return !this.m_formsToIgnore.contains(field.getForm());
    }
}

