/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel.http.internal;

import java.net.URL;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.client.servicetunnel.http.IClientServiceTunnel;
import org.eclipse.scout.rt.client.servicetunnel.http.internal.ClientNotificationPollingJob;
import org.eclipse.scout.rt.servicetunnel.http.internal.AbstractInternalHttpServiceTunnel;
import org.eclipse.scout.rt.servicetunnel.http.internal.HttpBackgroundExecutable;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.offline.IOfflineDispatcherService;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.service.SERVICES;

public class InternalClientHttpServiceTunnel
extends AbstractInternalHttpServiceTunnel<IClientSession>
implements IClientServiceTunnel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(InternalClientHttpServiceTunnel.class);
    private ClientNotificationPollingJob m_pollingJob;
    private final Object m_pollingJobLock = new Object();
    private long m_pollInterval = -1L;
    private boolean m_analyzeNetworkLatency = true;

    public InternalClientHttpServiceTunnel(IClientSession session, URL url) {
        this(session, url, null);
    }

    public InternalClientHttpServiceTunnel(IClientSession session, URL url, String version) {
        super((ISession)session, url, version);
    }

    @Override
    public long getClientNotificationPollInterval() {
        return this.m_pollInterval;
    }

    @Override
    public void setClientNotificationPollInterval(long intervallMillis) {
        this.m_pollInterval = intervallMillis;
        this.updatePollingJobInternal();
    }

    @Override
    public boolean isAnalyzeNetworkLatency() {
        return this.m_analyzeNetworkLatency;
    }

    @Override
    public void setAnalyzeNetworkLatency(boolean b) {
        this.m_analyzeNetworkLatency = b;
        this.updatePollingJobInternal();
    }

    protected void decorateServiceRequest(ServiceTunnelRequest call) {
        IClientNotificationConsumerService cns = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class);
        if (cns != null) {
            call.setConsumedNotifications(cns.getConsumedNotificationIds((IClientSession)this.getSession()));
        }
    }

    protected void onInvokeService(long t0, ServiceTunnelResponse response) {
        IClientNotificationConsumerService cns;
        IPerformanceAnalyzerService perf = (IPerformanceAnalyzerService)SERVICES.getService(IPerformanceAnalyzerService.class);
        if (perf != null) {
            long totalMillis = (System.nanoTime() - t0) / 1000000L;
            Long execMillis = response.getProcessingDuration();
            if (execMillis != null) {
                perf.addNetworkLatencySample(totalMillis - execMillis);
                perf.addServerExecutionTimeSample(execMillis);
            } else {
                perf.addNetworkLatencySample(totalMillis);
            }
        }
        if ((cns = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)) != null) {
            cns.dispatchClientNotifications(response.getClientNotifications(), (IClientSession)this.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePollingJobInternal() {
        Object object = this.m_pollingJobLock;
        synchronized (object) {
            long p = this.getClientNotificationPollInterval();
            boolean b = this.isAnalyzeNetworkLatency();
            if (p > 0L) {
                if (this.m_pollingJob == null) {
                    this.m_pollingJob = new ClientNotificationPollingJob((IClientSession)this.getSession(), p, b);
                    this.m_pollingJob.schedule();
                } else {
                    this.m_pollingJob.updatePollingValues(p, b);
                }
            } else if (this.m_pollingJob != null) {
                this.m_pollingJob.cancel();
                this.m_pollingJob = null;
            }
        }
    }

    protected ServiceTunnelResponse tunnel(ServiceTunnelRequest call) {
        boolean offline = OfflineState.isOfflineInCurrentThread();
        if (offline) {
            return this.tunnelOffline(call);
        }
        return this.tunnelOnline(call);
    }

    protected ServiceTunnelResponse tunnelOnline(ServiceTunnelRequest req) {
        if (ClientJob.isCurrentJobCanceled()) {
            return new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0])));
        }
        return super.tunnel(req);
    }

    protected ServiceTunnelResponse tunnelOffline(final ServiceTunnelRequest call) {
        Job job = Job.getJobManager().currentJob();
        final Object monitor = job instanceof ClientJob ? ((ClientJob)job).getMonitor() : new NullProgressMonitor();
        IClientSession clientSession = ClientSyncJob.getCurrentSession();
        if (clientSession != null && clientSession.getOfflineSubject() != null) {
            ServiceTunnelResponse response = Subject.doAs(clientSession.getOfflineSubject(), new PrivilegedAction<ServiceTunnelResponse>(){

                @Override
                public ServiceTunnelResponse run() {
                    return ((IOfflineDispatcherService)SERVICES.getService(IOfflineDispatcherService.class)).dispatch(call, monitor);
                }
            });
            return response;
        }
        return ((IOfflineDispatcherService)SERVICES.getService(IOfflineDispatcherService.class)).dispatch(call, monitor);
    }

    protected void decorateBackgroundJob(ServiceTunnelRequest call, Job backgroundJob) {
        backgroundJob.setUser(false);
        backgroundJob.setSystem(true);
    }

    protected JobEx createHttpBackgroundJob(String name, final HttpBackgroundExecutable executable) {
        return new ClientAsyncJob(name, (IClientSession)this.getSession(), true){

            @Override
            protected IStatus runStatus(IProgressMonitor monitor) {
                return executable.run(monitor);
            }
        };
    }
}

