/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.print;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.print.PrintEvent;
import org.eclipse.scout.rt.client.ui.action.print.PrintListener;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;

public class PrintApplicationAction
extends AbstractAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PrintApplicationAction.class);
    private final IDesktop m_desktop;
    private IFormFilter m_formFilter;
    private final List<ITask> m_taskList;
    private File m_destinationFolder;
    private boolean m_ignoreTabs;
    private final EventListenerList m_printListeners;

    public PrintApplicationAction(IDesktop desktop) {
        this(desktop, null);
    }

    public PrintApplicationAction(IDesktop desktop, File destinationFolder) {
        this.m_desktop = desktop;
        this.m_destinationFolder = destinationFolder;
        this.m_taskList = new ArrayList<ITask>();
        this.m_printListeners = new EventListenerList();
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.getDesktop() == null) {
            throw new VetoException("desktop is null");
        }
        if (this.getDestinationFolder() == null) {
            throw new VetoException("destinationFolder is null");
        }
        this.firePrintEvent(new PrintEvent(this, 100));
        if (this.m_formFilter == null) {
            this.m_formFilter = new IFormFilter(){

                @Override
                public boolean acceptForm(IForm form) {
                    return true;
                }
            };
        }
        this.m_taskList.clear();
        this.getDestinationFolder().mkdirs();
        this.getDesktop().addDesktopListener(new P_DesktopListener());
        this.getDesktop().printDesktop(PrintDevice.File, this.createPrintParameters(this.createFile(this.getDestinationFolder(), "Desktop", "jpg")));
        for (IForm f : this.getDesktop().getDialogStack()) {
            if (!this.getFormFilter().acceptForm(f)) continue;
            this.processForm(f);
        }
        this.m_taskList.add(new P_EndTask());
    }

    private void processForm(IForm form) {
        for (IFormField field : form.getAllFields()) {
            if (!(field instanceof ITabBox) || field.isVisible()) continue;
            field.setVisible(true);
        }
        this.m_taskList.add(new P_PrintFormTaks(form));
        if (!this.isIgnoreTabs()) {
            for (IFormField field : form.getAllFields()) {
                if (!(field instanceof ITabBox) || !field.isVisible()) continue;
                final ITabBox tabBox = (ITabBox)field;
                IGroupBox selectedTab = null;
                if (tabBox.isVisible()) {
                    selectedTab = tabBox.getSelectedTab();
                }
                if (tabBox.isVisible()) {
                    for (IGroupBox g : tabBox.getGroupBoxes()) {
                        if (g == selectedTab) continue;
                        this.m_taskList.add(new P_PrintFormTaks(form, g));
                    }
                }
                if (selectedTab == null) continue;
                final IGroupBox selectedTabFinal = selectedTab;
                this.m_taskList.add(new ITask(){

                    @Override
                    public void run() throws ProcessingException {
                        tabBox.setSelectedTab(selectedTabFinal);
                        PrintApplicationAction.this.executeNextTask();
                    }
                });
            }
        }
    }

    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    public File getDestinationFolder() {
        return this.m_destinationFolder;
    }

    public void setDestinationFolder(File destinationFolder) {
        this.m_destinationFolder = destinationFolder;
    }

    public void setFormFilter(IFormFilter filter) {
        this.m_formFilter = filter;
    }

    public IFormFilter getFormFilter() {
        return this.m_formFilter;
    }

    public void setIgnoreTabs(boolean ignoreTabs) {
        this.m_ignoreTabs = ignoreTabs;
    }

    public boolean isIgnoreTabs() {
        return this.m_ignoreTabs;
    }

    public void addPrintListener(PrintListener listener) {
        this.m_printListeners.add(PrintListener.class, (EventListener)listener);
    }

    public void removePrintListener(PrintListener listener) {
        this.m_printListeners.remove(PrintListener.class, (EventListener)listener);
    }

    private void firePrintEvent(PrintEvent e) {
        PrintListener[] printListenerArray = (PrintListener[])this.m_printListeners.getListeners(PrintListener.class);
        int n = printListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrintListener l = printListenerArray[n2];
            l.handlePrintEvent(e);
            ++n2;
        }
    }

    private void executeNextTask() throws ProcessingException {
        if (this.m_taskList.isEmpty()) {
            return;
        }
        ITask task = this.m_taskList.remove(0);
        task.run();
    }

    private File createFile(File dir, String filename, String fileExtension) throws ProcessingException {
        IPath path = new Path(dir.getAbsolutePath()).append(filename);
        path = path.addFileExtension(fileExtension);
        File file = path.toFile();
        try {
            if (!file.createNewFile()) {
                throw new ProcessingException("Temporary file could not be created");
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Temporary file could not be created", (Throwable)e);
        }
        return file;
    }

    private HashMap<String, Object> createPrintParameters(File printFile) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", printFile);
        parameters.put("contentType", "image/jpg");
        return parameters;
    }

    public static interface IFormFilter {
        public boolean acceptForm(IForm var1);
    }

    private static interface ITask {
        public void run() throws ProcessingException;
    }

    private class P_DesktopListener
    implements DesktopListener {
        private P_DesktopListener() {
        }

        @Override
        public void desktopChanged(DesktopEvent e) {
            if (e.getType() == 901) {
                PrintApplicationAction.this.getDesktop().removeDesktopListener(this);
                try {
                    PrintApplicationAction.this.executeNextTask();
                }
                catch (ProcessingException e1) {
                    LOG.warn("could not execute task.", (Object)e);
                }
            }
        }
    }

    private class P_EndTask
    implements ITask {
        private P_EndTask() {
        }

        @Override
        public void run() throws ProcessingException {
            PrintApplicationAction.this.firePrintEvent(new PrintEvent(PrintApplicationAction.this, 200));
        }
    }

    private class P_FormListener
    implements FormListener {
        private final IForm m_form;

        public P_FormListener(IForm form) {
            this.m_form = form;
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            if (e.getType() == 4010) {
                this.getForm().removeFormListener(this);
                PrintApplicationAction.this.executeNextTask();
            }
        }

        public IForm getForm() {
            return this.m_form;
        }
    }

    private class P_PrintFormTaks
    implements ITask {
        private final IForm m_form;
        private final IGroupBox m_groupBox;

        private P_PrintFormTaks(IForm form) {
            this(form, (IGroupBox)null);
        }

        private P_PrintFormTaks(IForm form, IGroupBox groupBox) {
            this.m_form = form;
            this.m_groupBox = groupBox;
        }

        @Override
        public void run() throws ProcessingException {
            StringBuilder filename = new StringBuilder();
            filename.append(this.getForm().getFormId());
            if (this.getGroupBox() != null) {
                filename.append("_" + this.getGroupBox().getFieldId());
                ICompositeField parentField = this.getGroupBox().getParentField();
                if (parentField instanceof ITabBox) {
                    ((ITabBox)parentField).setSelectedTab(this.getGroupBox());
                }
            }
            this.getForm().addFormListener(new P_FormListener(this.getForm()));
            this.getForm().printForm(PrintDevice.File, PrintApplicationAction.this.createPrintParameters(PrintApplicationAction.this.createFile(PrintApplicationAction.this.getDestinationFolder(), filename.toString(), "jpg")));
        }

        public IForm getForm() {
            return this.m_form;
        }

        public IGroupBox getGroupBox() {
            return this.m_groupBox;
        }
    }
}

