/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;

public class ActivityMapEvent
extends EventObject {
    public static final int TYPE_ACTIVITIES_INSERTED = 100;
    public static final int TYPE_ACTIVITIES_UPDATED = 101;
    public static final int TYPE_ACTIVITIES_DELETED = 102;
    public static final int TYPE_CELL_ACTION = 104;
    public static final int TYPE_ALL_ACTIVITIES_DELETED = 105;
    public static final int TYPE_EDIT_ACTIVITY_POPUP = 700;
    public static final int TYPE_NEW_ACTIVITY_POPUP = 701;
    private int m_type;
    private List<? extends ActivityCell> m_activities = CollectionUtility.emptyArrayList();
    private List<IMenu> m_popupMenus;
    private Object m_resourceId;
    private MinorTimeColumn m_column;

    public ActivityMapEvent(IActivityMap source, int type) {
        super(source);
        this.m_type = type;
    }

    public ActivityMapEvent(IActivityMap source, int type, ActivityCell activity) {
        super(source);
        this.m_type = type;
        if (activity != null) {
            ArrayList<? extends ActivityCell> list = new ArrayList<ActivityCell>();
            list.add(activity);
            this.m_activities = list;
        }
    }

    public ActivityMapEvent(IActivityMap source, int type, List<? extends ActivityCell> activities) {
        super(source);
        this.m_type = type;
        if (CollectionUtility.hasElements(activities)) {
            this.m_activities = activities;
        }
    }

    public ActivityMapEvent(IActivityMap source, int type, Object resourceId, MinorTimeColumn column, ActivityCell activity) {
        super(source);
        this.m_type = type;
        if (activity != null) {
            ArrayList<? extends ActivityCell> list = new ArrayList<ActivityCell>();
            list.add(activity);
            this.m_activities = list;
        }
        this.m_resourceId = resourceId;
        this.m_column = column;
    }

    public IActivityMap getActivityMap() {
        return (IActivityMap)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public Object getResourceId() {
        return this.m_resourceId;
    }

    public MinorTimeColumn getColumn() {
        return this.m_column;
    }

    public List<ActivityCell> getActivities() {
        return CollectionUtility.arrayList(this.m_activities);
    }

    protected void setActivities(List<? extends ActivityCell> activities) {
        this.m_activities = CollectionUtility.arrayList(activities);
    }

    public int getActivityCount() {
        return this.m_activities != null ? this.m_activities.size() : 0;
    }

    public ActivityCell getFirstActivity() {
        return (ActivityCell)((Object)CollectionUtility.firstElement(this.m_activities));
    }

    public ActivityCell getLastActivity() {
        return (ActivityCell)((Object)CollectionUtility.lastElement(this.m_activities));
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(menus);
        }
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            buf.append("#" + this.m_type);
        }
        buf.append(" ");
        if (CollectionUtility.hasElements(this.m_activities) && this.getActivityMap() != null) {
            if (this.m_activities.size() == 1) {
                buf.append("row " + CollectionUtility.firstElement(this.m_activities));
            } else {
                Iterator<? extends ActivityCell> actIt = this.m_activities.iterator();
                buf.append("" + (Object)((Object)actIt.next()));
                while (actIt.hasNext()) {
                    buf.append(",").append("" + (Object)((Object)actIt.next()));
                }
            }
        } else {
            buf.append("{}");
        }
        buf.append("]");
        return buf.toString();
    }
}

