/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField;

@ClassId(value="62fcae6b-6b75-4e8c-bb3f-ea3b400e7e30")
public abstract class AbstractBooleanColumn
extends AbstractColumn<Boolean>
implements IBooleanColumn {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBooleanColumn.class);

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setVerticalAlignment(this.getConfiguredVerticalAlignment());
    }

    @Override
    public int getVerticalAlignment() {
        return this.propertySupport.getPropertyInt("verticalAlignment");
    }

    @Override
    public void setVerticalAlignment(int verticalAlignment) {
        this.propertySupport.setProperty("verticalAlignment", (Object)verticalAlignment);
    }

    @Override
    protected Boolean parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Boolean validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Boolean) {
            validValue = (Boolean)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).intValue() == 1;
        } else {
            throw new ProcessingException("invalid Boolean value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractBooleanField f = new AbstractBooleanField(){};
        super.mapEditorFieldProperties(f);
        return f;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    protected int getConfiguredVerticalAlignment() {
        return -1;
    }
}

