/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDecimalColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;

@ClassId(value="961989bf-d585-40a2-ab9f-b7e545baaac9")
public abstract class AbstractDecimalColumn<T extends Number>
extends AbstractNumberColumn<T>
implements IDecimalColumn<T> {
    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    protected int getConfiguredMinFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=170.0)
    protected int getConfiguredMaxFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    protected boolean getConfiguredPercent() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=190.0)
    protected int getConfiguredMultiplier() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    protected int getConfiguredFractionDigits() {
        return 2;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinFractionDigits(this.getConfiguredMinFractionDigits());
        this.setMaxFractionDigits(this.getConfiguredMaxFractionDigits());
        this.setPercent(this.getConfiguredPercent());
        this.setFractionDigits(this.getConfiguredFractionDigits());
        this.setMultiplier(this.getConfiguredMultiplier());
        if (this.getConfiguredFormat() != null) {
            this.getFormatInternal().applyPattern(this.getConfiguredFormat());
        }
    }

    @Override
    public void setMinFractionDigits(int i) {
        DecimalFormat format = this.getFormat();
        format.setMinimumFractionDigits(i);
        this.setFormat(format);
    }

    @Override
    public int getMinFractionDigits() {
        return this.getFormatInternal().getMinimumFractionDigits();
    }

    @Override
    public void setMaxFractionDigits(int i) {
        DecimalFormat format = this.getFormat();
        format.setMaximumFractionDigits(i);
        this.setFormat(format);
    }

    @Override
    public int getMaxFractionDigits() {
        return this.getFormatInternal().getMaximumFractionDigits();
    }

    @Override
    public void setPercent(boolean b) {
        DecimalFormat percentDF = (DecimalFormat)DecimalFormat.getPercentInstance(LocaleThreadLocal.get());
        DecimalFormat format = this.getFormat();
        if (b) {
            format.setPositiveSuffix(percentDF.getPositiveSuffix());
            format.setNegativeSuffix(percentDF.getNegativeSuffix());
        } else if (this.isPercent()) {
            format.setPositiveSuffix("");
            format.setNegativeSuffix("");
        }
        this.setFormat(format);
    }

    @Override
    public boolean isPercent() {
        DecimalFormat percentDF = (DecimalFormat)DecimalFormat.getPercentInstance(LocaleThreadLocal.get());
        DecimalFormat internalDF = this.getFormatInternal();
        return internalDF.getPositiveSuffix().equals(percentDF.getPositiveSuffix()) && internalDF.getNegativeSuffix().equals(percentDF.getNegativeSuffix());
    }

    @Override
    public void setFractionDigits(int i) {
        this.propertySupport.setPropertyInt("parsingFractionDigits", i);
    }

    @Override
    public int getFractionDigits() {
        return this.propertySupport.getPropertyInt("parsingFractionDigits");
    }

    @Override
    public void setMultiplier(int i) {
        DecimalFormat format = this.getFormat();
        format.setMultiplier(i);
        this.setFormat(format);
    }

    @Override
    public int getMultiplier() {
        return this.getFormatInternal().getMultiplier();
    }

    @Override
    protected abstract IDecimalField<T> getEditorField();

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        INumberField f = this.getEditorField();
        this.mapEditorFieldProperties((IDecimalField<T>)f);
        return f;
    }

    @Override
    protected void mapEditorFieldProperties(IDecimalField<T> f) {
        super.mapEditorFieldProperties(f);
        f.setFractionDigits(this.getFractionDigits());
    }
}

