/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.ContributionCommand;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDesktopExtension
implements IDesktopExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDesktopExtension.class);
    private IDesktop m_coreDesktop;

    @Override
    public ContributionCommand initDelegate() throws ProcessingException {
        return this.execInit();
    }

    @Override
    public ContributionCommand desktopOpenedDelegate() throws ProcessingException {
        return this.execOpened();
    }

    @Override
    public ContributionCommand desktopBeforeClosingDelegate() throws ProcessingException {
        return this.execBeforeClosing();
    }

    @Override
    public ContributionCommand desktopClosingDelegate() throws ProcessingException {
        return this.execClosing();
    }

    @Override
    public ContributionCommand guiAttachedDelegate() throws ProcessingException {
        return this.execGuiAttached();
    }

    @Override
    public ContributionCommand guiDetachedDelegate() throws ProcessingException {
        return this.execGuiDetached();
    }

    @Override
    public ContributionCommand outlineChangedDelegate(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
        return this.execOutlineChanged(oldOutline, newOutline);
    }

    @Override
    public ContributionCommand customFormModificationDelegate(IHolder<IForm> formHolder) throws ProcessingException {
        return this.execCustomFormModification(formHolder);
    }

    @Override
    public ContributionCommand pageSearchFormChangedDelegate(IForm oldForm, IForm newForm) throws ProcessingException {
        return this.execPageSearchFormChanged(oldForm, newForm);
    }

    @Override
    public ContributionCommand pageDetailFormChangedDelegate(IForm oldForm, IForm newForm) throws ProcessingException {
        return this.execPageDetailFormChanged(oldForm, newForm);
    }

    @Override
    public ContributionCommand pageDetailTableChangedDelegate(ITable oldTable, ITable newTable) throws ProcessingException {
        return this.execPageDetailTableChanged(oldTable, newTable);
    }

    @Override
    public ContributionCommand tablePageLoadedDelegate(IPageWithTable<?> tablePage) throws ProcessingException {
        return this.execTablePageLoaded(tablePage);
    }

    @Override
    public ContributionCommand addTrayMenusDelegate(List<IMenu> menus) throws ProcessingException {
        return this.execAddTrayMenus(menus);
    }

    @Override
    public void contributeOutlines(Collection<IOutline> outlines) {
        List<Class<? extends IOutline>> contributedOutlines = this.getConfiguredOutlines();
        if (contributedOutlines == null) {
            return;
        }
        for (Class<? extends IOutline> element : contributedOutlines) {
            try {
                IOutline o = element.newInstance();
                outlines.add(o);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + element.getName() + "'.", t));
            }
        }
    }

    @Override
    public void contributeActions(Collection<IAction> actions) {
        for (Class<? extends IAction> actionClazz : this.getConfiguredActions()) {
            try {
                actions.add((IAction)ConfigurationUtility.newInnerInstance((Object)this, actionClazz));
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + actionClazz.getName() + "'.", (Throwable)e));
            }
        }
    }

    @Override
    public IDesktop getCoreDesktop() {
        return this.m_coreDesktop;
    }

    @Override
    public void setCoreDesktop(IDesktop desktop) {
        this.m_coreDesktop = desktop;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected ContributionCommand execInit() throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=12.0)
    protected ContributionCommand execOpened() throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=14.0)
    protected ContributionCommand execBeforeClosing() throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=15.0)
    protected ContributionCommand execClosing() throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected ContributionCommand execGuiAttached() throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=25.0)
    protected ContributionCommand execGuiDetached() throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=30.0)
    protected ContributionCommand execOutlineChanged(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
        return ContributionCommand.Continue;
    }

    protected ContributionCommand execCustomFormModification(IHolder<IForm> formHolder) {
        return ContributionCommand.Continue;
    }

    @Order(value=40.0)
    @ConfigOperation
    protected ContributionCommand execPageSearchFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @Order(value=50.0)
    @ConfigOperation
    protected ContributionCommand execPageDetailFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @Order(value=60.0)
    @ConfigOperation
    protected ContributionCommand execPageDetailTableChanged(ITable oldTable, ITable newTable) throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @Order(value=62.0)
    @ConfigOperation
    protected ContributionCommand execTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @Order(value=70.0)
    @ConfigOperation
    protected ContributionCommand execAddTrayMenus(List<IMenu> menus) throws ProcessingException {
        return ContributionCommand.Continue;
    }

    @ConfigProperty(value="OUTLINES")
    @Order(value=20.0)
    protected List<Class<? extends IOutline>> getConfiguredOutlines() {
        return null;
    }

    private List<Class<? extends IAction>> getConfiguredActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IAction.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }
}

