/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class KeyStrokeLookupCall
extends LocalLookupCall<String> {
    private static final long serialVersionUID = 1L;
    private String m_currentKeyStroke;

    public String getCurrentKeyStroke() {
        return this.m_currentKeyStroke;
    }

    public void setCurrentKeyStroke(String s) {
        this.m_currentKeyStroke = s;
    }

    protected List<ILookupRow<String>> execCreateLookupRows() throws ProcessingException {
        final HashMap<String, Integer> keyStrokesUpper = new HashMap<String, Integer>();
        int i = 1;
        while (i <= 12) {
            keyStrokesUpper.put("SHIFT-F" + i, new Integer(i));
            ++i;
        }
        IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
        IBookmarkVisitor v = new IBookmarkVisitor(){

            public boolean visitFolder(List<BookmarkFolder> path) {
                return true;
            }

            public boolean visitBookmark(List<BookmarkFolder> path, Bookmark b) {
                String keyStroke = b.getKeyStroke();
                if (!(keyStroke == null || KeyStrokeLookupCall.this.m_currentKeyStroke != null && KeyStrokeLookupCall.this.m_currentKeyStroke.equalsIgnoreCase(keyStroke))) {
                    keyStrokesUpper.remove(keyStroke.toUpperCase(Locale.ENGLISH));
                }
                return true;
            }
        };
        service.getBookmarkData().getGlobalBookmarks().visit(v);
        service.getBookmarkData().getUserBookmarks().visit(v);
        TreeSet availableNumbers = new TreeSet(keyStrokesUpper.values());
        ArrayList<ILookupRow<String>> resultList = new ArrayList<ILookupRow<String>>();
        for (Integer i2 : availableNumbers) {
            String key = "Shift-F" + i2;
            String text = "Shift-F" + i2;
            LookupRow row = new LookupRow((Object)key, text);
            resultList.add((ILookupRow<String>)row);
        }
        return resultList;
    }
}

