/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.browserfield;

import java.net.URL;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserFieldUIFacade;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@ClassId(value="6402e68c-abd1-42b8-8da2-b4a12f910c98")
public abstract class AbstractBrowserField
extends AbstractValueField<RemoteFile>
implements IBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBrowserField.class);
    private IBrowserFieldUIFacade m_uiFacade;
    private boolean m_scrollBarEnabled;

    public AbstractBrowserField() {
        this(true);
    }

    public AbstractBrowserField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected boolean execAcceptLocationChange(String location, String path, boolean local) throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execLocationChanged(String location, String path, boolean local) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.m_scrollBarEnabled = this.getConfiguredScrollBarEnabled();
    }

    @Override
    protected void applySearchInternal(SearchFilter search) {
    }

    @Override
    public void doLocationChange(String location) throws ProcessingException {
        if (this.getUIFacade().fireBeforeLocationChangedFromUI(location)) {
            this.getUIFacade().fireAfterLocationChangedFromUI(location);
        }
    }

    @Override
    public void setLocation(String location) {
        this.propertySupport.setProperty("location", (Object)location);
    }

    @Override
    public String getLocation() {
        return (String)this.propertySupport.getProperty("location");
    }

    @Override
    public IBrowserFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.m_scrollBarEnabled;
    }

    private class P_UIFacade
    implements IBrowserFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean fireBeforeLocationChangedFromUI(String location) {
            try {
                URL url = null;
                try {
                    url = new URL(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return AbstractBrowserField.this.execAcceptLocationChange(location, url != null ? url.getPath() : null, url != null && url.getHost().equals("local"));
            }
            catch (Throwable t) {
                LOG.error("location: " + location, t);
                return false;
            }
        }

        @Override
        public void fireAfterLocationChangedFromUI(String location) {
            try {
                URL url = null;
                try {
                    url = new URL(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AbstractBrowserField.this.execLocationChanged(location, url != null ? url.getPath() : null, url != null && url.getHost().equals("local"));
            }
            catch (Throwable t) {
                LOG.error("location: " + location, t);
            }
        }
    }
}

