/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerValueBox;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class ComposerAttributeForm
extends AbstractForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ComposerAttributeForm.class);
    private List<IDataModelAttribute> m_validAttributes;
    private List<Object> m_selectedValues;
    private List<String> m_selectedDisplayValues;

    public List<IDataModelAttribute> getAvailableAttributes() {
        return CollectionUtility.arrayList(this.m_validAttributes);
    }

    public void setAvailableAttributes(List<? extends IDataModelAttribute> attributes0) throws ProcessingException {
        this.m_validAttributes = CollectionUtility.arrayListWithoutNullElements(attributes0);
        this.getAttributeField().loadListBoxData();
    }

    public List<Object> getSelectedValues() {
        return CollectionUtility.arrayList(this.m_selectedValues);
    }

    public void setSelectedValues(List<? extends Object> o) {
        this.setSelectedValuesInternal(o);
        this.activateValueField();
    }

    private void setSelectedValuesInternal(List<? extends Object> values0) {
        this.m_selectedValues = CollectionUtility.arrayListWithoutNullElements(values0);
    }

    public List<String> getSelectedDisplayValues() {
        return CollectionUtility.arrayList(this.m_selectedDisplayValues);
    }

    public void setSelectedDisplayValues(List<String> s) {
        this.setSelectedDisplayValuesInternal(s);
    }

    private void setSelectedDisplayValuesInternal(List<String> displayValues0) {
        this.m_selectedDisplayValues = CollectionUtility.arrayListWithoutNullElements(displayValues0);
    }

    public IDataModelAttribute getSelectedAttribute() {
        return (IDataModelAttribute)this.getAttributeField().getCheckedKey();
    }

    public void setSelectedAttribute(IDataModelAttribute a) {
        this.getAttributeField().checkKey(a);
    }

    public IDataModelAttributeOp getSelectedOp() {
        return (IDataModelAttributeOp)this.getOperatorField().getCheckedKey();
    }

    public void setSelectedOp(IDataModelAttributeOp op) {
        this.getOperatorField().checkKey(op);
    }

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"ExtendedSearchAddAttribute", (String[])new String[0]);
    }

    private void activateValueField() {
        IDataModelAttribute att = (IDataModelAttribute)this.getAttributeField().getCheckedKey();
        IDataModelAttributeOp op = (IDataModelAttributeOp)this.getOperatorField().getCheckedKey();
        List<Object> newValues = this.getSelectedValues();
        if (att == null) {
            this.getValueField().clearSelectionContext();
        } else {
            this.getValueField().setSelectionContext(att, op, newValues);
        }
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.SequenceBox.AttributeField getAttributeField() {
        return this.getRootGroupBox().getFieldByClass(MainBox.SequenceBox.AttributeField.class);
    }

    public MainBox.SequenceBox.OperatorField getOperatorField() {
        return this.getRootGroupBox().getFieldByClass(MainBox.SequenceBox.OperatorField.class);
    }

    public MainBox.SequenceBox.ValueField getValueField() {
        return this.getRootGroupBox().getFieldByClass(MainBox.SequenceBox.ValueField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getRootGroupBox().getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getRootGroupBox().getFieldByClass(MainBox.CancelButton.class);
    }

    public void startNew() throws ProcessingException {
        this.startInternal(new NewHandler());
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    @Order(value=1.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 2;
        }

        @Order(value=101.0)
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=100.0)
        public class OkButton
        extends AbstractOkButton {
        }

        @Order(value=1.0)
        public class SequenceBox
        extends AbstractSequenceBox {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected int getConfiguredGridW() {
                return 2;
            }

            @Override
            protected int getConfiguredGridH() {
                return 12;
            }

            @Override
            protected boolean getConfiguredAutoCheckFromTo() {
                return false;
            }

            @Override
            protected boolean getConfiguredEqualColumnWidths() {
                return true;
            }

            @Order(value=1.0)
            public class AttributeField
            extends AbstractListBox<IDataModelAttribute> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"Attribute", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredIconId() {
                    return "composerfield_attribute";
                }

                @Override
                protected List<ILookupRow<IDataModelAttribute>> execLoadTableData() throws ProcessingException {
                    List<IDataModelAttribute> a = ComposerAttributeForm.this.getAvailableAttributes();
                    ArrayList<ILookupRow<IDataModelAttribute>> result = new ArrayList<ILookupRow<IDataModelAttribute>>(a.size());
                    for (IDataModelAttribute attribute : a) {
                        if (!attribute.isVisible()) continue;
                        result.add((ILookupRow<IDataModelAttribute>)new LookupRow((Object)attribute, attribute.getText(), attribute.getIconId()));
                    }
                    return result;
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 12;
                }

                @Override
                protected void execInitField() throws ProcessingException {
                    this.getTable().setMultiCheck(false);
                }

                @Override
                protected void execChangedValue() {
                    try {
                        Object ops;
                        IDataModelAttributeOp oldOp = (IDataModelAttributeOp)ComposerAttributeForm.this.getOperatorField().getCheckedKey();
                        ComposerAttributeForm.this.getOperatorField().loadListBoxData();
                        ComposerAttributeForm.this.getOperatorField().checkKey(oldOp);
                        if (ComposerAttributeForm.this.getOperatorField().getCheckedKey() == null && CollectionUtility.hasElements((Collection)(ops = ComposerAttributeForm.this.getOperatorField().getValue()))) {
                            ComposerAttributeForm.this.getOperatorField().checkKey((IDataModelAttributeOp)CollectionUtility.firstElement((Collection)ops));
                        }
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    }
                    ComposerAttributeForm.this.activateValueField();
                }
            }

            @Order(value=2.0)
            public class OperatorField
            extends AbstractListBox<IDataModelAttributeOp> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"Op", (String[])new String[0]);
                }

                @Override
                protected List<ILookupRow<IDataModelAttributeOp>> execLoadTableData() throws ProcessingException {
                    List ops = null;
                    IDataModelAttribute att = (IDataModelAttribute)ComposerAttributeForm.this.getAttributeField().getCheckedKey();
                    if (att != null) {
                        ops = att.getOperators();
                    }
                    if (ops != null) {
                        ArrayList<ILookupRow<IDataModelAttributeOp>> result = new ArrayList<ILookupRow<IDataModelAttributeOp>>(ops.size());
                        for (IDataModelAttributeOp op : ops) {
                            String text = op.getText();
                            if (text != null && text.indexOf("{0}") >= 0) {
                                text = text.replace("{0}", "n");
                            }
                            if (text != null && text.indexOf("{1}") >= 0) {
                                text = text.replace("{1}", "m");
                            }
                            result.add((ILookupRow<IDataModelAttributeOp>)new LookupRow((Object)op, text));
                        }
                        return result;
                    }
                    return new ArrayList<ILookupRow<IDataModelAttributeOp>>(0);
                }

                @Override
                protected void execChangedValue() {
                    ComposerAttributeForm.this.activateValueField();
                }

                @Override
                protected String getConfiguredIconId() {
                    return null;
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 12;
                }

                @Override
                protected void execInitField() throws ProcessingException {
                    this.getTable().setMultiCheck(false);
                }
            }

            @Order(value=3.0)
            public class ValueField
            extends AbstractComposerValueBox {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"Value", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 12;
                }

                @Override
                protected void execChangedValue() throws ProcessingException {
                    IComposerValueField f = this.getSelectedField();
                    if (f == null) {
                        ComposerAttributeForm.this.setSelectedValuesInternal(null);
                        ComposerAttributeForm.this.setSelectedDisplayValuesInternal(null);
                    } else {
                        ComposerAttributeForm.this.setSelectedValuesInternal(f.getValues());
                        ComposerAttributeForm.this.setSelectedDisplayValuesInternal(f.getTexts());
                    }
                }
            }
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
        }
    }

    public class NewHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            ComposerAttributeForm.this.getAttributeField().getTable().selectFirstRow();
            ComposerAttributeForm.this.getOperatorField().getTable().selectFirstRow();
        }
    }
}

