/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.doublefield;

import java.math.BigDecimal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.AbstractDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

@ClassId(value="65251930-63db-4da4-ae28-9a25d75dcafb")
public abstract class AbstractDoubleField
extends AbstractDecimalField<Double>
implements IDoubleField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDoubleField.class);

    public AbstractDoubleField() {
        this(true);
    }

    public AbstractDoubleField(boolean callInitializer) {
        super(callInitializer);
    }

    @Deprecated
    protected Double getConfiguredMinimumValue() {
        return this.getConfiguredMinValue();
    }

    @Deprecated
    protected Double getConfiguredMaximumValue() {
        return this.getConfiguredMaxValue();
    }

    @Override
    @ConfigProperty(value="DOUBLE")
    @Order(value=300.0)
    @ValidationRule(value="minValue")
    protected Double getConfiguredMinValue() {
        return -1.7976931348623157E308;
    }

    @Override
    @ConfigProperty(value="DOUBLE")
    @Order(value=310.0)
    @ValidationRule(value="maxValue")
    protected Double getConfiguredMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinimumValue());
        this.setMaxValue(this.getConfiguredMaximumValue());
    }

    @Override
    public void setMinValue(Double value) {
        super.setMinValue(value == null ? -1.7976931348623157E308 : value);
    }

    @Override
    public void setMaxValue(Double value) {
        super.setMaxValue(value == null ? Double.MAX_VALUE : value);
    }

    @Override
    protected Double parseValueInternal(String text) throws ProcessingException {
        Double retVal = null;
        BigDecimal parsedVal = this.parseToBigDecimalInternal(text);
        if (parsedVal != null) {
            retVal = parsedVal.doubleValue();
        }
        return retVal;
    }
}

