/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix;

import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.MatrixIndex;

public class MatrixCursor {
    public final int startX;
    public final int startY;
    public final int columnCount;
    public final int rowCount;
    private MatrixIndex m_currentIndex = new MatrixIndex(-1, -1);
    private Orientation m_orientation;

    public MatrixCursor(int x, int y, int columnCount, int rowCount, Orientation orientation) {
        this.startX = x;
        this.startY = y;
        this.columnCount = columnCount;
        this.rowCount = rowCount;
        this.m_orientation = orientation;
    }

    public void reset() {
        this.m_currentIndex.x = -1;
        this.m_currentIndex.y = -1;
    }

    public Orientation getOrientation() {
        return this.m_orientation;
    }

    public boolean increment() {
        if (this.m_currentIndex.x < 0 || this.m_currentIndex.y < 0) {
            this.m_currentIndex.x = this.startX;
            this.m_currentIndex.y = this.startY;
        } else if (this.getOrientation() == Orientation.Horizontal) {
            ++this.m_currentIndex.x;
            if (this.m_currentIndex.x >= this.startX + this.columnCount) {
                this.m_currentIndex.x = this.startX;
                ++this.m_currentIndex.y;
            }
        } else {
            ++this.m_currentIndex.y;
            if (this.m_currentIndex.y >= this.startY + this.rowCount) {
                this.m_currentIndex.y = this.startY;
                ++this.m_currentIndex.x;
            }
        }
        return this.m_currentIndex.x < this.startX + this.columnCount && this.m_currentIndex.y < this.startY + this.rowCount;
    }

    public boolean decrement() {
        if (this.m_currentIndex.x < 0 || this.m_currentIndex.y < 0) {
            return false;
        }
        if (this.m_currentIndex.x >= this.startX + this.columnCount || this.m_currentIndex.y >= this.startY + this.rowCount) {
            this.m_currentIndex.x = this.startX + this.columnCount - 1;
            this.m_currentIndex.y = this.startY + this.rowCount - 1;
        } else if (this.getOrientation() == Orientation.Horizontal) {
            --this.m_currentIndex.x;
            if (this.m_currentIndex.x < this.startX) {
                this.m_currentIndex.x = this.startX + this.columnCount - 1;
                --this.m_currentIndex.y;
            }
        } else {
            --this.m_currentIndex.y;
            if (this.m_currentIndex.y < this.startY) {
                this.m_currentIndex.y = this.startY + this.rowCount - 1;
                --this.m_currentIndex.x;
            }
        }
        return this.m_currentIndex.x >= this.startX && this.m_currentIndex.y >= this.startY;
    }

    public MatrixIndex currentIndex() {
        return new MatrixIndex(this.m_currentIndex);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MatrixCursor [");
        builder.append("orientation=").append((Object)this.m_orientation);
        builder.append(", startX=").append(this.startX);
        builder.append(", startY=").append(this.startY);
        builder.append(", columnCount=").append(this.columnCount);
        builder.append(", rowCount=").append(this.rowCount);
        builder.append(", currentIndex=").append(this.m_currentIndex);
        builder.append("]");
        return builder.toString();
    }

    public static enum Orientation {
        Horizontal,
        Vertical;

    }
}

