/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.integerfield;

import java.math.BigDecimal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

@ClassId(value="4418100d-db7c-40e7-84b4-29df65534671")
public abstract class AbstractIntegerField
extends AbstractNumberField<Integer>
implements IIntegerField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractIntegerField.class);

    public AbstractIntegerField() {
        this(true);
    }

    public AbstractIntegerField(boolean callInitializer) {
        super(callInitializer);
    }

    @Deprecated
    protected Integer getConfiguredMinimumValue() {
        return this.getConfiguredMinValue();
    }

    @Deprecated
    protected Integer getConfiguredMaximumValue() {
        return this.getConfiguredMaxValue();
    }

    @Override
    @ConfigProperty(value="INTEGER")
    @Order(value=250.0)
    @ValidationRule(value="minValue")
    protected Integer getConfiguredMinValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    @ConfigProperty(value="INTEGER")
    @Order(value=260.0)
    @ValidationRule(value="maxValue")
    protected Integer getConfiguredMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Order(value=270.0)
    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxIntegerDigits() {
        return 10;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinimumValue());
        this.setMaxValue(this.getConfiguredMaximumValue());
    }

    @Override
    public void setMinValue(Integer value) {
        super.setMinValue(value == null ? Integer.MIN_VALUE : value);
    }

    @Override
    public void setMaxValue(Integer value) {
        super.setMaxValue(value == null ? Integer.MAX_VALUE : value);
    }

    @Override
    protected Integer parseValueInternal(String text) throws ProcessingException {
        Integer retVal = null;
        BigDecimal parsedVal = this.parseToBigDecimalInternal(text);
        if (parsedVal != null) {
            retVal = parsedVal.intValueExact();
        }
        return retVal;
    }
}

