/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.listbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTableRowBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBoxFilterBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.ActiveOrCheckedRowsFilter;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.CheckedRowsFilter;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="3dc8747d-19eb-4c0a-b5fc-c3dc2ad0783d")
public abstract class AbstractListBox<T>
extends AbstractValueField<Set<T>>
implements IListBox<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractListBox.class);
    private ITable m_table;
    private ILookupCall<T> m_lookupCall;
    private Class<? extends ICodeType<?, T>> m_codeTypeClass;
    private boolean m_valueTableSyncActive;
    private ITableRowFilter m_checkedRowsFilter;
    private ITableRowFilter m_activeRowsFilter;
    private List<IFormField> m_fields;

    public AbstractListBox() {
        this(true);
    }

    public AbstractListBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ValidationRule(value="lookupCall")
    protected Class<? extends ILookupCall<T>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType<?, T>> getConfiguredCodeType() {
        return null;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredFilterActiveRows() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredFilterCheckedRows() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    private List<Class<? extends IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation(Arrays.asList(dca), IFormField.class);
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execPrepareLookup(ILookupCall<T> call) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected List<? extends ILookupRow<T>> execLoadTableData() throws ProcessingException {
        List<ILookupRow<T>> data;
        if (this.getLookupCall() != null) {
            ILookupCall<T> call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call);
            data = call.getDataByAll();
            data = this.filterLookupResult(call, data);
        } else {
            data = this.filterLookupResult(null, null);
        }
        return data;
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execPopulateTable() throws ProcessingException {
        List<ILookupRow<T>> data = null;
        if (!this.isMasterRequired() || this.getMasterValue() != null) {
            data = this.execLoadTableData();
        }
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>();
        if (data != null) {
            for (ILookupRow<T> lr : data) {
                rows.add(this.getTableRowBuilder().createTableRow(lr));
            }
        }
        this.getTable().replaceRows(rows);
    }

    private Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List tableClasses = ConfigurationUtility.filterClasses((Class[])dca, ITable.class);
        if (tableClasses.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)tableClasses);
        }
        for (Class tableClazz : tableClasses) {
            if (tableClazz.getDeclaringClass() == AbstractListBox.class) continue;
            return tableClazz;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
        this.loadListBoxData();
    }

    @Override
    protected void initConfig() {
        this.m_fields = CollectionUtility.emptyArrayList();
        super.initConfig();
        this.setFilterActiveRows(this.getConfiguredFilterActiveRows());
        this.setFilterActiveRowsValue(TriState.TRUE);
        this.setFilterCheckedRows(this.getConfiguredFilterCheckedRows());
        this.setFilterCheckedRowsValue(this.getConfiguredFilterCheckedRows());
        try {
            this.m_table = (ITable)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTable());
            if (this.m_table instanceof AbstractTable) {
                ((AbstractTable)this.m_table).setContainerInternal(this);
            }
            this.updateActiveRowsFilter();
            this.updateCheckedRowsFilter();
            this.m_table.addTableListener(new TableAdapter(){

                @Override
                public void tableChanged(TableEvent e) {
                    switch (e.getType()) {
                        case 103: {
                            if (AbstractListBox.this.getTable().isCheckable()) break;
                            AbstractListBox.this.syncTableToValue();
                            break;
                        }
                        case 101: {
                            if (!AbstractListBox.this.getTable().isCheckable()) break;
                            AbstractListBox.this.syncTableToValue();
                        }
                    }
                }
            });
            if (this.m_table.getDefaultIconId() == null && this.getConfiguredIconId() != null) {
                this.m_table.setDefaultIconId(this.getConfiguredIconId());
            }
            this.m_table.setEnabled(this.isEnabled());
        }
        catch (Exception e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredTable().getName() + "'.", (Throwable)e));
        }
        if (this.getConfiguredLookupCall() != null) {
            try {
                ILookupCall<T> call = this.getConfiguredLookupCall().newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredLookupCall().getName() + "'.", (Throwable)e));
            }
        }
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractListBox.this.m_table != null) {
                    String name = e.getPropertyName();
                    if ("enabled".equals(name)) {
                        AbstractListBox.this.m_table.setEnabled(AbstractListBox.this.isEnabled());
                    } else if ("filterCheckedRowsValue".equals(name)) {
                        AbstractListBox.this.updateCheckedRowsFilter();
                    } else if ("filterActiveRowsValue".equals(name)) {
                        AbstractListBox.this.updateActiveRowsFilter();
                    }
                }
            }
        });
        List<Class<IFormField>> fieldClasses = this.getConfiguredFields();
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        for (Class<IFormField> fieldClazz : fieldClasses) {
            try {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldClazz);
                fieldList.add(f);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + fieldClazz.getName() + "'.", t));
            }
        }
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        this.m_fields = fieldList;
    }

    public ListBoxFilterBox getListBoxFilterBox() {
        return this.getFieldByClass((Class)ListBoxFilterBox.class);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTable().initTable();
        if (this.getConfiguredAutoLoad()) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.loadListBoxData();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTable().disposeTable();
    }

    public AbstractTableRowBuilder<T> getTableRowBuilder() {
        return new P_TableRowBuilder();
    }

    @Override
    public final ITable getTable() {
        return this.m_table;
    }

    @Override
    public boolean isFilterCheckedRows() {
        return this.propertySupport.getPropertyBool("filterCheckedRows");
    }

    @Override
    public void setFilterCheckedRows(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedRows", b);
    }

    @Override
    public boolean getFilterCheckedRowsValue() {
        return this.propertySupport.getPropertyBool("filterCheckedRowsValue");
    }

    @Override
    public void setFilterCheckedRowsValue(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedRowsValue", b);
    }

    @Override
    public boolean isFilterActiveRows() {
        return this.propertySupport.getPropertyBool("filterActiveRows");
    }

    @Override
    public void setFilterActiveRows(boolean b) {
        this.propertySupport.setPropertyBool("filterActiveRows", b);
    }

    @Override
    public TriState getFilterActiveRowsValue() {
        return (TriState)this.propertySupport.getProperty("filterActiveRowsValue");
    }

    @Override
    public void setFilterActiveRowsValue(TriState t) {
        if (t == null) {
            t = TriState.TRUE;
        }
        this.propertySupport.setProperty("filterActiveRowsValue", (Object)t);
    }

    private void updateActiveRowsFilter() {
        try {
            this.getTable().setTableChanging(true);
            if (this.m_activeRowsFilter != null) {
                this.getTable().removeRowFilter(this.m_activeRowsFilter);
                this.m_activeRowsFilter = null;
            }
            this.m_activeRowsFilter = new ActiveOrCheckedRowsFilter(this.getActiveColumnInternal(), this.getFilterActiveRowsValue());
            this.getTable().addRowFilter(this.m_activeRowsFilter);
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    private void updateCheckedRowsFilter() {
        try {
            this.getTable().setTableChanging(true);
            if (this.m_checkedRowsFilter != null) {
                this.getTable().removeRowFilter(this.m_checkedRowsFilter);
                this.m_checkedRowsFilter = null;
            }
            if (this.getFilterCheckedRowsValue()) {
                this.m_checkedRowsFilter = new CheckedRowsFilter();
                this.getTable().addRowFilter(this.m_checkedRowsFilter);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    @Override
    public void loadListBoxData() throws ProcessingException {
        if (this.getTable() != null) {
            try {
                this.m_valueTableSyncActive = true;
                this.getTable().setTableChanging(true);
                this.execPopulateTable();
            }
            finally {
                this.getTable().setTableChanging(false);
                this.m_valueTableSyncActive = false;
            }
            this.syncValueToTable();
        }
    }

    @Override
    public final void prepareLookupCall(ILookupCall<T> call) throws ProcessingException {
        this.prepareLookupCallInternal(call);
        this.execPrepareLookup(call);
    }

    private List<ILookupRow<T>> filterLookupResult(ILookupCall<T> call, List<? extends ILookupRow<T>> data) throws ProcessingException {
        ArrayList result = CollectionUtility.arrayList(data);
        this.execFilterLookupResult(call, result);
        Iterator resultIt = result.iterator();
        while (resultIt.hasNext()) {
            ILookupRow row = (ILookupRow)resultIt.next();
            if (row == null) {
                resultIt.remove();
                continue;
            }
            if (row.getKey() != null) continue;
            LOG.warn("The key of a lookup row may not be null. Row has been removed for list box '" + this.getClass().getName() + "'.");
            resultIt.remove();
        }
        return result;
    }

    private void prepareLookupCallInternal(ILookupCall<T> call) {
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    @Override
    public final ILookupCall<T> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<T> call) {
        this.m_lookupCall = call;
    }

    @Override
    public Class<? extends ICodeType<?, T>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, T>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToTable();
    }

    @Override
    protected String formatValueInternal(Set<T> validValue) {
        if (!CollectionUtility.hasElements(validValue)) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        List<ITableRow> rows = this.getKeyColumnInternal().findRows(validValue);
        if (CollectionUtility.hasElements(rows)) {
            Iterator<ITableRow> rowIt = rows.iterator();
            b.append(this.getTextColumnInternal().getValue(rowIt.next()));
            while (rowIt.hasNext()) {
                b.append(", ");
                b.append(this.getTextColumnInternal().getValue(rowIt.next()));
            }
        }
        return b.toString();
    }

    @Override
    protected final Set<T> validateValueInternal(Set<T> rawValue0) throws ProcessingException {
        HashSet rawValue = CollectionUtility.hashSetWithoutNullElements(rawValue0);
        return this.doValidateValueInternal(rawValue);
    }

    protected Set<T> doValidateValueInternal(Set<T> rawValue) throws ProcessingException {
        if (CollectionUtility.isEmpty(rawValue)) {
            return rawValue;
        }
        ITable table = this.getTable();
        if (table != null && (table.isCheckable() && !table.isMultiCheck() || !table.isCheckable() && !table.isMultiSelect()) && rawValue.size() > 1) {
            LOG.warn(String.valueOf(this.getClass().getName()) + " only accepts a single value. Got " + CollectionUtility.format(rawValue) + ". Using only first value.");
            return CollectionUtility.hashSet((Object)CollectionUtility.firstElement(rawValue));
        }
        return rawValue;
    }

    @Override
    public boolean isContentValid() {
        boolean valid = super.isContentValid();
        if (valid && this.isMandatory() && (this.getValue() == null || this.getValue().isEmpty())) {
            return false;
        }
        return valid;
    }

    @Override
    public Set<T> getValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getValue()));
    }

    @Override
    public Set<T> getInitValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getInitValue()));
    }

    @Override
    public T getSingleValue() {
        return (T)CollectionUtility.firstElement((Collection)((Collection)super.getValue()));
    }

    @Override
    public void setSingleValue(T value) {
        HashSet<T> valueSet = new HashSet<T>();
        if (value != null) {
            valueSet.add(value);
        }
        this.setValue(valueSet);
    }

    @Override
    public int getCheckedKeyCount() {
        Set value = (Set)super.getValue();
        if (value != null) {
            return value.size();
        }
        return 0;
    }

    @Override
    public T getCheckedKey() {
        return (T)CollectionUtility.firstElement(this.getCheckedKeys());
    }

    @Override
    public Set<T> getCheckedKeys() {
        return this.getValue();
    }

    @Override
    public ILookupRow<T> getCheckedLookupRow() {
        return (ILookupRow)CollectionUtility.firstElement(this.getCheckedLookupRows());
    }

    @Override
    public Set<ILookupRow<T>> getCheckedLookupRows() {
        Collection<ITableRow> checkedRows = this.getTable().getCheckedRows();
        HashSet<ILookupRow<T>> result = new HashSet<ILookupRow<T>>(checkedRows.size());
        for (ITableRow row : checkedRows) {
            ICell cell = row.getCell(1);
            result.add((ILookupRow<T>)new LookupRow(row.getCellValue(0), cell.getText(), cell.getIconId(), cell.getTooltipText(), cell.getBackgroundColor(), cell.getForegroundColor(), cell.getFont(), cell.isEnabled()));
        }
        return result;
    }

    @Override
    public void checkKey(T key) {
        if (key == null) {
            this.checkKeys(null);
        } else {
            this.checkKeys(CollectionUtility.hashSet(key));
        }
    }

    @Override
    public void checkKeys(Collection<? extends T> keys) {
        this.setValue(CollectionUtility.hashSetWithoutNullElements(keys));
    }

    @Override
    public void uncheckAllKeys() {
        this.checkKeys(null);
    }

    @Override
    public Set<T> getUncheckedKeys() {
        Set<T> checkedKeys;
        HashSet result = new HashSet();
        Object initValue = this.getInitValue();
        if (initValue != null) {
            result.addAll(initValue);
        }
        if ((checkedKeys = this.getCheckedKeys()) != null) {
            result.removeAll(checkedKeys);
        }
        return result;
    }

    @Override
    public void checkAllKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues());
    }

    @Override
    public void checkAllActiveKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues(this.getActiveColumnInternal().findRows(true)));
    }

    @Override
    public void uncheckAllInactiveKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues(this.getActiveColumnInternal().findRows(false)));
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        AbstractValueFieldData v = (AbstractValueFieldData)target;
        Object value = this.getValue();
        if (CollectionUtility.isEmpty((Collection)value)) {
            v.setValue(null);
        } else {
            v.setValue((Object)CollectionUtility.hashSet((Collection)this.getValue()));
        }
    }

    private IColumn<T> getKeyColumnInternal() {
        return this.getTable().getColumnSet().getColumn(0);
    }

    private IColumn<String> getTextColumnInternal() {
        return this.getTable().getColumnSet().getColumn(1);
    }

    private IColumn<Boolean> getActiveColumnInternal() {
        return this.getTable().getColumnSet().getColumn(2);
    }

    private void syncValueToTable() {
        if (this.m_valueTableSyncActive) {
            return;
        }
        try {
            this.m_valueTableSyncActive = true;
            this.getTable().setTableChanging(true);
            Set<T> checkedKeys = this.getCheckedKeys();
            List<ITableRow> checkedRows = this.getKeyColumnInternal().findRows(checkedKeys);
            for (ITableRow row : this.getTable().getRows()) {
                row.setChecked(false);
            }
            for (ITableRow row : checkedRows) {
                row.setChecked(true);
            }
            if (!this.getTable().isCheckable()) {
                this.getTable().selectRows(checkedRows, false);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
            this.m_valueTableSyncActive = false;
        }
    }

    private void syncTableToValue() {
        if (this.m_valueTableSyncActive) {
            return;
        }
        try {
            this.m_valueTableSyncActive = true;
            this.m_table.setTableChanging(true);
            Collection<ITableRow> checkedRows = this.getTable().isCheckable() ? this.getTable().getCheckedRows() : this.getTable().getSelectedRows();
            this.checkKeys(this.getKeyColumnInternal().getValues(checkedRows));
            if (!this.getTable().isCheckable()) {
                for (ITableRow row : this.m_table.getRows()) {
                    row.setChecked(row.isSelected());
                }
            }
        }
        finally {
            this.getTable().setTableChanging(false);
            this.m_valueTableSyncActive = false;
        }
        if (!this.m_table.getUIFacade().isUIProcessing()) {
            this.updateActiveRowsFilter();
        }
        this.updateCheckedRowsFilter();
    }

    public <F extends IFormField> F getFieldByClass(final Class<F> c) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (F)((IFormField)found.getValue());
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    public <X extends IFormField> X getFieldById(final String id, final Class<X> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (X)((IFormField)found.getValue());
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        for (IFormField field : this.m_fields) {
            if (field instanceof ICompositeField ? !((ICompositeField)field).visitFields(visitor, startLevel + 1) : !visitor.visitField(field, startLevel, index)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public final int getGridColumnCount() {
        return 1;
    }

    @Override
    public final int getGridRowCount() {
        return 1;
    }

    @Override
    public void rebuildFieldGrid() {
        GridData gd = this.getListBoxFilterBox().getGridDataHints();
        gd.x = 0;
        gd.y = 0;
        this.getListBoxFilterBox().setGridDataInternal(gd);
    }

    public class DefaultListBoxTable
    extends AbstractTable {
        @Override
        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        @Override
        protected boolean getConfiguredHeaderVisible() {
            return false;
        }

        @Override
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        @Override
        protected boolean getConfiguredCheckable() {
            return true;
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.KeyColumn getKeyColumn() {
            return this.getColumnSet().getColumnByClass(KeyColumn.class);
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.TextColumn getTextColumn() {
            return this.getColumnSet().getColumnByClass(TextColumn.class);
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.ActiveColumn getActiveColumn() {
            return this.getColumnSet().getColumnByClass(ActiveColumn.class);
        }

        @Order(value=3.0)
        public class ActiveColumn
        extends AbstractBooleanColumn {
            @Override
            protected boolean getConfiguredDisplayable() {
                return false;
            }
        }

        @Order(value=1.0)
        public class KeyColumn
        extends AbstractColumn<T> {
            @Override
            protected boolean getConfiguredPrimaryKey() {
                return true;
            }

            @Override
            protected boolean getConfiguredDisplayable() {
                return false;
            }

            @Override
            public Class<T> getDataType() {
                return TypeCastUtility.getGenericsParameterClass(AbstractListBox.this.getClass(), IListBox.class);
            }
        }

        @Order(value=2.0)
        public class TextColumn
        extends AbstractStringColumn {
        }
    }

    @Order(value=1.0)
    public class ListBoxFilterBox
    extends AbstractListBoxFilterBox {
        @Override
        protected IListBox getListBox() {
            return AbstractListBox.this;
        }
    }

    private class P_TableRowBuilder
    extends AbstractTableRowBuilder<T> {
        private P_TableRowBuilder() {
        }

        @Override
        protected ITableRow createEmptyTableRow() {
            return new TableRow(AbstractListBox.this.getTable().getColumnSet());
        }

        @Override
        public ITableRow createTableRow(ILookupRow<T> dataRow) throws ProcessingException {
            TableRow tableRow = (TableRow)super.createTableRow(dataRow);
            AbstractListBox.this.getKeyColumnInternal().setValue(tableRow, dataRow.getKey());
            AbstractListBox.this.getTextColumnInternal().setValue(tableRow, dataRow.getText());
            AbstractListBox.this.getActiveColumnInternal().setValue(tableRow, Boolean.valueOf(dataRow.isActive()));
            Cell cell = tableRow.getCellForUpdate(1);
            cell.setEnabled(dataRow.isEnabled());
            if (!dataRow.isActive()) {
                if (cell.getFont() == null) {
                    cell.setFont(FontSpec.parse((String)"italic"));
                }
                AbstractListBox.this.getTextColumnInternal().setValue(tableRow, String.valueOf(dataRow.getText()) + " (" + ScoutTexts.get((String)"InactiveState", (String[])new String[0]) + ")");
            }
            return tableRow;
        }
    }
}

