/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.mailfield;

import java.io.File;
import java.net.URL;
import javax.mail.internet.MimeMessage;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.mailfield.IMailField;
import org.eclipse.scout.rt.client.ui.form.fields.mailfield.IMailFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="35e1fd57-3c86-4c99-92ca-188c3c2dedde")
public abstract class AbstractMailField
extends AbstractValueField<MimeMessage>
implements IMailField {
    private IMailFieldUIFacade m_uiFacade;
    private boolean m_mailEditor;
    private boolean m_scrollBarEnabled;

    public AbstractMailField() {
        this(true);
    }

    public AbstractMailField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredMailEditor() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=260.0)
    protected String getConfiguredLabelFrom() {
        return ScoutTexts.get((String)"EmailFrom", (String[])new String[0]);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=270.0)
    protected String getConfiguredLabelTo() {
        return ScoutTexts.get((String)"EmailTo", (String[])new String[0]);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=280.0)
    protected String getConfiguredLabelCc() {
        return ScoutTexts.get((String)"EmailCc", (String[])new String[0]);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=290.0)
    protected String getConfiguredLabelSubject() {
        return ScoutTexts.get((String)"EmailSubject", (String[])new String[0]);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=300.0)
    protected String getConfiguredLabelSent() {
        return ScoutTexts.get((String)"EmailSent", (String[])new String[0]);
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execAttachementAction(File file) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.m_mailEditor = this.getConfiguredMailEditor();
        this.m_scrollBarEnabled = this.getConfiguredScrollBarEnabled();
        this.setLabelFrom(this.getConfiguredLabelFrom());
        this.setLabelTo(this.getConfiguredLabelTo());
        this.setLabelCc(this.getConfiguredLabelCc());
        this.setLabelSent(this.getConfiguredLabelSent());
        this.setLabelSubject(this.getConfiguredLabelSubject());
    }

    @Override
    public void setLabelFrom(String fromLabel) {
        this.propertySupport.setPropertyString("labelFrom", fromLabel);
    }

    @Override
    public String getLabelFrom() {
        return this.propertySupport.getPropertyString("labelFrom");
    }

    @Override
    public void setLabelTo(String toLabel) {
        this.propertySupport.setPropertyString("labelTo", toLabel);
    }

    @Override
    public String getLabelTo() {
        return this.propertySupport.getPropertyString("labelTo");
    }

    @Override
    public void setLabelCc(String ccLabel) {
        this.propertySupport.setPropertyString("labelCC", ccLabel);
    }

    @Override
    public String getLabelCc() {
        return this.propertySupport.getPropertyString("labelCC");
    }

    @Override
    public void setLabelSubject(String subjectLabel) {
        this.propertySupport.setPropertyString("labelSubject", subjectLabel);
    }

    @Override
    public String getLabelSubject() {
        return this.propertySupport.getPropertyString("labelSubject");
    }

    @Override
    public void setLabelSent(String sentLabel) {
        this.propertySupport.setProperty("labelSent", (Object)sentLabel);
    }

    @Override
    public String getLabelSent() {
        return this.propertySupport.getPropertyString("labelSent");
    }

    @Override
    public IMailFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public boolean isMailEditor() {
        return this.m_mailEditor;
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.m_scrollBarEnabled;
    }

    public void doAttachementAction(File file) throws ProcessingException {
        this.execAttachementAction(file);
    }

    public void doHyperlinkAction(URL url) throws ProcessingException {
        this.execHyperlinkAction(url, url.getPath(), url != null && url.getHost().equals("local"));
    }

    private class P_UIFacade
    implements IMailFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setMailFromUI(MimeMessage message) {
            if (AbstractMailField.this.isMailEditor()) {
                AbstractMailField.this.setValue(message);
            }
            return true;
        }

        @Override
        public void fireAttachementActionFromUI(File file) {
            try {
                AbstractMailField.this.doAttachementAction(file);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        @Override
        public void fireHyperlinkActionFromUI(URL url) {
            try {
                AbstractMailField.this.doHyperlinkAction(url);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }
}

