/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.messagebox;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.BlockingCondition;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBoxUIFacade;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.shared.OfficialVersion;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class MessageBox
extends AbstractPropertyObserver
implements IMessageBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MessageBox.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private final IMessageBoxUIFacade m_uiFacade;
    private long m_autoCloseMillis;
    private String m_title;
    private String m_iconId;
    private String m_introText;
    private String m_actionText;
    private String m_yesButtonText;
    private String m_noButtonText;
    private String m_cancelButtonText;
    private String m_hiddenText;
    private String m_copyPasteText;
    private String m_copyPasteTextInternal;
    private final BlockingCondition m_blockingCondition = new BlockingCondition(false);
    private Job m_autoCloseJob;
    private int m_answer;
    private boolean m_answerSet;
    private int m_severity;

    public static int showOkMessage(String title, String header, String info) {
        MessageBox mbox = new MessageBox(title, header, info, ScoutTexts.get((String)"OkButton", (String[])new String[0]), null, null);
        return mbox.startMessageBox();
    }

    public static int showYesNoMessage(String title, String header, String info) {
        MessageBox mbox = new MessageBox(title, header, info, ScoutTexts.get((String)"YesButton", (String[])new String[0]), ScoutTexts.get((String)"NoButton", (String[])new String[0]), null);
        return mbox.startMessageBox();
    }

    public static int showYesNoCancelMessage(String title, String header, String info) {
        MessageBox mbox = new MessageBox(title, header, info, ScoutTexts.get((String)"YesButton", (String[])new String[0]), ScoutTexts.get((String)"NoButton", (String[])new String[0]), ScoutTexts.get((String)"CancelButton", (String[])new String[0]));
        return mbox.startMessageBox();
    }

    public static boolean showDeleteConfirmationMessage(Object items) {
        return MessageBox.showDeleteConfirmationMessage(null, items);
    }

    public static boolean showDeleteConfirmationMessage(String itemType, Object items) {
        Object array = items == null ? new Object[]{} : (items.getClass().isArray() ? items : new Object[]{items});
        StringBuilder t = new StringBuilder();
        int n = Array.getLength(array);
        int i = 0;
        while (i < n) {
            if (i < 10 || i == n - 1) {
                t.append("- ");
                t.append(StringUtility.emptyIfNull((Object)Array.get(array, i)));
                t.append("\n");
            } else if (i == 10) {
                t.append("  ...\n");
            }
            ++i;
        }
        String intro = null;
        String action = null;
        if (itemType != null) {
            intro = n > 0 ? ScoutTexts.get((String)"DeleteConfirmationTextX", (String[])new String[]{itemType}) : ScoutTexts.get((String)"DeleteConfirmationTextNoItemListX", (String[])new String[]{itemType});
            action = n > 0 ? t.toString() : null;
        } else {
            intro = n > 0 ? ScoutTexts.get((String)"DeleteConfirmationText", (String[])new String[0]) : ScoutTexts.get((String)"DeleteConfirmationTextNoItemList", (String[])new String[0]);
            action = n > 0 ? t.toString() : null;
        }
        MessageBox mbox = new MessageBox(ScoutTexts.get((String)"DeleteConfirmationTitle", (String[])new String[0]), intro, action, ScoutTexts.get((String)"YesButton", (String[])new String[0]), ScoutTexts.get((String)"NoButton", (String[])new String[0]), null);
        return mbox.startMessageBox() == 0;
    }

    public MessageBox(String title, String introText, String okButtonText) {
        this(title, introText, null, okButtonText, null, null);
    }

    public MessageBox(String title, String introText, String actionText, String yesButtonText, String noButtonText, String cancelButtonText) {
        this(title, introText, actionText, yesButtonText, noButtonText, cancelButtonText, null, null);
    }

    public MessageBox(String title, String introText, String actionText, String yesButtonText, String noButtonText, String cancelButtonText, String hiddenText, String iconId) {
        IDesktop desktop;
        this.m_uiFacade = new P_UIFacade();
        this.m_title = title;
        this.m_introText = introText;
        this.m_actionText = actionText;
        this.m_hiddenText = hiddenText;
        this.m_yesButtonText = yesButtonText;
        this.m_noButtonText = noButtonText;
        this.m_cancelButtonText = cancelButtonText;
        this.m_iconId = iconId;
        this.m_autoCloseMillis = -1L;
        if (this.m_title == null && (desktop = ClientSyncJob.getCurrentSession().getDesktop()) != null) {
            this.m_title = desktop.getTitle();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public void setTitle(String s) {
        this.m_title = s;
        this.m_copyPasteTextInternal = null;
    }

    @Override
    public String getIntroText() {
        return this.m_introText;
    }

    @Override
    public void setIntroText(String s) {
        this.m_introText = s;
        this.m_copyPasteTextInternal = null;
    }

    @Override
    public String getActionText() {
        return this.m_actionText;
    }

    @Override
    public void setActionText(String s) {
        this.m_actionText = s;
        this.m_copyPasteTextInternal = null;
    }

    @Override
    public String getHiddenText() {
        return this.m_hiddenText;
    }

    @Override
    public void setHiddenText(String s) {
        this.m_hiddenText = s;
        this.m_copyPasteTextInternal = null;
    }

    @Override
    public String getYesButtonText() {
        return this.m_yesButtonText;
    }

    @Override
    public void setYesButtonText(String s) {
        this.m_yesButtonText = s;
    }

    @Override
    public String getNoButtonText() {
        return this.m_noButtonText;
    }

    @Override
    public void setNoButtonText(String s) {
        this.m_noButtonText = s;
    }

    @Override
    public String getCancelButtonText() {
        return this.m_cancelButtonText;
    }

    @Override
    public void setCancelButtonText(String s) {
        this.m_cancelButtonText = s;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String iconId) {
        this.m_iconId = iconId;
    }

    @Override
    public int getSeverity() {
        return this.m_severity;
    }

    @Override
    public void setSeverity(int severity) {
        this.m_severity = severity;
    }

    @Override
    public long getAutoCloseMillis() {
        return this.m_autoCloseMillis;
    }

    @Override
    public void setAutoCloseMillis(long millis) {
        this.m_autoCloseMillis = millis;
    }

    @Override
    public String getCopyPasteText() {
        if (this.m_copyPasteText == null) {
            this.updateCopyPasteTextInternal();
            return this.m_copyPasteTextInternal;
        }
        return this.m_copyPasteText;
    }

    @Override
    public void setCopyPasteText(String s) {
        this.m_copyPasteText = s;
    }

    private void updateCopyPasteTextInternal() {
        if (this.m_copyPasteTextInternal == null) {
            StringBuffer buf = new StringBuffer();
            if (OfficialVersion.customCopyrightText != null) {
                buf.append(String.valueOf(OfficialVersion.customCopyrightText) + "\n");
            } else {
                buf.append(String.valueOf(OfficialVersion.COPYRIGHT) + "\n");
            }
            buf.append("java.vm.version: " + System.getProperty("java.vm.version") + "\n");
            buf.append("os.name_version: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n");
            buf.append("user.name: " + System.getProperty("user.name") + "\n");
            buf.append("\n");
            if (this.m_title != null) {
                buf.append(String.valueOf(this.m_title) + "\n\n");
            }
            if (this.m_introText != null) {
                buf.append(String.valueOf(this.m_introText) + "\n\n");
            }
            if (this.m_actionText != null) {
                buf.append(String.valueOf(this.m_actionText) + "\n\n");
            }
            if (this.m_hiddenText != null) {
                buf.append(String.valueOf(this.m_hiddenText) + "\n\n");
            }
            this.m_copyPasteTextInternal = buf.toString();
        }
    }

    @Override
    public void addMessageBoxListener(MessageBoxListener listener) {
        this.m_listenerList.add(MessageBoxListener.class, (EventListener)listener);
    }

    @Override
    public void removeMessageBoxListener(MessageBoxListener listener) {
        this.m_listenerList.remove(MessageBoxListener.class, (EventListener)listener);
    }

    private void fireClosed() {
        this.fireMessageBoxEvent(new MessageBoxEvent(this, 900));
    }

    private void fireMessageBoxEvent(MessageBoxEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(MessageBoxListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((MessageBoxListener)listeners[i]).messageBoxChanged(e);
                ++i;
            }
        }
    }

    @Override
    public IMessageBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public boolean isOpen() {
        return this.m_blockingCondition.isBlocking();
    }

    @Override
    public int startMessageBox() {
        return this.startMessageBox(2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int startMessageBox(int defaultResult) {
        this.m_answerSet = false;
        this.m_answer = defaultResult;
        if (ClientSyncJob.getCurrentSession() != null) {
            this.m_blockingCondition.setBlocking(true);
            try {
                IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                if (desktop == null || !desktop.isOpened()) {
                    LOG.warn("there is no desktop or the desktop has not yet been opened in the ui, default answer is CANCEL");
                    this.m_answerSet = true;
                    this.m_answer = 2;
                    return this.m_answer;
                }
                desktop.addMessageBox(this);
                if (this.getAutoCloseMillis() > 0L) {
                    long dt = this.getAutoCloseMillis();
                    this.m_autoCloseJob = new Job("Auto-close " + this.getTitle()){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (this == MessageBox.this.m_autoCloseJob) {
                                MessageBox.this.closeMessageBox();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    this.m_autoCloseJob.schedule(dt);
                }
                this.waitFor();
                if (this.m_autoCloseJob == null) return this.m_answer;
                this.m_autoCloseJob.cancel();
                this.m_autoCloseJob = null;
                return this.m_answer;
            }
            finally {
                this.fireClosed();
            }
        } else {
            LOG.warn("outside ScoutSessionThread, default answer is CANCEL");
            this.m_answerSet = true;
            this.m_answer = 2;
        }
        return this.m_answer;
    }

    private void waitFor() {
        try {
            this.m_blockingCondition.waitFor();
        }
        catch (InterruptedException e) {
            LOG.info(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0]));
        }
    }

    private void closeMessageBox() {
        this.m_autoCloseJob = null;
        this.m_blockingCondition.setBlocking(false);
    }

    private class P_UIFacade
    implements IMessageBoxUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setResultFromUI(int option) {
            switch (option) {
                case 0: 
                case 1: 
                case 2: {
                    if (!MessageBox.this.m_answerSet) {
                        MessageBox.this.m_answerSet = true;
                        MessageBox.this.m_answer = option;
                    }
                    MessageBox.this.closeMessageBox();
                }
            }
        }
    }
}

