/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.runtime.ExtensionPointTracker;
import org.eclipse.scout.rt.extension.client.internal.IExtensionProcessor;
import org.osgi.framework.Bundle;

public abstract class AbstractExtensionManager
implements ExtensionPointTracker.Listener {
    protected final IScoutLogger LOG = ScoutLogManager.getLogger(this.getClass());
    private final String m_extensionPointId;
    private final ExtensionPointTracker m_tracker;
    private final Map<IExtension, Set<Object>> m_extensionContributionsMap;
    private final Map<String, IExtensionProcessor<?>> m_extensionProcessors;

    public AbstractExtensionManager(IExtensionRegistry registry, String extensionPointId) {
        if (registry == null) {
            throw new IllegalArgumentException("registry must not be null");
        }
        if (!StringUtility.hasText((String)extensionPointId) || registry.getExtensionPoint(extensionPointId) == null) {
            throw new IllegalArgumentException("extension point does not exist [" + extensionPointId + "]");
        }
        this.m_extensionPointId = extensionPointId;
        this.m_tracker = new ExtensionPointTracker(registry, extensionPointId, (ExtensionPointTracker.Listener)this);
        this.m_extensionContributionsMap = new HashMap<IExtension, Set<Object>>();
        this.m_extensionProcessors = new HashMap();
    }

    public void start() {
        this.m_tracker.open();
    }

    public void stop() {
        this.m_tracker.close();
    }

    protected Object getLock() {
        return this.m_tracker.getTrackerLock();
    }

    protected void ensureStarted() {
        this.start();
    }

    public void addExtensionProcessor(String elementName, IExtensionProcessor<?> processor) {
        this.m_extensionProcessors.put(elementName, processor);
    }

    public void removeExtensionProcessor(String elementName) {
        this.m_extensionProcessors.remove(elementName);
    }

    public void added(IExtension extension) {
        Bundle contributor = Platform.getBundle((String)extension.getContributor().getName());
        if (contributor == null) {
            this.LOG.info("conributor bundle not found for id '" + extension.getContributor().getName() + "'");
            return;
        }
        HashSet contributions = new HashSet();
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String active = element.getAttribute("active");
                if (active != null && !((Boolean)TypeCastUtility.castValue((Object)active, Boolean.TYPE)).booleanValue()) {
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info("ignoring inactive extension " + element.getName());
                    }
                } else {
                    IExtensionProcessor<?> processor = this.m_extensionProcessors.get(element.getName());
                    if (processor == null) {
                        this.LOG.warn("unsupported element [" + element.getName() + "]");
                    } else {
                        Object contribution = processor.processConfigurationElement(contributor, element);
                        if (contribution != null) {
                            contributions.add(contribution);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.LOG.error("could not load extension [" + this.m_extensionPointId + " / " + element.getName() + "] for " + element + " in " + extension.getContributor(), (Throwable)e);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(IExtension extension) {
        Object object = this.getLock();
        synchronized (object) {
            Set<Object> contributions = this.m_extensionContributionsMap.remove(extension);
            if (contributions != null && !contributions.isEmpty()) {
                this.removeContributions(contributions);
            }
        }
    }

    protected void addContributions(IExtension extension, Set<Object> contributions) {
        if (contributions.isEmpty()) {
            return;
        }
        this.m_extensionContributionsMap.put(extension, contributions);
    }

    protected abstract void removeContributions(Set<Object> var1);

    public static <T> Class<? extends T> loadClass(Bundle bundle, Class<T> type, String classname) throws ProcessingException, ClassNotFoundException {
        if (bundle == null || !StringUtility.hasText((String)classname)) {
            return null;
        }
        Class cl = bundle.loadClass(classname);
        if (type != null && !type.isAssignableFrom(cl)) {
            throw new ProcessingException("class [" + classname + "] is not instance of [" + type.getName() + "]");
        }
        return cl;
    }
}

