/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.action.menu.internal;

import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuExtensionFilter;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.AbstractMenuExtension;

public class MenuContributionExtension
extends AbstractMenuExtension {
    private final double m_order;

    public MenuContributionExtension(Class<? extends IMenu> menuClass, IMenuExtensionFilter filter, Double order) {
        super(menuClass, filter);
        this.m_order = (Double)NumberUtility.nvl((Object)order, (Object)Double.MAX_VALUE);
    }

    public double getOrder() {
        return this.m_order;
    }

    public IMenu createContribution(Object anchor, Object container) throws ProcessingException {
        IMenu menu;
        if (anchor == null || container == null) {
            throw new IllegalArgumentException("anchor or container must not be null");
        }
        if (anchor != container) {
            menu = (IMenu)BeanUtility.createInstance(this.getMenuClass(), (Object[])new Object[]{anchor, container});
            if (menu != null) {
                return menu;
            }
            menu = (IMenu)BeanUtility.createInstance(this.getMenuClass(), (Object[])new Object[]{container, anchor});
            if (menu != null) {
                return menu;
            }
            menu = (IMenu)BeanUtility.createInstance(this.getMenuClass(), (Object[])new Object[]{container});
            if (menu != null) {
                return menu;
            }
        }
        if ((menu = (IMenu)BeanUtility.createInstance(this.getMenuClass(), (Object[])new Object[]{anchor})) != null) {
            return menu;
        }
        if (anchor == container && (menu = (IMenu)BeanUtility.createInstance(this.getMenuClass(), (Object[])new Object[]{anchor, anchor})) != null) {
            return menu;
        }
        menu = (IMenu)BeanUtility.createInstance(this.getMenuClass(), (Object[])new Object[0]);
        if (menu != null) {
            return menu;
        }
        throw new ProcessingException("Cannot create new instance of class [" + this.getMenuClass() + "] with argument anchor=[" + anchor + "], container=[" + container + "]");
    }
}

