/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.servicetunnel;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.VersionMismatchException;
import org.eclipse.scout.service.ServiceUtility;

public abstract class AbstractServiceTunnel<T extends ISession>
implements IServiceTunnel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractServiceTunnel.class);
    private final String m_version;
    private URL m_serverURL;
    private final T m_session;

    public AbstractServiceTunnel(T session, String version) {
        this.m_session = session;
        this.m_version = AbstractServiceTunnel.getVersion(version);
    }

    private static String getVersion(String providedVersion) {
        if (providedVersion == null && Platform.getProduct() != null) {
            return (String)Platform.getProduct().getDefiningBundle().getHeaders().get("Bundle-Version");
        }
        return providedVersion;
    }

    public String getVersion() {
        return this.m_version;
    }

    @Override
    public URL getServerURL() {
        return this.m_serverURL;
    }

    @Override
    public void setServerURL(URL url) {
        this.m_serverURL = url;
    }

    protected T getSession() {
        return this.m_session;
    }

    public Object invokeService(Class serviceInterfaceClass, Method operation, Object[] callerArgs) throws ProcessingException {
        if (this.getServerURL() == null) {
            throw new ProcessingException("serverURL is null. Check proxyHandler extension. Example value is: http://localhost:8080/myapp/process");
        }
        long t0 = System.nanoTime();
        try {
            if (callerArgs == null) {
                callerArgs = new Object[]{};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(serviceInterfaceClass + "." + operation + "(" + Arrays.asList(callerArgs) + ")");
            }
            Object[] serializableArgs = ServiceUtility.filterHolderArguments((Object[])callerArgs);
            ServiceTunnelRequest call = new ServiceTunnelRequest(this.getVersion(), serviceInterfaceClass, operation, serializableArgs);
            call.setClientSubject(this.m_session.getSubject());
            call.setVirtualSessionId(this.m_session.getVirtualSessionId());
            call.setUserAgent(this.m_session.getUserAgent().createIdentifier());
            this.decorateServiceRequest(call);
            ServiceTunnelResponse response = this.tunnel(call);
            if (response == null) {
                response = new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException());
            }
            this.onInvokeService(t0, response);
            Throwable t = response.getException();
            if (t != null) {
                VersionMismatchException pe;
                String msg = "Calling " + serviceInterfaceClass.getSimpleName() + "." + operation.getName() + "()";
                if (t instanceof VersionMismatchException) {
                    VersionMismatchException ve;
                    pe = ve = (VersionMismatchException)t;
                } else if (t instanceof ProcessingException) {
                    ((ProcessingException)t).addContextMessage(msg);
                    pe = (ProcessingException)t;
                } else {
                    pe = new ProcessingException(msg, t);
                }
                StackTraceElement[] trace1 = pe.getStackTrace();
                StackTraceElement[] trace2 = new Exception().getStackTrace();
                StackTraceElement[] both = new StackTraceElement[trace1.length + trace2.length];
                System.arraycopy(trace1, 0, both, 0, trace1.length);
                System.arraycopy(trace2, 0, both, trace1.length, trace2.length);
                pe.setStackTrace(both);
                throw pe;
            }
            ServiceUtility.updateHolderArguments((Object[])callerArgs, (Object[])response.getOutVars(), (boolean)false);
            return response.getData();
        }
        catch (Throwable t) {
            if (t instanceof ProcessingException) {
                throw (ProcessingException)t;
            }
            throw new ProcessingException(String.valueOf(serviceInterfaceClass.getSimpleName()) + "." + operation.getName() + "(" + VerboseUtility.dumpObjects((Object[])callerArgs) + ")", t);
        }
    }

    protected void decorateServiceRequest(ServiceTunnelRequest call) {
    }

    protected void onInvokeService(long t0, ServiceTunnelResponse response) {
    }

    protected abstract ServiceTunnelResponse tunnel(ServiceTunnelRequest var1);
}

