/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.servicetunnel.http.internal;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.servicetunnel.Activator;
import org.eclipse.scout.rt.servicetunnel.http.internal.AbstractInternalHttpServiceTunnel;
import org.eclipse.scout.rt.shared.servicetunnel.HttpException;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;

public class HttpBackgroundExecutable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(HttpBackgroundExecutable.class);
    private final Object m_callerLock;
    private final ServiceTunnelRequest m_req;
    private ServiceTunnelResponse m_res;
    private final AbstractInternalHttpServiceTunnel m_tunnel;
    private URLConnection m_urlConn;
    private boolean m_debug;

    public HttpBackgroundExecutable(ServiceTunnelRequest req, Object callerLock, AbstractInternalHttpServiceTunnel tunnel) {
        this.m_req = req;
        this.m_callerLock = callerLock;
        this.m_tunnel = tunnel;
        this.m_debug = HttpBackgroundExecutable.isDebug();
    }

    private static boolean isDebug() {
        String text = null;
        if (Activator.getDefault() != null) {
            text = Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.rt.client.http.debug");
        }
        return text != null && text.equalsIgnoreCase("true");
    }

    public ServiceTunnelResponse getResponse() {
        return this.m_res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        InputStream httpin;
        block31: {
            byte[] callData;
            long time2;
            long time1;
            block29: {
                IStatus iStatus2;
                block30: {
                    httpin = null;
                    this.delayForDebug(this.m_req, 0L);
                    time1 = 0L;
                    time2 = 0L;
                    if (this.m_debug) {
                        time1 = System.nanoTime();
                    }
                    ByteArrayOutputStream msgout = new ByteArrayOutputStream();
                    this.m_tunnel.getContentHandler().writeRequest((OutputStream)msgout, this.m_req);
                    msgout.close();
                    callData = msgout.toByteArray();
                    this.m_urlConn = this.m_tunnel.createURLConnection(this.m_req, callData);
                    int code = this.m_urlConn instanceof HttpURLConnection ? ((HttpURLConnection)this.m_urlConn).getResponseCode() : 200;
                    this.m_tunnel.preprocessHttpRepsonse(this.m_urlConn, this.m_req, code);
                    if (code == 0 || code >= 200 && code <= 299) break block29;
                    this.m_res = new ServiceTunnelResponse(code, null, null, (Throwable)new HttpException(code));
                    iStatus2 = Status.CANCEL_STATUS;
                    if (httpin == null) break block30;
                    try {
                        httpin.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Object object = this.m_callerLock;
                synchronized (object) {
                    this.m_callerLock.notifyAll();
                }
                return iStatus2;
            }
            httpin = this.m_urlConn.getInputStream();
            this.m_res = this.m_tunnel.getContentHandler().readResponse(httpin);
            httpin.close();
            httpin = null;
            if (this.m_debug) {
                time2 = System.nanoTime();
                LOG.debug("TIME " + this.m_req.getServiceInterfaceClassName() + "." + this.m_req.getOperation() + " " + (time2 - time1) / 1000000L + "ms " + callData.length + " bytes");
            }
            iStatus = Status.OK_STATUS;
            if (httpin == null) break block31;
            try {
                httpin.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Object object = this.m_callerLock;
        synchronized (object) {
            this.m_callerLock.notifyAll();
        }
        return iStatus;
        catch (Throwable e) {
            IStatus iStatus3;
            block32: {
                try {
                    if (this.m_res == null) {
                        this.m_res = new ServiceTunnelResponse(null, null, e);
                    }
                    iStatus3 = Status.CANCEL_STATUS;
                    if (httpin == null) break block32;
                }
                catch (Throwable throwable) {
                    if (httpin != null) {
                        try {
                            httpin.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    Object object2 = this.m_callerLock;
                    synchronized (object2) {
                        this.m_callerLock.notifyAll();
                    }
                    throw throwable;
                }
                try {
                    httpin.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Object object3 = this.m_callerLock;
            synchronized (object3) {
                this.m_callerLock.notifyAll();
            }
            return iStatus3;
        }
    }

    private void delayForDebug(ServiceTunnelRequest call, long millis) throws InterruptedException {
        if (millis <= 0L) {
            return;
        }
        System.out.println("#Delay " + millis + "ms for debugging " + call.getServiceInterfaceClassName() + "." + call.getOperation());
        Thread.sleep(millis);
    }
}

