/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;

public class DecompressedReader
extends Reader {
    private RemoteFile m_remoteFile;
    private ByteArrayInputStream m_buffer;
    private Inflater m_inflater;
    private InflaterInputStream m_inflaterInputStream;
    private InputStreamReader m_inputReader;

    public DecompressedReader(RemoteFile f) {
        this(f, "UTF-8");
    }

    public DecompressedReader(RemoteFile f, String charsetName) {
        this.m_remoteFile = f;
        this.m_buffer = new ByteArrayInputStream(this.m_remoteFile.getCompressedData());
        this.m_inflater = new Inflater();
        this.m_inflaterInputStream = new InflaterInputStream(this.m_buffer, this.m_inflater);
        try {
            this.m_inputReader = new InputStreamReader((InputStream)this.m_inflaterInputStream, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            this.m_inputReader = new InputStreamReader(this.m_inflaterInputStream);
        }
    }

    @Override
    public void close() throws IOException {
        this.m_inputReader.close();
        this.m_inflaterInputStream.close();
        this.m_inflater.end();
        this.m_buffer.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.m_inputReader.read(cbuf, off, len);
    }
}

