/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;

public class LocalLookupCall<T>
extends LookupCall<T> {
    private static final long serialVersionUID = 0L;

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @ConfigOperation
    @Order(value=30.0)
    protected List<? extends ILookupRow<T>> execCreateLookupRows() throws ProcessingException {
        return null;
    }

    protected Pattern createSearchPattern(String humanReadbleFilterPattern) {
        return LocalLookupCall.createLowerCaseSearchPattern(humanReadbleFilterPattern);
    }

    public static Pattern createLowerCaseSearchPattern(String s) {
        return StringUtility.toRegEx((String)s, (int)34);
    }

    @Override
    protected final Class<? extends ILookupService<T>> getConfiguredService() {
        return null;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByKey() throws ProcessingException {
        if (this.getKey() == null) {
            return CollectionUtility.emptyArrayList();
        }
        Object key = this.getKey();
        List<ILookupRow<T>> rows = this.execCreateLookupRows();
        if (rows == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>(rows.size());
        for (ILookupRow<T> row : rows) {
            if (!key.equals(row.getKey())) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByText() throws ProcessingException {
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>();
        Pattern p = this.createSearchPattern(this.getText());
        for (ILookupRow<T> row : this.execCreateLookupRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByAll() throws ProcessingException {
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>();
        Pattern p = this.createSearchPattern(this.getAll());
        for (ILookupRow<T> row : this.execCreateLookupRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByRec() throws ProcessingException {
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>();
        Object parentKey = this.getRec();
        if (parentKey == null) {
            for (ILookupRow<T> row : this.execCreateLookupRows()) {
                if (row.getParentKey() != null) continue;
                list.add(row);
            }
        } else {
            for (ILookupRow<T> row : this.execCreateLookupRows()) {
                if (!parentKey.equals(row.getParentKey())) continue;
                list.add(row);
            }
        }
        return list;
    }
}

