/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate.checks;

import java.util.Collection;
import java.util.Map;
import org.eclipse.scout.rt.shared.validate.ValidationUtility;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class MaxLengthCheck
implements IValidateCheck {
    public static final String ID = "maxLength";
    private int m_maxLength;

    public MaxLengthCheck(int maxLength) {
        this.m_maxLength = maxLength;
    }

    @Override
    public String getCheckId() {
        return ID;
    }

    @Override
    public boolean accept(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            return true;
        }
        if (obj instanceof Collection || obj instanceof Map) {
            return true;
        }
        return obj instanceof String;
    }

    @Override
    public void check(Object s) throws Exception {
        ValidationUtility.checkMaxLength(s, this.m_maxLength);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.m_maxLength;
    }
}

