/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.testing.shared.WaitCondition;

public interface IGuiMock {
    public static final long WAIT_TIMEOUT = 10000L;

    public void initializeMock();

    public void shutdownMock();

    public void beforeTest();

    public void afterTest();

    public GuiStrategy getStrategy();

    public int getSleepDelay();

    public void setSleepDelay(int var1);

    public void sleep();

    public void sleep(int var1);

    public boolean isWindowActive(String var1);

    public boolean isWindowOpen(String var1);

    public void waitForIdle();

    public void waitForOpenWindow(String var1);

    public void waitForActiveWindow(String var1);

    public void activateWindow(String var1);

    public FieldState getFieldState(FieldType var1, int var2);

    public FieldState getScoutFieldState(String var1);

    public FieldState getScoutFieldContainerState(String var1);

    public List<FieldState> getFieldStates(FieldType var1);

    public FieldState getFocusFieldState();

    public void gotoPoint(int var1, int var2);

    public void move(int var1, int var2);

    public void clickLeft();

    public void clickRight();

    public void pressLeft();

    public void releaseLeft();

    public void drag(int var1, int var2, int var3, int var4);

    public void dragWindowRightBorder(WindowState var1, int var2);

    public void pressKey(Key var1);

    public void releaseKey(Key var1);

    public void typeKey(Key var1);

    public void typeText(String var1);

    public void paste(String var1);

    public void clickOnPushButton(String var1);

    public void gotoField(FieldType var1, int var2);

    public void gotoScoutField(String var1);

    public void gotoScoutField(String var1, double var2, double var4);

    public void gotoTable(int var1, int var2, int var3);

    public void gotoTableHeader(int var1, int var2);

    public void gotoTree(int var1, String var2);

    public void gotoTreeExpandIcon(int var1, String var2);

    public void contextMenu(String ... var1);

    public List<String> getTableCells(int var1, int var2);

    public List<String> getTreeNodes(int var1);

    public Set<String> getSelectedTableCells(int var1, int var2);

    public Set<String> getSelectedTreeNodes(int var1);

    public Set<String> getCheckedTableCells(int var1, int var2);

    public WindowState getWindowState(String var1);

    public String getClipboardText();

    public void setClipboardText(String var1);

    public Object internal0(Object var1);

    public void clickLeftOnSmartFieldMagnifier(FieldState var1);

    public void clickRightOnSmartFieldMagnifier(FieldState var1);

    public <T> T invokeScoutAndWait(WaitCondition<T> var1, long var2, long var4) throws Throwable;

    public IClientSession getClientSession();

    public static class FieldState {
        public FieldType type;
        public String scoutName;
        public int x;
        public int y;
        public int width;
        public int height;
        public boolean focus;
        public String text;
        public boolean visible;
        public String foregroundColor;
        public String backgroundColor;
        public boolean selected;
        public Object widget;
    }

    public static enum FieldType {
        Label,
        Text,
        Checkbox,
        RadioButton,
        Table,
        Tree,
        PushButton,
        ScrollButton,
        DropdownButton;

    }

    public static enum GuiStrategy {
        Swt,
        Swing,
        Rap;

    }

    public static enum Key {
        Shift,
        Control,
        Alt,
        Delete,
        Backspace,
        Space,
        Enter,
        Esc,
        Tab,
        ContextMenu,
        Up,
        Down,
        Left,
        Right,
        Windows,
        F1,
        F2,
        F3,
        F4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        F11,
        F12,
        Home,
        End,
        PageUp,
        PageDown,
        NumPad0,
        NumPad1,
        NumPad2,
        NumPad3,
        NumPad4,
        NumPad5,
        NumPad6,
        NumPad7,
        NumPad8,
        NumPad9,
        NumPadMultiply,
        NumPadAdd,
        NumPadSubtract,
        NumPadDecimal,
        NumPadDivide,
        NumPadSeparator;

    }

    public static class WindowState {
        public int x;
        public int y;
        public int width;
        public int height;
    }
}

