/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared.runner;

import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public abstract class AbstractRunAftersInSeparateScoutSession
extends Statement {
    private final Statement m_statement;
    private final Object m_target;
    private final List<FrameworkMethod> m_afters;

    public AbstractRunAftersInSeparateScoutSession(Statement statement, List<FrameworkMethod> afters, Object target) {
        this.m_statement = statement;
        this.m_afters = afters;
        this.m_target = target;
    }

    public void evaluate() throws Throwable {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            this.m_statement.evaluate();
        }
        catch (Throwable e) {
            exceptions.add(e);
        }
        try {
            this.evaluateAftersInScoutSession();
        }
        catch (MultipleFailureException e) {
            exceptions.addAll(e.getFailures());
        }
        catch (Throwable t) {
            exceptions.add(t);
        }
        AbstractRunAftersInSeparateScoutSession.throwOnExceptions(exceptions);
    }

    protected abstract void evaluateAftersInScoutSession() throws Throwable;

    protected void evaluateAfters() throws Throwable {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (FrameworkMethod after : this.m_afters) {
            try {
                after.invokeExplosively(this.m_target, new Object[0]);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        }
        AbstractRunAftersInSeparateScoutSession.throwOnExceptions(exceptions);
    }

    private static void throwOnExceptions(List<Throwable> errors) throws Throwable, MultipleFailureException {
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw errors.get(0);
            }
            throw new MultipleFailureException(errors);
        }
    }
}

