/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.ui.swing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.testing.shared.ScoutJUnitPluginTestExecutor;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.service.SERVICES;

public class JUnitSwingJob
extends Job {
    private final Class<? extends IClientSession> m_clientSessionClass;
    private final long m_waitTimeout;

    public JUnitSwingJob(Class<? extends IClientSession> clientSessionClass, long waitTimeout) {
        super("JUnit Swing Job");
        this.setSystem(true);
        this.m_clientSessionClass = clientSessionClass;
        this.m_waitTimeout = waitTimeout;
    }

    public JUnitSwingJob(Class<? extends IClientSession> clientSessionClass) {
        this(clientSessionClass, 10000L);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            TestingUtility.waitUntil((long)this.m_waitTimeout, (WaitCondition)new WaitCondition<Object>(){

                public Object run() {
                    try {
                        IDesktop desktop;
                        IClientSession session = ((IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class)).newClientSession(JUnitSwingJob.this.m_clientSessionClass, UserAgent.create((IUiLayer)UiLayer.SWING, (IUiDeviceType)UiDeviceType.DESKTOP));
                        if (session != null && (desktop = session.getDesktop()) != null && desktop.isGuiAvailable() && desktop.isOpened()) {
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.exit(0);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            System.err.println("Timeout waiting for SwingApplication to start: " + t);
            System.exit(0);
        }
        ScoutJUnitPluginTestExecutor scoutJUnitPluginTestExecutor = new ScoutJUnitPluginTestExecutor();
        int code = scoutJUnitPluginTestExecutor.runAllTests();
        System.exit(code);
        return Status.OK_STATUS;
    }
}

