/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;

public class RwtScoutToolbarAction
extends Action {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutToolbarAction.class);
    private IAction m_scoutAction;
    private IRwtEnvironment m_swtEnvironment;
    private final OptimisticLock m_updateSwtFromScoutLock;
    private boolean m_updateUi = true;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private IToolBarManager m_toolbarMananger;

    public RwtScoutToolbarAction(IAction scoutAction, IToolBarManager manager, IRwtEnvironment environment) {
        super(scoutAction.getText() == null ? " " : scoutAction.getText(), RwtScoutToolbarAction.transformScoutStyle(scoutAction));
        this.m_toolbarMananger = manager;
        this.m_swtEnvironment = environment;
        this.m_updateSwtFromScoutLock = new OptimisticLock();
        this.m_scoutAction = scoutAction;
        this.setId(this.getScoutObject().getActionId());
        this.attachScout();
        this.m_scoutAction.addPropertyChangeListener((PropertyChangeListener)new P_ScoutPropertyChangeListener());
    }

    private static int transformScoutStyle(IAction scoutAction) {
        if (scoutAction.isToggleAction()) {
            return 2;
        }
        return 1;
    }

    protected void attachScout() {
        try {
            this.setUpdateUi(false);
            this.updateEnabledFromScout();
            this.updateIconFromScout();
            this.updateKeystrokeFromScout();
            this.updateSelectedFromScout();
            this.updateTextFromScout();
            this.updateTooltipTextFromScout();
        }
        finally {
            this.setUpdateUi(true);
        }
    }

    public IRwtEnvironment getEnvironment() {
        return this.m_swtEnvironment;
    }

    protected IAction getScoutObject() {
        return this.m_scoutAction;
    }

    public void setUpdateUi(boolean updateUi) {
        if (updateUi != this.m_updateUi) {
            this.m_updateUi = updateUi;
            if (updateUi) {
                this.m_toolbarMananger.update(true);
            }
        }
    }

    public boolean isUpdateUi() {
        return this.m_updateUi;
    }

    protected void updateEnabledFromScout() {
        this.setEnabled(this.getScoutObject().isEnabled());
        if (this.isUpdateUi()) {
            this.m_toolbarMananger.update(true);
        }
    }

    protected void updateIconFromScout() {
        this.setImageDescriptor(this.getEnvironment().getImageDescriptor(this.getScoutObject().getIconId()));
        if (this.isUpdateUi()) {
            this.m_toolbarMananger.update(true);
        }
    }

    protected void updateKeystrokeFromScout() {
        String keyStroke = this.getScoutObject().getKeyStroke();
        if (keyStroke != null) {
            int keyCode = RwtUtility.getRwtKeyCode((IKeyStroke)new KeyStroke(keyStroke));
            int stateMask = RwtUtility.getRwtStateMask((IKeyStroke)new KeyStroke(keyStroke));
            this.setAccelerator(stateMask | keyCode);
        } else {
            this.setAccelerator(0);
        }
        if (this.isUpdateUi()) {
            this.m_toolbarMananger.update(true);
        }
    }

    protected void updateTextFromScout() {
        this.setText(this.getScoutObject().getText());
        if (this.isUpdateUi()) {
            this.m_toolbarMananger.update(true);
        }
    }

    protected void updateTooltipTextFromScout() {
        this.setToolTipText(this.getScoutObject().getTooltipText());
        if (this.isUpdateUi()) {
            this.m_toolbarMananger.update(true);
        }
    }

    protected void updateSelectedFromScout() {
        this.setChecked(this.getScoutObject().isSelected());
        if (this.isUpdateUi()) {
            this.m_toolbarMananger.update(true);
        }
    }

    protected void updateVisibleFromScout() {
        LOG.warn("set visible on SWT action is not supported");
    }

    public void run() {
        this.handleSwtAction();
    }

    protected void handleSwtAction() {
        try {
            if (this.getUpdateSwtFromScoutLock().acquire()) {
                if (this.getScoutObject().isToggleAction() && this.getScoutObject() instanceof IViewButton && this.getScoutObject().isSelected()) {
                    this.updateSelectedFromScout();
                } else {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutToolbarAction.this.getScoutObject().getUIFacade().fireActionFromUI();
                        }
                    };
                    this.getEnvironment().invokeScoutLater(t, 0L);
                }
            }
        }
        finally {
            this.getUpdateSwtFromScoutLock().release();
        }
    }

    public OptimisticLock getUpdateSwtFromScoutLock() {
        return this.m_updateSwtFromScoutLock;
    }

    protected void handleScoutPropertyChange(String propertyName, Object newValue) {
        if ("enabled".equals(propertyName)) {
            this.updateEnabledFromScout();
        } else if ("iconId".equals(propertyName)) {
            this.updateIconFromScout();
        } else if ("keystroke".equals(propertyName)) {
            this.updateKeystrokeFromScout();
        } else if ("selected".equals(propertyName)) {
            this.updateSelectedFromScout();
        } else if ("text".equals(propertyName)) {
            this.updateTextFromScout();
        } else if ("tooltipText".equals(propertyName)) {
            this.updateTooltipTextFromScout();
        } else if ("visible".equals(propertyName)) {
            this.updateVisibleFromScout();
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutToolbarAction.this.getUpdateSwtFromScoutLock().acquire();
                        RwtScoutToolbarAction.this.handleScoutPropertyChange(evt.getPropertyName(), evt.getNewValue());
                    }
                    finally {
                        RwtScoutToolbarAction.this.getUpdateSwtFromScoutLock().release();
                    }
                }
            };
            RwtScoutToolbarAction.this.getEnvironment().invokeUiLater(t);
        }
    }
}

