/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rap.rwt.dnd.ClientFileTransfer;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.dnd.IRwtScoutFileUploadHandler;
import org.eclipse.scout.rt.ui.rap.dnd.RwtScoutFileUploadEvent;
import org.eclipse.scout.rt.ui.rap.dnd.RwtScoutFileUploadHandlerFactory;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutDndUploadCallback;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractRwtScoutDndSupport
implements IRwtScoutDndSupport,
IRwtScoutDndUploadCallback {
    private final Control m_control;
    private final IPropertyObserver m_scoutObject;
    private final IDNDSupport m_scoutDndSupportable;
    private IRwtEnvironment m_uiEnvironment;
    private DropTargetListener m_dropTargetListener;
    private DragSourceListener m_dragSourceListener;
    private PropertyChangeListener m_scoutPropertyListener;
    private Transfer[] m_dragTransferTypes;
    private Transfer[] m_dropTransferTypes;
    private boolean m_isClientFileTransferSupported;
    private IRwtScoutFileUploadHandler m_uploadHandler;

    public AbstractRwtScoutDndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, IRwtEnvironment uiEnvironment) {
        this.m_scoutObject = scoutObject;
        this.m_scoutDndSupportable = scoutDndSupportable;
        this.m_control = control;
        this.m_uiEnvironment = uiEnvironment;
        this.attachScout();
        this.m_control.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                AbstractRwtScoutDndSupport.this.detachScout();
            }
        });
    }

    protected void attachScout() {
        this.m_scoutPropertyListener = new P_ScoutObjectPropertyListener();
        this.m_scoutObject.addPropertyChangeListener(this.m_scoutPropertyListener);
        this.updateDragSupportFromScout();
        this.updateDropSupportFromScout();
    }

    protected void detachScout() {
        DropTarget dropTarget;
        Transfer t;
        int n;
        int n2;
        Transfer[] transferArray;
        ArrayList<Transfer> types;
        DragSource dragSource;
        this.m_scoutObject.removePropertyChangeListener(this.m_scoutPropertyListener);
        if (this.m_dragTransferTypes != null && (dragSource = (DragSource)this.m_control.getData("DragSource")) != null && !dragSource.isDisposed()) {
            dragSource.removeDragListener(this.m_dragSourceListener);
            types = new ArrayList<Transfer>(Arrays.asList(dragSource.getTransfer()));
            transferArray = this.m_dragTransferTypes;
            n2 = this.m_dragTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.remove(t);
                ++n;
            }
            if (types.size() > 0) {
                dragSource.setTransfer(types.toArray(new Transfer[types.size()]));
            } else {
                dragSource.dispose();
                this.m_control.setData("DragSource", null);
            }
        }
        if (this.m_dropTransferTypes != null && (dropTarget = (DropTarget)this.m_control.getData("DropTarget")) != null && !dropTarget.isDisposed()) {
            dropTarget.removeDropListener(this.m_dropTargetListener);
            types = new ArrayList<Transfer>(Arrays.asList(dropTarget.getTransfer()));
            transferArray = this.m_dropTransferTypes;
            n2 = this.m_dropTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.remove(t);
                ++n;
            }
            if (types.size() > 0) {
                dropTarget.setTransfer(types.toArray(new Transfer[types.size()]));
            } else {
                dropTarget.dispose();
                this.m_control.setData("DropTarget", null);
            }
        }
    }

    protected IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    protected abstract void handleUiDropAction(DropTargetEvent var1, TransferObject var2);

    protected void handleUiDropTargetChanged(DropTargetEvent event) {
    }

    protected abstract TransferObject handleUiDragRequest();

    protected void handleUiDragFinished() {
    }

    protected void updateDragSupportFromScout() {
        if (this.m_scoutObject == null || this.m_control == null || this.m_control.isDisposed()) {
            return;
        }
        int scoutType = this.m_scoutDndSupportable.getDragType();
        Transfer[] transferTypes = RwtUtility.convertScoutTransferTypes(scoutType);
        DragSource dragSource = (DragSource)this.m_control.getData("DragSource");
        if (dragSource == null && transferTypes.length > 0) {
            dragSource = this.createDragSource(this.m_control);
        }
        if (dragSource != null) {
            Transfer t;
            int n;
            int n2;
            Transfer[] transferArray;
            ArrayList<Transfer> types = new ArrayList<Transfer>(Arrays.asList(dragSource.getTransfer()));
            if (this.m_dragTransferTypes != null) {
                transferArray = this.m_dragTransferTypes;
                n2 = this.m_dragTransferTypes.length;
                n = 0;
                while (n < n2) {
                    t = transferArray[n];
                    types.remove(t);
                    ++n;
                }
                this.m_dragTransferTypes = null;
            }
            transferArray = this.m_dragTransferTypes = transferTypes;
            n2 = this.m_dragTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.add(t);
                ++n;
            }
            if (types.size() > 0) {
                dragSource.setTransfer(types.toArray(new Transfer[types.size()]));
                if (this.m_dragSourceListener == null) {
                    this.m_dragSourceListener = new P_RwtDragSourceListener();
                    dragSource.addDragListener(this.m_dragSourceListener);
                }
            } else {
                if (this.m_dragSourceListener != null) {
                    dragSource.removeDragListener(this.m_dragSourceListener);
                    this.m_dragSourceListener = null;
                }
                dragSource.dispose();
            }
        }
    }

    protected DragSource createDragSource(Control control) {
        return new DragSource(control, 1);
    }

    protected void updateDropSupportFromScout() {
        if (this.m_scoutObject == null || this.m_control == null || this.m_control.isDisposed()) {
            return;
        }
        int scoutType = this.m_scoutDndSupportable.getDropType();
        Transfer[] transferTypes = RwtUtility.convertScoutTransferTypes(scoutType);
        DropTarget dropTarget = (DropTarget)this.m_control.getData("DropTarget");
        if (dropTarget == null && transferTypes.length > 0) {
            dropTarget = this.createDropTarget(this.m_control);
        }
        if (dropTarget != null) {
            Transfer t;
            int n;
            int n2;
            Transfer[] transferArray;
            ArrayList<Transfer> types = new ArrayList<Transfer>(Arrays.asList(dropTarget.getTransfer()));
            if (this.m_dropTransferTypes != null) {
                transferArray = this.m_dropTransferTypes;
                n2 = this.m_dropTransferTypes.length;
                n = 0;
                while (n < n2) {
                    t = transferArray[n];
                    types.remove(t);
                    ++n;
                }
                this.m_dropTransferTypes = null;
            }
            transferArray = this.m_dropTransferTypes = transferTypes;
            n2 = this.m_dropTransferTypes.length;
            n = 0;
            while (n < n2) {
                t = transferArray[n];
                types.add(t);
                ++n;
            }
            if (types.size() > 0) {
                this.m_isClientFileTransferSupported = types.contains(ClientFileTransfer.getInstance());
                dropTarget.setTransfer(types.toArray(new Transfer[types.size()]));
                if (this.m_dropTargetListener == null) {
                    this.m_dropTargetListener = new P_RwtDropTargetListener();
                    dropTarget.addDropListener(this.m_dropTargetListener);
                }
            } else {
                this.m_isClientFileTransferSupported = false;
                if (this.m_dropTargetListener != null) {
                    dropTarget.removeDropListener(this.m_dropTargetListener);
                    this.m_dropTargetListener = null;
                }
                dropTarget.dispose();
                this.m_control.setData("DropTarget", null);
            }
        }
    }

    protected DropTarget createDropTarget(Control control) {
        return new DropTarget(control, 3);
    }

    protected void handleScoutProperty(String name, Object newValue) {
        if ("dragType".equals(name)) {
            this.updateDragSupportFromScout();
        } else if ("dropType".equals(name)) {
            this.updateDropSupportFromScout();
        }
    }

    protected boolean handleFileUpload(DropTargetEvent event) {
        if (!this.m_isClientFileTransferSupported || !ClientFileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            return false;
        }
        if (this.m_uploadHandler == null) {
            this.m_uploadHandler = RwtScoutFileUploadHandlerFactory.createFileUploadHandler(this);
        }
        return this.m_uploadHandler.startFileUpload(event);
    }

    protected static int getPercentage(RwtScoutFileUploadEvent uploadEvent) {
        double bytesRead = uploadEvent.getBytesRead();
        double contentLength = uploadEvent.getContentLength();
        double fraction = bytesRead / contentLength;
        return (int)Math.floor(fraction * 100.0);
    }

    @Override
    public void uploadProgress(DropTargetEvent dropEvent, RwtScoutFileUploadEvent uploadEvent) {
    }

    @Override
    public void uploadFailed(DropTargetEvent dropEvent, RwtScoutFileUploadEvent uploadEvent) {
    }

    @Override
    public void uploadFinished(final DropTargetEvent dropEvent, RwtScoutFileUploadEvent uploadEvent, final List<File> uploadedFiles) {
        this.getUiEnvironment().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TransferObject scoutTransferable = AbstractRwtScoutDndSupport.this.createScoutTransferableObjectFromFileUpload(dropEvent, uploadedFiles);
                if (scoutTransferable != null) {
                    AbstractRwtScoutDndSupport.this.handleUiDropAction(dropEvent, scoutTransferable);
                }
            }
        });
    }

    protected TransferObject createScoutTransferableObjectFromFileUpload(DropTargetEvent event, List<File> uploadedFiles) {
        return RwtUtility.createScoutTransferableFromClientFile(event, uploadedFiles);
    }

    protected TransferObject createScoutTransferableObject(DropTargetEvent event) {
        return RwtUtility.createScoutTransferable(event);
    }

    private class P_RwtDragSourceListener
    extends DragSourceAdapter {
        private static final long serialVersionUID = 1L;
        private Object m_data;

        private P_RwtDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            super.dragStart(event);
            TransferObject scoutTransfer = AbstractRwtScoutDndSupport.this.handleUiDragRequest();
            if (scoutTransfer != null) {
                this.m_data = RwtUtility.createUiTransferable(scoutTransfer);
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (this.m_data != null) {
                event.data = this.m_data;
            }
        }

        public void dragFinished(DragSourceEvent event) {
            super.dragFinished(event);
            AbstractRwtScoutDndSupport.this.handleUiDragFinished();
            this.m_data = null;
        }
    }

    private class P_RwtDropTargetListener
    extends DropTargetAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtDropTargetListener() {
        }

        public void drop(DropTargetEvent event) {
            if (AbstractRwtScoutDndSupport.this.handleFileUpload(event)) {
                return;
            }
            TransferObject scoutTransferable = AbstractRwtScoutDndSupport.this.createScoutTransferableObject(event);
            if (scoutTransferable != null) {
                AbstractRwtScoutDndSupport.this.handleUiDropAction(event, scoutTransferable);
            }
        }

        public void dragOver(DropTargetEvent event) {
            AbstractRwtScoutDndSupport.this.handleUiDropTargetChanged(event);
        }
    }

    private class P_ScoutObjectPropertyListener
    implements PropertyChangeListener {
        private P_ScoutObjectPropertyListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (AbstractRwtScoutDndSupport.this.getUiEnvironment().getDisplay() != null && !AbstractRwtScoutDndSupport.this.getUiEnvironment().getDisplay().isDisposed()) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        AbstractRwtScoutDndSupport.this.handleScoutProperty(evt.getPropertyName(), evt.getNewValue());
                    }
                };
                AbstractRwtScoutDndSupport.this.getUiEnvironment().invokeUiLater(job);
            }
        }
    }
}

