/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.button;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.basic.comp.HyperlinkEx;
import org.eclipse.scout.rt.ui.rap.ext.ButtonEx;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.button.IRwtScoutButton;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class RwtScoutButton<T extends IButton>
extends RwtScoutFieldComposite<T>
implements IRwtScoutButton<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutButton.class);
    private ButtonListener m_scoutButtonListener;
    private OptimisticLock m_selectionLock = new OptimisticLock();
    private boolean m_handleActionPending;
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_contextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(container, this.getUiEnvironment(), 524288);
        this.getUiEnvironment().getFormToolkit().adapt(this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutButton.this.getContextMenu() != null) {
                    Menu uiMenu = RwtScoutButton.this.getContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation(((IButton)RwtScoutButton.this.getScoutObject()).getContextMenu().getChildActions(), uiMenu, loc, RwtScoutButton.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        ButtonEx uiFieldAsButton = null;
        Hyperlink uiFieldAsLink = null;
        switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
            case 2: {
                uiFieldAsButton = this.createSwtRadioButton(this.m_menuMarkerComposite, 16464);
                break;
            }
            case 1: {
                uiFieldAsButton = this.createSwtToggleButton(this.m_menuMarkerComposite, 0x1000002);
                break;
            }
            case 3: {
                uiFieldAsLink = this.createSwtHyperlink(this.m_menuMarkerComposite, "", 0x1000000);
                break;
            }
            default: {
                uiFieldAsButton = this.createSwtPushButton(this.m_menuMarkerComposite, 0x1000008);
            }
        }
        this.setUiContainer(container);
        this.setUiLabel(null);
        if (uiFieldAsButton != null) {
            this.setUiField((Control)uiFieldAsButton);
            uiFieldAsButton.addListener(44, new P_RwtSelectionListener());
            LogicalGridData gd = (LogicalGridData)this.getUiField().getLayoutData();
            this.adaptButtonLayoutData(gd);
        } else if (uiFieldAsLink != null) {
            uiFieldAsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    RwtScoutButton.this.handleUiAction();
                }
            });
            this.setUiField((Control)uiFieldAsLink);
            this.getUiContainer().setTabList(new Control[]{this.m_menuMarkerComposite});
        }
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(0, 0));
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
    }

    protected Hyperlink createSwtHyperlink(Composite container, String text, int style) {
        HyperlinkGroup linkGroup = this.getUiEnvironment().getFormToolkit().getHyperlinkGroup();
        linkGroup.setHyperlinkUnderlineMode(2);
        HyperlinkEx uiLink = this.getUiEnvironment().getFormToolkit().createHyperlink(container, "", style);
        return uiLink;
    }

    protected ButtonEx createSwtRadioButton(Composite container, int style) {
        return this.getUiEnvironment().getFormToolkit().createButtonEx(container, style);
    }

    protected ButtonEx createSwtToggleButton(Composite container, int style) {
        return this.getUiEnvironment().getFormToolkit().createButtonEx(container, style);
    }

    protected ButtonEx createSwtPushButton(Composite container, int style) {
        ButtonEx swtButton = this.getUiEnvironment().getFormToolkit().createButtonEx(container, style);
        swtButton.setDropDownEnabled(true);
        return swtButton;
    }

    protected void adaptButtonLayoutData(LogicalGridData gd) {
        if (!((IButton)this.getScoutObject()).isProcessButton() || gd.useUiHeight) {
            return;
        }
        gd.useUiHeight = true;
        IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
        gd.heightHint = deco.getProcessButtonHeight();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IButton b = (IButton)this.getScoutObject();
        this.setIconIdFromScout(b.getIconId());
        this.setImageFromScout(b.getImage());
        this.setSelectionFromScout(b.isSelected());
        this.setLabelFromScout(b.getLabel());
        if (this.m_scoutButtonListener == null) {
            this.m_scoutButtonListener = new P_ScoutButtonListener();
            ((IButton)this.getScoutObject()).addButtonListener(this.m_scoutButtonListener);
        }
        this.updateContextMenuVisibilityFromScout();
        if (((IButton)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((IButton)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutButtonListener != null) {
            ((IButton)this.getScoutObject()).removeButtonListener(this.m_scoutButtonListener);
            this.m_scoutButtonListener = null;
        }
        if (this.m_contextMenuPropertyListener != null) {
            ((IButton)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
    }

    protected void setIconIdFromScout(String s) {
        if (s != null) {
            Image icon = this.getUiEnvironment().getIcon(s);
            Control comp = this.getUiField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage(icon);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        Control comp = this.getUiField();
        if (comp instanceof Button) {
            Button b = (Button)comp;
            String label = s;
            b.setText(label == null ? "" : label);
        } else if (comp instanceof Hyperlink) {
            Hyperlink t = (Hyperlink)comp;
            String label = StringUtility.removeMnemonic((String)s);
            t.setText(label == null ? "" : label);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setSelectionFromScout(boolean b) {
        try {
            if (!this.m_selectionLock.acquire()) return;
            switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
                case 1: 
                case 2: {
                    Button but;
                    Control comp = this.getUiField();
                    if (!(comp instanceof Button) || b == (but = (Button)comp).getSelection()) return;
                    but.setSelection(b);
                }
                default: {
                    return;
                }
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void setSelectionFromUi(final boolean b) {
        try {
            if (this.m_selectionLock.acquire()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (((IButton)RwtScoutButton.this.getScoutObject()).isSelected() != b) {
                            ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
                        }
                        ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                };
                this.getUiEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void handleUiAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                    finally {
                        RwtScoutButton.this.m_handleActionPending = false;
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setImageFromScout(Object img) {
        if (img instanceof Image) {
            Control comp = this.getUiField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage((Image)img);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    protected void disarmButtonFromScout() {
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((IButton)this.getScoutObject()).getContextMenu().isVisible());
        if (((IButton)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_contextMenu == null) {
                this.m_contextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), ((IButton)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
                this.getUiField().setMenu(this.getContextMenu().getUiMenu());
            }
        } else {
            this.getUiField().setMenu(null);
            if (this.m_contextMenu != null) {
                this.m_contextMenu.dispose();
            }
            this.m_contextMenu = null;
        }
    }

    protected void requestPopupFromScout() {
        if (this.getContextMenu() != null) {
            this.getContextMenu().getUiMenu().setVisible(true);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("image")) {
            this.setImageFromScout(newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    public RwtScoutContextMenu getContextMenu() {
        return this.m_contextMenu;
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutButton.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutButton.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_RwtSelectionListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtSelectionListener() {
        }

        public void handleEvent(Event event) {
            block0 : switch (event.type) {
                case 44: {
                    switch (((IButton)RwtScoutButton.this.getScoutObject()).getDisplayStyle()) {
                        case 1: 
                        case 2: {
                            RwtScoutButton.this.setSelectionFromUi(((Button)RwtScoutButton.this.getUiField()).getSelection());
                            break block0;
                        }
                    }
                    RwtScoutButton.this.handleUiAction();
                }
            }
        }
    }

    private class P_ScoutButtonListener
    implements ButtonListener,
    WeakEventListener {
        private P_ScoutButtonListener() {
        }

        public void buttonChanged(ButtonEvent e) {
            switch (e.getType()) {
                case 3: {
                    RwtScoutButton.this.getUiEnvironment().invokeUiLater(new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutButton.this.disarmButtonFromScout();
                        }
                    });
                    break;
                }
                case 4: {
                    RwtScoutButton.this.getUiEnvironment().invokeUiLater(new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutButton.this.requestPopupFromScout();
                        }
                    });
                }
            }
        }
    }
}

