/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser;

import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.TimeChooser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TimeChooserDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final String TIMECHOOSER_DIALOG_CUSTOM_VARIANT = "timechooser-dialog";
    public static final int TYPE_BACK_YEAR = 1;
    public static final int TYPE_BACK_MONTH = 2;
    public static final int TYPE_FOREWARD_MONTH = 4;
    public static final int TYPE_FOREWARD_YEAR = 8;
    private TimeChooser m_timeChooser;
    private Date m_returnTime = null;
    private Date m_displayDate;
    private Control m_field;

    protected int getShellStyle() {
        return 0;
    }

    public TimeChooserDialog(Shell parentShell, Control field, Date date) {
        super(parentShell);
        this.m_field = field;
        this.setDisplayDate(date);
        this.setBlockOnOpen(false);
        this.create();
    }

    public TimeChooserDialog(Shell parentShell, Control field, Number number) {
        super(parentShell);
        this.m_field = field;
        this.setDisplayDate((Double)number);
        this.setBlockOnOpen(false);
        this.create();
    }

    private void setDisplayDate(Date date) {
        this.m_displayDate = date;
    }

    private void setDisplayDate(Double number) {
        if (number == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        int hours = (int)(number * 24.0);
        int mins = (int)Math.round((number * 24.0 - (double)hours) * 60.0);
        c.set(0, 0, 0, hours, mins);
        this.m_displayDate = c.getTime();
    }

    public Date getReturnTime() {
        return this.m_returnTime;
    }

    protected Control getField() {
        return this.m_field;
    }

    protected Point getInitialLocation(Point initialSize, Control field) {
        Rectangle appBounds = field.getDisplay().getBounds();
        Point absPrefPos = field.toDisplay(0, field.getSize().y);
        Rectangle prefBounds = new Rectangle(absPrefPos.x, absPrefPos.y, initialSize.x, initialSize.y);
        if (prefBounds.x + prefBounds.width > appBounds.width) {
            prefBounds.x = appBounds.width - prefBounds.width;
        }
        if (prefBounds.y + prefBounds.height > appBounds.height) {
            prefBounds.y = appBounds.height - prefBounds.height;
        }
        return new Point(prefBounds.x, prefBounds.y);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point initialLocation = this.getInitialLocation(initialSize, this.getField());
        if (initialLocation != null) {
            return initialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createContents(Composite parent) {
        parent.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        Composite rootArea = new Composite(parent, 0);
        rootArea.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        this.m_timeChooser = this.createTimeChooser(rootArea);
        this.m_timeChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimeChooserDialog.this.m_returnTime = TimeChooserDialog.this.m_timeChooser.getTime();
                TimeChooserDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimeChooserDialog.this.close();
                    }
                });
            }
        });
        this.m_timeChooser.setTime(this.m_displayDate);
        rootArea.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        rootArea.setLayoutData((Object)data);
        return rootArea;
    }

    protected TimeChooser createTimeChooser(Composite parent) {
        return new TimeChooser(parent);
    }

    protected String getDialogVariant() {
        return TIMECHOOSER_DIALOG_CUSTOM_VARIANT;
    }
}

