/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.tabbox;

import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.RwtScoutGroupBox;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.IRwtScoutTabItem;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutTabItem
extends RwtScoutGroupBox
implements IRwtScoutTabItem {
    private final ITabBox m_scoutParentObject;
    private final Composite m_tabboxButtonbar;
    private final Composite m_tabboxContainer;
    private final String m_variantInActive;
    private final String m_variantActive;
    private final String m_variantInActiveMarked;
    private final String m_variantActiveMarked;
    private Composite m_tabItem;
    private boolean m_selected;
    private boolean m_groupBoxBuilt;
    private boolean m_lazyBuildEnabled;
    private Button m_tabButton;
    private RwtScoutTabItem m_nextTabItem = null;
    private RwtScoutTabItem m_previousTabItem = null;

    public RwtScoutTabItem(ITabBox scoutParentObject, Composite tabboxButtonbar, Composite tabboxContainer, String variantInActive, String variantActive, String variantInActiveMarked, String variantActiveMarked) {
        this.m_scoutParentObject = scoutParentObject;
        this.m_tabboxButtonbar = tabboxButtonbar;
        this.m_tabboxContainer = tabboxContainer;
        this.m_variantInActive = variantInActive;
        this.m_variantActive = variantActive;
        this.m_variantInActiveMarked = variantInActiveMarked;
        this.m_variantActiveMarked = variantActiveMarked;
        this.setLazyBuildEnabled(true);
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.createTabButton();
        this.createTabItem();
    }

    protected void createTabButton() {
        this.m_tabButton = this.getUiEnvironment().getFormToolkit().createButton(this.m_tabboxButtonbar, "", 0);
        this.m_tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActive);
        this.m_tabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RwtScoutTabItem.this.handleUiSelection();
                RwtScoutTabItem.this.select();
            }
        });
        RwtScoutTabItem.registerCompositeOnWidget((Widget)this.m_tabButton, this);
        this.getUiEnvironment().addKeyStroke((Control)this.m_tabButton, new P_KeyListener(0x1000003), false);
        this.getUiEnvironment().addKeyStroke((Control)this.m_tabButton, new P_KeyListener(0x1000004), false);
        RowData rowData = new RowData();
        this.m_tabButton.setLayoutData((Object)rowData);
    }

    protected void createTabItem() {
        this.m_tabItem = this.getUiEnvironment().getFormToolkit().createComposite(this.m_tabboxContainer, 0);
        this.m_tabItem.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActive);
        this.m_tabItem.setLayout((Layout)new FillLayout());
        if (!this.isLazyBuildEnabled() || this.isSelected()) {
            this.buildGroupbox();
        } else {
            this.setUiContainer(this.m_tabItem);
        }
    }

    public void recreateTabButton() {
        this.disposeTabButton();
        this.createTabButton();
        this.attachScout();
        if (this.isSelected()) {
            this.select();
        } else {
            this.unselect();
        }
    }

    protected void buildGroupbox() {
        if (this.isGroupBoxBuilt()) {
            return;
        }
        super.initializeUi(this.m_tabItem);
        this.m_groupBoxBuilt = true;
        if (this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.m_tabItem);
        }
    }

    public boolean isGroupBoxBuilt() {
        return this.m_groupBoxBuilt;
    }

    @Override
    protected void disposeImpl() {
        super.disposeImpl();
        this.disposeTabButton();
        this.disposeTabItem();
    }

    protected void disposeTabButton() {
        if (this.m_tabButton != null && !this.m_tabButton.isDisposed()) {
            this.getUiEnvironment().removeKeyStrokes((Control)this.m_tabButton);
            this.m_tabButton.dispose();
            this.m_tabButton = null;
        }
    }

    protected void disposeTabItem() {
        if (this.m_tabItem != null && !this.m_tabItem.isDisposed()) {
            this.m_tabItem.dispose();
            this.m_tabItem = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IGroupBox scoutField = (IGroupBox)this.getScoutObject();
        if (scoutField != null) {
            this.setEmptyFromScout(scoutField.isEmpty());
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        this.getUiEnvironment().removeKeyStrokes((Control)this.m_tabButton);
    }

    private boolean isValidWidget(Widget w) {
        Control c;
        if (w == null || w.isDisposed()) {
            return false;
        }
        return !(w instanceof Control) || (c = (Control)w).getParent() != null && !c.getParent().isDisposed();
    }

    private void setButtonInactive() {
        this.m_selected = false;
        if (!this.isValidWidget((Widget)this.m_tabButton)) {
            return;
        }
        Object oldVariant = this.m_tabButton.getData("org.eclipse.rap.rwt.customVariant");
        if (oldVariant == this.m_variantActiveMarked || oldVariant == this.m_variantInActiveMarked) {
            this.m_tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActiveMarked);
        } else {
            this.m_tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActive);
        }
    }

    private void setButtonActive() {
        if (!this.isValidWidget((Widget)this.m_tabButton)) {
            return;
        }
        Object oldVariant = this.m_tabButton.getData("org.eclipse.rap.rwt.customVariant");
        if (oldVariant == this.m_variantActiveMarked || oldVariant == this.m_variantInActiveMarked) {
            this.m_tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantActiveMarked);
        } else {
            this.m_tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantActive);
        }
        this.m_selected = true;
    }

    private void setButtonMarker(Button tabButton, boolean marked) {
        if (!this.isValidWidget((Widget)tabButton)) {
            return;
        }
        Object oldVariant = tabButton.getData("org.eclipse.rap.rwt.customVariant");
        if (marked) {
            if (oldVariant == this.m_variantActive) {
                tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantActiveMarked);
            } else if (oldVariant == this.m_variantInActive) {
                tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActiveMarked);
            }
        } else if (oldVariant == this.m_variantActiveMarked) {
            tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantActive);
        } else if (oldVariant == this.m_variantInActiveMarked) {
            tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActive);
        }
    }

    protected void handleUiSelectionChanged() {
        this.handleUiSelection();
        this.select();
    }

    protected void handleUiSelection() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                RwtScoutTabItem.this.m_scoutParentObject.getUIFacade().setSelectedTabFromUI((IGroupBox)RwtScoutTabItem.this.getScoutObject());
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    public Button getTabButton() {
        return this.m_tabButton;
    }

    protected Composite getTabItem() {
        return this.m_tabItem;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("empty")) {
            this.setEmptyFromScout((Boolean)TypeCastUtility.castValue((Object)newValue, Boolean.TYPE));
        }
    }

    @Override
    protected void setSaveNeededFromScout(boolean b) {
        if (((IGroupBox)this.getScoutObject()).getParentField() instanceof ITabBox) {
            if (((ITabBox)((IGroupBox)this.getScoutObject()).getParentField()).getMarkStrategy() == 1) {
                this.setButtonMarker(this.m_tabButton, b);
            }
        } else if (((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm) {
            this.setButtonMarker(this.m_tabButton, b);
        }
    }

    protected void setEmptyFromScout(boolean b) {
        if (((IGroupBox)this.getScoutObject()).getParentField() instanceof ITabBox) {
            if (((ITabBox)((IGroupBox)this.getScoutObject()).getParentField()).getMarkStrategy() == 0) {
                this.setButtonMarker(this.m_tabButton, !b);
            }
        } else if (!(((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm)) {
            this.setButtonMarker(this.m_tabButton, !b);
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        String label = s;
        if (label == null) {
            label = "";
        }
        this.getTabButton().setText(label);
    }

    @Override
    protected void setFontFromScout(FontSpec scoutFont) {
        super.setFontFromScout(scoutFont);
        this.m_tabItem.setFont(this.getUiEnvironment().getFont(scoutFont, this.m_tabItem.getFont()));
    }

    public void unselect() {
        this.setButtonInactive();
    }

    public void select() {
        this.setButtonActive();
        this.buildGroupbox();
    }

    protected boolean isSelected() {
        return this.m_selected;
    }

    protected boolean isLazyBuildEnabled() {
        return this.m_lazyBuildEnabled;
    }

    public void setLazyBuildEnabled(boolean lazyBuildEnabled) {
        this.m_lazyBuildEnabled = lazyBuildEnabled;
    }

    protected RwtScoutTabItem getNextTabItem() {
        return this.m_nextTabItem;
    }

    protected void setNextTabItem(RwtScoutTabItem nextTabItem) {
        this.m_nextTabItem = nextTabItem;
    }

    protected RwtScoutTabItem getPreviousTabItem() {
        return this.m_previousTabItem;
    }

    protected void setPreviousTabItem(RwtScoutTabItem previousTabItem) {
        this.m_previousTabItem = previousTabItem;
    }

    private class P_KeyListener
    extends RwtKeyStroke {
        public P_KeyListener(int keyCode) {
            super(keyCode);
        }

        public P_KeyListener(int keyCode, int stateMask) {
            super(keyCode, stateMask);
        }

        private void handleKeyPressed(RwtScoutTabItem tabItem) {
            if (tabItem == null) {
                return;
            }
            tabItem.getTabButton().setFocus();
            tabItem.handleUiSelectionChanged();
        }

        @Override
        public void handleUiAction(Event e) {
            switch (e.keyCode) {
                case 0x1000003: {
                    this.handleKeyPressed(RwtScoutTabItem.this.getPreviousTabItem());
                    e.doit = false;
                    break;
                }
                case 0x1000004: {
                    this.handleKeyPressed(RwtScoutTabItem.this.getNextTabItem());
                    e.doit = false;
                    break;
                }
            }
        }
    }
}

