/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class FocusUtility {
    public static boolean isFocusable(Control control) {
        boolean takesFocus;
        if (control == null) {
            return false;
        }
        boolean bl = takesFocus = (control.getStyle() & 0x80000) == 0;
        if (!takesFocus) {
            return false;
        }
        boolean visible = control.getVisible();
        IPropertyObserver model = RwtScoutComposite.getScoutModelOnWidget((Widget)control);
        if (model instanceof IFormField) {
            IFormField field = (IFormField)model;
            visible &= field.isVisible() && FocusUtility.areParentsVisible(field);
        }
        return visible;
    }

    private static boolean areParentsVisible(IFormField field) {
        ICompositeField parentField = field.getParentField();
        while (parentField != null) {
            if (!parentField.isVisible()) {
                return false;
            }
            parentField = parentField.getParentField();
        }
        return true;
    }

    public static Control findFirstFocusableControl(Composite parent) {
        Control[] controls;
        if (parent == null) {
            return null;
        }
        Control[] controlArray = controls = parent.getTabList();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite ? (control = FocusUtility.findFirstFocusableControl((Composite)control)) != null : FocusUtility.isFocusable(control)) {
                return control;
            }
            ++n2;
        }
        return null;
    }
}

