/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop;

import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtStandaloneEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtDesktop;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutToolbar;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.IViewArea;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.RwtScoutToolbar;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ILayoutListener;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ViewArea;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public class RwtScoutDesktop
extends RwtScoutComposite<IDesktop>
implements IRwtDesktop {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDesktop.class);
    private static final String VARIANT_VIEWS_AREA = "viewsArea";
    private ViewArea m_viewArea;
    private RwtScoutToolbar m_uiToolbar;

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTitleFromScout(((IDesktop)this.getScoutObject()).getTitle());
    }

    @Override
    protected void detachScout() {
        super.detachScout();
    }

    @Override
    protected void initializeUi(Composite parent) {
        try {
            Composite desktopComposite = parent;
            Control toolbar = this.createToolBar(desktopComposite);
            Control viewsArea = this.createViewsArea(desktopComposite);
            viewsArea.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getViewsAreaVariant());
            this.initLayout(desktopComposite, toolbar, viewsArea);
            this.setUiContainer(desktopComposite);
        }
        catch (Throwable t) {
            LOG.error("Exception occured while creating ui desktop.", t);
        }
    }

    protected String getViewsAreaVariant() {
        return VARIANT_VIEWS_AREA;
    }

    protected void initLayout(Composite container, Control toolbar, Control viewsArea) {
        GridLayout layout = RwtLayoutUtility.createGridLayoutNoSpacing(1, true);
        container.setLayout((Layout)layout);
        if (toolbar != null) {
            GridData toolbarData = new GridData(768);
            toolbar.setLayoutData((Object)toolbarData);
        }
        if (viewsArea != null) {
            GridData viewsAreaData = new GridData(1808);
            viewsArea.setLayoutData((Object)viewsAreaData);
        }
    }

    protected Control createToolBar(Composite parent) {
        this.m_uiToolbar = new RwtScoutToolbar();
        this.m_uiToolbar.createUiField(parent, (IDesktop)this.getScoutObject(), this.getUiEnvironment());
        return this.m_uiToolbar.getUiContainer();
    }

    protected Control createViewsArea(Composite parent) {
        this.m_viewArea = this.createViewArea(parent);
        this.m_viewArea.getLayout().addLayoutListener(new ILayoutListener(){

            @Override
            public void handleCompositeLayouted() {
                int xOffset = -1;
                Sash sash = RwtScoutDesktop.this.m_viewArea.getSash(ViewArea.SashKey.VERTICAL_RIGHT);
                if (sash != null && sash.getVisible()) {
                    Rectangle sashBounds = sash.getBounds();
                    xOffset = sashBounds.x + sashBounds.width;
                }
                if (RwtScoutDesktop.this.getUiToolbar() != null) {
                    RwtScoutDesktop.this.getUiToolbar().handleRightViewPositionChanged(xOffset);
                }
            }
        });
        return this.m_viewArea;
    }

    protected ViewArea createViewArea(Composite parent) {
        return new ViewArea(parent);
    }

    @Override
    public IRwtStandaloneEnvironment getUiEnvironment() {
        return (IRwtStandaloneEnvironment)super.getUiEnvironment();
    }

    @Override
    public IRwtScoutPart addForm(IForm form) {
        IRwtScoutViewStack stack = this.getViewArea().getStackForForm(form);
        if (stack == null) {
            LOG.error("No view stack for the form '" + form.getFormId() + "' with the display view id '" + form.getDisplayViewId() + "' found. Please check your view configuration. See class ViewArea for details.");
            return null;
        }
        IRwtScoutPart rwtForm = stack.addForm(form);
        this.m_viewArea.updateSashPositionForViewStack(stack);
        this.updateLayout();
        return rwtForm;
    }

    @Override
    public void updateLayout() {
        this.getViewArea().layout();
    }

    @Override
    public IRwtScoutToolbar getUiToolbar() {
        return this.m_uiToolbar;
    }

    @Override
    public IViewArea getViewArea() {
        return this.m_viewArea;
    }

    protected void setTitleFromScout(String title) {
        JavaScriptExecutor executor;
        if (title == null) {
            title = "";
        }
        if ((executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class)) != null) {
            executor.execute("window.document.title=\"" + title + "\"");
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("title".equals(name)) {
            this.setTitleFromScout((String)newValue);
        }
    }
}

