/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.builder;

import java.util.Calendar;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.svg.calendar.builder.AbstractCalendarDocumentBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.comp.IComponentElementFactory;
import org.eclipse.scout.rt.ui.svg.calendar.comp.TimeLineComponentElementFactory;
import org.w3c.dom.Element;

public class CalendarWeekBuilder
extends AbstractCalendarDocumentBuilder {
    public CalendarWeekBuilder() {
        super("resources/WeekCalendar.svg");
    }

    @Override
    protected int getNumWeekdays() {
        return 7;
    }

    @Override
    protected IComponentElementFactory getComponentElementFactory() {
        return new TimeLineComponentElementFactory(this.getStartHour(), this.getEndHour());
    }

    @Override
    protected int getNumWeeks() {
        return 1;
    }

    @Override
    protected int getDisplayMode() {
        return 2;
    }

    @Override
    protected String getRangeTitle(Calendar cal) {
        return String.valueOf(this.getMonthLabel(cal.get(2))) + " " + cal.get(1) + " - " + ScoutTexts.get((String)"Week", (String[])new String[0]) + " " + cal.get(3);
    }

    @Override
    protected boolean hasTimeLine() {
        return true;
    }

    @Override
    protected String getDayTitle(Calendar cal) {
        return "" + cal.get(5);
    }

    @Override
    protected void truncateToRange(Calendar cal) {
        cal.add(5, -this.getNumOfDaysInWeekBefore(cal));
    }

    @Override
    protected int getSmallNextField() {
        return 3;
    }

    @Override
    protected int getBigNextField() {
        return 2;
    }

    @Override
    protected double getGridTop() {
        return 64.508;
    }

    @Override
    protected void resizeDayBoxes(double height) {
        int i = 0;
        while (i < this.getNumWeekdays()) {
            Element el = this.getSVGDocument().getElementById("b" + i + "0");
            el.setAttribute("height", "" + height);
            ++i;
        }
    }
}

