/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.browserfield.internal;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.RunnableWithException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.PopupFactoryEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.browserfield.ISwingScoutBrowserField;
import org.eclipse.scout.rt.ui.swing.form.fields.browserfield.internal.DisposeUtil;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwingScoutBrowserField
extends SwingScoutValueFieldComposite<IBrowserField>
implements ISwingScoutBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutBrowserField.class);
    private static Display swtDisplay;
    private Shell m_swtShell;
    private Browser m_swtBrowser;
    private File m_tempDir;
    private final List<RunnableWithException<?>> m_swtCommandQueue;
    private final Object m_swtCommandQueueLock = new Object();
    private P_CanvasEx m_canvas;
    private P_HierarchyListener m_hierarchyListener;
    private P_MouseEventListener m_mouseEventListener = null;

    static {
        StaticDisplayDispatcher disp = new StaticDisplayDispatcher();
        disp.start();
        swtDisplay = disp.getDisplay();
    }

    public SwingScoutBrowserField() {
        this.m_swtCommandQueue = new LinkedList();
    }

    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add((Component)label);
        JPanelEx wordComponent = new JPanelEx();
        this.m_canvas = new P_CanvasEx();
        wordComponent.add((Component)this.m_canvas);
        container.add((Component)wordComponent);
        this.setSwingContainer((JComponent)container);
        this.setSwingLabel(label);
        this.setSwingField((JComponent)wordComponent);
        this.getSwingContainer().setLayout((LayoutManager)new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    private void installMouseListener() {
        if (SwingUtility.IS_JAVA_7_OR_GREATER) {
            this.m_mouseEventListener = new P_MouseEventListener();
            this.m_mouseEventListener.setSwtShell(this.m_swtShell);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.m_mouseEventListener, 16L);
        }
    }

    protected void attachScout() {
        super.attachScout();
        if (((IBrowserField)this.getScoutObject()).getLocation() != null) {
            this.setLocationFromScout();
        }
        if (this.m_hierarchyListener == null) {
            this.m_hierarchyListener = new P_HierarchyListener();
            this.m_canvas.addHierarchyListener(this.m_hierarchyListener);
        }
    }

    protected void detachScout() {
        if (this.m_hierarchyListener != null) {
            this.m_canvas.removeHierarchyListener(this.m_hierarchyListener);
            this.m_hierarchyListener = null;
        }
        if (this.m_tempDir != null) {
            IOUtility.deleteDirectory((File)this.m_tempDir);
            this.m_tempDir = null;
        }
        super.detachScout();
    }

    private boolean isSwtAttached() {
        return this.m_swtBrowser != null;
    }

    private void attachSwtSafe() {
        if (this.isSwtAttached()) {
            return;
        }
        PopupFactoryEx.activate();
        try {
            swtDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            SwingScoutBrowserField.this.m_swtShell = SWT_AWT.new_Shell((Display)Display.getDefault(), (Canvas)SwingScoutBrowserField.this.m_canvas);
                            SwingScoutBrowserField.this.m_swtBrowser = new Browser((Composite)SwingScoutBrowserField.this.m_swtShell, 0);
                            SwingScoutBrowserField.this.m_swtShell.setLayout((Layout)new FillLayout());
                            SwingScoutBrowserField.this.runSwtCommandsInsideSwtThread();
                            SwingScoutBrowserField.this.m_swtBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                                public void changing(LocationEvent event) {
                                    event.doit = SwingScoutBrowserField.this.fireBeforeLocationChangedFromSwt(event.location);
                                }

                                public void changed(LocationEvent event) {
                                    SwingScoutBrowserField.this.fireAfterLocationChangedFromSwt(event.location);
                                }
                            });
                            SwingScoutBrowserField.this.installMouseListener();
                        }
                        catch (Exception e) {
                            LOG.error("Unexpected error occured while attaching SWT Browser. All resources safely disposed.", (Throwable)e);
                            SwingScoutBrowserField.this.detachSwtSafe();
                            SwingScoutBrowserField.this.getSwingContainer().revalidate();
                        }
                    }
                    finally {
                        SwingScoutBrowserField.this.getSwingContainer().revalidate();
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error occured while attaching SWT.", (Throwable)e);
        }
    }

    private void detachSwtSafe() {
        if (!this.isSwtAttached()) {
            return;
        }
        PopupFactoryEx.deactivate();
        try {
            try {
                swtDisplay.syncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SwingScoutBrowserField.this.runSwtCommandsInsideSwtThread();
                        Object object = SwingScoutBrowserField.this.m_swtCommandQueueLock;
                        synchronized (object) {
                            SwingScoutBrowserField.this.m_swtCommandQueue.clear();
                        }
                        DisposeUtil.disposeSafe((Control)SwingScoutBrowserField.this.m_swtBrowser);
                        SwingScoutBrowserField.this.m_swtBrowser = null;
                        DisposeUtil.closeAndDisposeSafe(SwingScoutBrowserField.this.m_swtShell);
                        SwingScoutBrowserField.this.m_swtShell = null;
                    }
                });
            }
            catch (Throwable t) {
                LOG.error("Error occured while detaching SWT.", t);
                this.removeMouseListener();
            }
        }
        finally {
            this.removeMouseListener();
        }
    }

    private void removeMouseListener() {
        if (this.m_mouseEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.m_mouseEventListener);
            this.m_mouseEventListener.setSwtShell(null);
            this.m_mouseEventListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swtAsyncExec(RunnableWithException<?> command) {
        Object object = this.m_swtCommandQueueLock;
        synchronized (object) {
            this.m_swtCommandQueue.add(command);
        }
        swtDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                SwingScoutBrowserField.this.runSwtCommandsInsideSwtThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSwtCommandsInsideSwtThread() {
        if (this.isSwtAttached() && this.getScoutObject() != null) {
            while (true) {
                Object object = this.m_swtCommandQueueLock;
                synchronized (object) {
                    if (this.m_swtCommandQueue.isEmpty()) {
                        break;
                    }
                    RunnableWithException<?> r = this.m_swtCommandQueue.remove(0);
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        LOG.error("running command in COM", e);
                    }
                }
            }
        }
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("location".equals(name)) {
            this.setLocationFromScout();
        }
    }

    protected void setLocationFromScout() {
        this.setLocationInternal(((IBrowserField)this.getScoutObject()).getLocation());
    }

    protected void setValueFromScout(Object o) {
        String location;
        block9: {
            RemoteFile remoteFile = (RemoteFile)((IBrowserField)this.getScoutObject()).getValue();
            location = null;
            if (remoteFile != null && remoteFile.exists()) {
                try {
                    if (this.m_tempDir == null) {
                        try {
                            this.m_tempDir = IOUtility.createTempDirectory((String)"html");
                        }
                        catch (ProcessingException e) {
                            LOG.error("create temporary folder", (Throwable)e);
                        }
                    }
                    if (remoteFile.getName().matches(".*\\.(zip|jar)")) {
                        remoteFile.writeZipContentToDirectory(this.m_tempDir);
                        String simpleName = remoteFile.getName().replaceAll("\\.(zip|jar)", ".htm");
                        File[] fileArray = this.m_tempDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.getName().startsWith(simpleName)) {
                                location = f.toURI().toURL().toExternalForm();
                                break block9;
                            }
                            ++n2;
                        }
                        break block9;
                    }
                    File f = new File(this.m_tempDir, remoteFile.getName());
                    remoteFile.writeData(f);
                    location = f.toURI().toURL().toExternalForm();
                }
                catch (Throwable t) {
                    LOG.error("preparing html content for " + remoteFile, t);
                }
            }
        }
        this.setLocationInternal(location);
    }

    protected void setLocationInternal(final String location) {
        this.swtAsyncExec(new RunnableWithException<Object>(){

            public Object run() throws Throwable {
                if (StringUtility.hasText((String)location)) {
                    SwingScoutBrowserField.this.getSwtBrowser().setUrl(location);
                } else {
                    SwingScoutBrowserField.this.getSwtBrowser().setText("");
                }
                return null;
            }
        });
    }

    protected boolean fireBeforeLocationChangedFromSwt(final String location) {
        final AtomicReference accept = new AtomicReference();
        ClientSyncJob job = new ClientSyncJob("fireBeforeLocationChangedFromSwt", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) {
                accept.set(((IBrowserField)SwingScoutBrowserField.this.getScoutObject()).getUIFacade().fireBeforeLocationChangedFromUI(location));
            }
        };
        job.schedule();
        try {
            job.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return accept.get() != null ? (Boolean)accept.get() : false;
    }

    protected void fireAfterLocationChangedFromSwt(final String location) {
        ClientSyncJob job = new ClientSyncJob("fireAfterLocationChangedFromSwt", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                ((IBrowserField)SwingScoutBrowserField.this.getScoutObject()).getUIFacade().fireAfterLocationChangedFromUI(location);
            }
        };
        job.schedule();
    }

    protected Browser getSwtBrowser() {
        return this.m_swtBrowser;
    }

    private class P_CanvasEx
    extends Canvas {
        private static final long serialVersionUID = 1L;

        private P_CanvasEx() {
        }

        @Override
        public void removeNotify() {
            SwingScoutBrowserField.this.detachSwtSafe();
            super.removeNotify();
        }
    }

    private class P_HierarchyListener
    implements HierarchyListener {
        private P_HierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getID() == 1400 && (e.getChangeFlags() & 2L) != 0L && e.getChanged() == SwingScoutBrowserField.this.m_canvas) {
                if (e.getChanged().isDisplayable()) {
                    SwingScoutBrowserField.this.attachSwtSafe();
                } else {
                    SwingScoutBrowserField.this.detachSwtSafe();
                }
            }
        }
    }

    private class P_MouseEventListener
    implements AWTEventListener {
        private Shell m_swtShell;

        private P_MouseEventListener() {
        }

        public void setSwtShell(Shell swtShell) {
            this.m_swtShell = swtShell;
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e.getID() == 500 && this.m_swtShell != null) {
                swtDisplay.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P_MouseEventListener.this.m_swtShell.getEnabled()) {
                            P_MouseEventListener.this.m_swtShell.setEnabled(false);
                            P_MouseEventListener.this.m_swtShell.setEnabled(true);
                        }
                    }
                });
            }
        }
    }

    private static class StaticDisplayDispatcher
    extends Thread {
        private Display m_display;

        public StaticDisplayDispatcher() {
            super("SWT HTML Display Dispatcher");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.m_display = Display.getDefault();
            if (this.m_display.getThread() == Thread.currentThread()) {
                while (!this.m_display.isDisposed()) {
                    if (this.m_display.readAndDispatch()) continue;
                    this.m_display.sleep();
                }
            }
        }

        Display getDisplay() {
            while (this.m_display == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.m_display;
        }
    }
}

