/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public abstract class AbstractHtmlLinkDetector<T extends JComponent> {
    private URL m_hyperlink;
    private T m_container;

    public boolean detect(T container, Point p) {
        block6: {
            String s;
            AttributeSet set;
            Element elem;
            Point relativeMousePosition;
            Rectangle contentSize;
            HTMLDocument doc;
            View v;
            block7: {
                this.m_hyperlink = null;
                this.m_container = container;
                Component c = this.getComponent(p);
                if (!(c instanceof JComponent) || (v = (View)((JComponent)c).getClientProperty("html")) == null) break block6;
                doc = (HTMLDocument)v.getDocument();
                if ((v = v.getView(0)) == null || doc == null) break block6;
                Rectangle cellRectangle = this.getCellRectangle(p);
                contentSize = this.calculateContentSize((JComponent)c, cellRectangle);
                if (contentSize.contains(relativeMousePosition = new Point(p.x - cellRectangle.x, p.y - cellRectangle.y))) break block7;
                return false;
            }
            v.setSize(contentSize.width, contentSize.height);
            int pos = v.viewToModel(relativeMousePosition.x, relativeMousePosition.y, contentSize, new Position.Bias[1]);
            if (pos < 0 || (elem = doc.getCharacterElement(pos)) == null || (set = (AttributeSet)elem.getAttributes().getAttribute(HTML.Tag.A)) == null || (s = (String)set.getAttribute(HTML.Attribute.HREF)) == null) break block6;
            try {
                this.m_hyperlink = new URL(s);
                return true;
            }
            catch (MalformedURLException mfue) {
                try {
                    this.m_hyperlink = new URL(new URL("http://local"), s);
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected abstract Rectangle getCellRectangle(Point var1);

    protected abstract Component getComponent(Point var1);

    protected Rectangle calculateContentSize(JComponent c, Rectangle cellRectangle) {
        Insets cInsets = this.calculateInsets(c);
        Rectangle contentSize = new Rectangle(0, 0, cellRectangle.width - (cInsets.left + cInsets.right), cellRectangle.height - (cInsets.top + cInsets.bottom));
        contentSize.x += cInsets.left;
        contentSize.y += cInsets.top;
        return contentSize;
    }

    protected Insets calculateInsets(JComponent c) {
        JLabel label;
        Insets i = c.getInsets();
        if (c instanceof JLabel && (label = (JLabel)c).getIcon() != null) {
            i.left += label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        return i;
    }

    public URL getHyperlink() {
        return this.m_hyperlink;
    }

    public T getContainer() {
        return this.m_container;
    }
}

