/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.calendar;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewEvent;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewListener;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;

public class SwingScoutCalendar
extends SwingScoutComposite<ICalendar> {
    private DateChooser m_dateChooser;

    @Override
    protected void initializeSwing() {
        this.m_dateChooser = new DateChooser(true);
        JPanel container = this.m_dateChooser.getContainer();
        SwingUtility.installDefaultFocusHandling(container);
        this.setSwingField(container);
        container.addMouseListener(new P_SwingCalendarMouseListener());
        this.m_dateChooser.addCalendarViewListener(new P_SwingCalendarListener());
        container.getInputMap(2).put(SwingUtility.createKeystroke("F5"), "refresh");
        container.getActionMap().put("refresh", new P_SwingRefreshAction());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        final Date minDate = this.m_dateChooser.getViewDateStart();
        final Date maxDate = this.m_dateChooser.getViewDateEnd();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setVisibleRangeFromUI(minDate, maxDate);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
        this.setSetupFromScout(((ICalendar)this.getScoutObject()).getDisplayMode(), ((ICalendar)this.getScoutObject()).isDisplayCondensed());
        this.updateCalendarComponentsFromScout();
        this.setSelectionFromScout(((ICalendar)this.getScoutObject()).getSelectedDate(), ((ICalendar)this.getScoutObject()).getSelectedComponent());
        this.setWorkHours(((ICalendar)this.getScoutObject()).getStartHour(), ((ICalendar)this.getScoutObject()).getEndHour(), ((ICalendar)this.getScoutObject()).getUseOverflowCells());
        this.setShowDisplayModeSelectionPanel(((ICalendar)this.getScoutObject()).getShowDisplayModeSelection());
        this.setMarkNoonHour(((ICalendar)this.getScoutObject()).getMarkNoonHour());
        this.setMarkOutOfMonthDays(((ICalendar)this.getScoutObject()).getMarkOutOfMonthDays());
    }

    private void setWorkHours(int startHour, int endHour, boolean useOverflowCells) {
        this.getDateChooser().setWorkHours(startHour, endHour, useOverflowCells);
    }

    private void setShowDisplayModeSelectionPanel(boolean visible) {
        this.getDateChooser().setShowDisplayModeSelectionPanel(visible);
    }

    private void setMarkNoonHour(boolean visible) {
        this.getDateChooser().setMarkNoonHour(visible);
    }

    private void setMarkOutOfMonthDays(boolean visible) {
        this.getDateChooser().setMarkOutOfMonthDays(visible);
    }

    public DateChooser getDateChooser() {
        return this.m_dateChooser;
    }

    private void setSetupFromScout(int mode, boolean condensed) {
        this.getDateChooser().setDisplayMode(mode);
    }

    private void setSelectionFromScout(Date d, CalendarComponent cc) {
        this.getDateChooser().setDate(d);
    }

    private void setLoadInProgressFromScout(boolean b) {
        if (b) {
            this.getSwingField().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.getSwingField().setCursor(null);
        }
    }

    protected void updateCalendarComponentsFromScout() {
        this.getDateChooser().setModel(new P_SwingCalendarModel(((ICalendar)this.getScoutObject()).getComponents()));
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedDate") || name.equals("selectedComponent")) {
            this.setSelectionFromScout(((ICalendar)this.getScoutObject()).getSelectedDate(), ((ICalendar)this.getScoutObject()).getSelectedComponent());
        } else if (name.equals("components")) {
            this.updateCalendarComponentsFromScout();
        } else if (name.equals("loadInProgress")) {
            this.setLoadInProgressFromScout((Boolean)newValue);
        } else if (name.equals("displayMode") || name.equals("displayCondensed")) {
            this.setSetupFromScout(((ICalendar)this.getScoutObject()).getDisplayMode(), ((ICalendar)this.getScoutObject()).isDisplayCondensed());
        }
    }

    private void handleSwingCalendarPopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        CalendarComponent item = (CalendarComponent)this.getDateChooser().getCalendarItemFor(e);
        if (item != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    List scoutMenus = ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireComponentPopupFromUI();
                    new SwingPopupWorker(SwingScoutCalendar.this.getSwingEnvironment(), e.getComponent(), null, e.getPoint(), (List<? extends IMenu>)scoutMenus, false).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        } else {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    List scoutMenus = ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireNewPopupFromUI();
                    new SwingPopupWorker(SwingScoutCalendar.this.getSwingEnvironment(), e.getComponent(), null, e.getPoint(), (List<? extends IMenu>)scoutMenus, false).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    private void handleSwingCalendarItemAction(MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireComponentActionFromUI();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    private class P_SwingCalendarListener
    implements CalendarViewListener {
        private P_SwingCalendarListener() {
        }

        @Override
        public void viewChanged(CalendarViewEvent e) {
            switch (e.getType()) {
                case 30: {
                    if (SwingScoutCalendar.this.getUpdateSwingFromScoutLock().isAcquired()) {
                        return;
                    }
                    final Date d = SwingScoutCalendar.this.getDateChooser().getDate();
                    final CalendarComponent cc = (CalendarComponent)SwingScoutCalendar.this.getDateChooser().getSelectedItem();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setSelectionFromUI(d, cc);
                        }
                    };
                    SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                    break;
                }
                case 20: {
                    if (SwingScoutCalendar.this.getUpdateSwingFromScoutLock().isAcquired()) {
                        return;
                    }
                    final int m = SwingScoutCalendar.this.getDateChooser().getDisplayMode();
                    final Date minDate = SwingScoutCalendar.this.getDateChooser().getViewDateStart();
                    final Date maxDate = SwingScoutCalendar.this.getDateChooser().getViewDateEnd();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).setDisplayMode(m);
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setVisibleRangeFromUI(minDate, maxDate);
                        }
                    };
                    SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                    break;
                }
                case 10: {
                    final Date minDate = SwingScoutCalendar.this.getDateChooser().getViewDateStart();
                    final Date maxDate = SwingScoutCalendar.this.getDateChooser().getViewDateEnd();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().setVisibleRangeFromUI(minDate, maxDate);
                        }
                    };
                    SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                }
            }
        }
    }

    private class P_SwingCalendarModel
    implements CalendarModel {
        private Set<? extends CalendarComponent> m_components;
        private Map<Date, Collection<Object>> m_dayMap;

        public P_SwingCalendarModel(Set<? extends CalendarComponent> components) {
            this.m_components = components;
            this.m_dayMap = new HashMap<Date, Collection<Object>>();
            for (CalendarComponent calendarComponent : this.m_components) {
                Date[] dateArray = calendarComponent.getCoveredDays();
                int n = dateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Date day = dateArray[n2];
                    Collection<Object> list = this.m_dayMap.get(day);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        this.m_dayMap.put(day, list);
                    }
                    list.add(calendarComponent);
                    ++n2;
                }
            }
        }

        @Override
        public Collection<Object> getItemsAt(Date dateTruncatedToDay) {
            return this.m_dayMap.get(dateTruncatedToDay);
        }

        @Override
        public String getTooltip(Object item, Date d) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getTooltip(d);
        }

        @Override
        public String getLabel(Object item, Date d) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getLabel(d);
        }

        @Override
        public Date getFromDate(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getFromDate();
        }

        @Override
        public Date getToDate(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.getToDate();
        }

        @Override
        public Color getColor(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return ColorUtility.createColor(comp.getCell().getBackgroundColor());
        }

        @Override
        public boolean isFullDay(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.isFullDay();
        }

        @Override
        public boolean isDraggable(Object item) {
            CalendarComponent comp = (CalendarComponent)item;
            return comp.isDraggable();
        }

        @Override
        public void moveItem(final Object item, final Date newDate) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    CalendarComponent comp = (CalendarComponent)item;
                    ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireComponentMovedFromUI(comp, newDate);
                }
            };
            SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_SwingCalendarMouseListener
    extends MouseAdapter {
        MouseClickedBugFix fix;

        private P_SwingCalendarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.fix = new MouseClickedBugFix(e);
            if (e.isPopupTrigger()) {
                SwingScoutCalendar.this.handleSwingCalendarPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SwingScoutCalendar.this.handleSwingCalendarPopup(e);
            }
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.fix.mouseClicked()) {
                return;
            }
            if (!e.isPopupTrigger() && e.getClickCount() >= 2) {
                SwingScoutCalendar.this.handleSwingCalendarItemAction(e);
            }
        }
    }

    private class P_SwingRefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingRefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingScoutCalendar.this.getUpdateSwingFromScoutLock().isAcquired()) {
                return;
            }
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ICalendar)SwingScoutCalendar.this.getScoutObject()).getUIFacade().fireReloadFromUI();
                }
            };
            SwingScoutCalendar.this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }
}

