/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ISortOrderColumn;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.shared.security.CopyToClipboardPermission;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingLinkDetectorMouseMotionListener;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.table.ISwingScoutTable;
import org.eclipse.scout.rt.ui.swing.basic.table.SortIconUtility;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTable;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumn;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableColumnModel;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableHeaderCellRenderer;
import org.eclipse.scout.rt.ui.swing.basic.table.SwingTableModel;
import org.eclipse.scout.rt.ui.swing.basic.table.TableHtmlLinkDetector;
import org.eclipse.scout.rt.ui.swing.basic.table.TableKeyboardNavigationSupport;
import org.eclipse.scout.rt.ui.swing.basic.table.celleditor.SwingScoutTableCellEditor;
import org.eclipse.scout.rt.ui.swing.dnd.TransferHandlerEx;
import org.eclipse.scout.rt.ui.swing.ext.HtmlViewCache;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableHeaderEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.icons.CheckboxIcon;
import org.eclipse.scout.rt.ui.swing.icons.CompositeIcon;

public class SwingScoutTable
extends SwingScoutComposite<ITable>
implements ISwingScoutTable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTable.class);
    public static final int FONT_PADDING_TOP = 4;
    private P_ScoutTableListener m_scoutTableListener;
    private JTableHeader m_swingTableHeader;
    private JScrollPane m_swingScrollPane;
    private HtmlViewCache m_htmlViewCache;
    private ClientSyncJob m_storeColumnWidthsJob;
    private Job m_swingAutoOptimizeColumnWidthsJob;
    private List<IKeyStroke> m_installedScoutKs;
    private TableKeyboardNavigationSupport m_keyboardNavigationSupport;
    private SwingScoutTableCellEditor m_editor;

    @Override
    protected void initializeSwing() {
        this.m_htmlViewCache = new HtmlViewCache();
        P_SwingTable table = new P_SwingTable();
        this.m_swingScrollPane = new JScrollPaneEx(table);
        this.m_swingScrollPane.setBackground(table.getBackground());
        this.setSwingField(table);
        this.m_swingTableHeader = table.getTableHeader();
        if (this.m_swingTableHeader == null) {
            this.m_swingTableHeader = new JTableHeaderEx();
            table.setTableHeader(this.m_swingTableHeader);
        }
        table.setAutoCreateColumnsFromModel(false);
        this.m_swingTableHeader.setReorderingAllowed(true);
        this.m_swingTableHeader.setDefaultRenderer(new SwingTableHeaderCellRenderer(this.m_swingTableHeader.getDefaultRenderer(), this));
        table.setAutoCreateColumnsFromModel(false);
        table.setColumnModel(new SwingTableColumnModel(this.getSwingEnvironment(), this));
        table.setModel(new SwingTableModel(this.getSwingEnvironment(), this));
        this.m_editor = new SwingScoutTableCellEditor(this);
        this.m_editor.initialize();
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        table.setSelectionModel(new DefaultListSelectionModel());
        table.getSelectionModel().setAnchorSelectionIndex(0);
        table.getSelectionModel().addListSelectionListener(new P_SwingSelectionListener());
        table.addPropertyChangeListener("selectionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingScoutTable.this.getSwingTable().getSelectionModel().addListSelectionListener(new P_SwingSelectionListener());
            }
        });
        this.m_swingTableHeader.addMouseListener(new P_SwingHeadMouseListener());
        table.addMouseListener(new P_SwingRowMouseListener());
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TableHtmlLinkDetector detector;
                if (!e.isPopupTrigger() && (detector = new TableHtmlLinkDetector()).detect((JTable)e.getComponent(), e.getPoint())) {
                    SwingScoutTable.this.handleSwingHyperlinkAction(detector.getRowIndex(), detector.getColumnIndex(), detector.getHyperlink());
                }
            }
        });
        table.addMouseMotionListener(new SwingLinkDetectorMouseMotionListener<JTable>(new TableHtmlLinkDetector()));
        this.m_swingScrollPane.getViewport().addMouseListener(new P_SwingEmptySpaceMouseListener());
        this.m_swingScrollPane.addComponentListener(new ComponentAdapter(){
            private int m_oldHeight = -1;

            @Override
            public void componentResized(ComponentEvent e) {
                int newHeight = e.getComponent().getHeight();
                if (this.m_oldHeight >= 0 && this.m_oldHeight == newHeight) {
                    return;
                }
                this.m_oldHeight = newHeight;
                ITable t = (ITable)SwingScoutTable.this.getScoutObject();
                if (t != null && t.isScrollToSelection() && e.getComponent().isShowing()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutTable.this.scrollToSelection();
                        }
                    });
                }
            }
        });
        table.getInputMap(0).put(SwingUtility.createKeystroke("CONTEXT_MENU"), "contextMenu");
        table.getActionMap().put("contextMenu", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingScoutTable.this.getUpdateSwingFromScoutLock().isAcquired()) {
                    return;
                }
                if (SwingScoutTable.this.getScoutObject() != null) {
                    int[] rowIndexes = SwingScoutTable.this.getSwingTable().getSelectedRows();
                    Point p = new Point(0, 0);
                    if (rowIndexes != null && rowIndexes.length > 0) {
                        p = SwingScoutTable.this.getSwingTable().getCellRect(rowIndexes[0], 0, false).getLocation();
                    }
                    p.translate(2, 2);
                    final JTableEx compF = SwingScoutTable.this.getSwingTable();
                    final Point pFinal = p;
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ITableContextMenu contextMenu = ((ITable)SwingScoutTable.this.getScoutObject()).getContextMenu();
                            new SwingPopupWorker(SwingScoutTable.this.getSwingEnvironment(), compF, pFinal, (IContextMenu)contextMenu, contextMenu.getActiveFilter()).enqueue();
                        }
                    };
                    SwingScoutTable.this.getSwingEnvironment().invokeScoutLater(t, 5678L);
                }
            }
        });
    }

    @Override
    public JTableEx getSwingTable() {
        return (JTableEx)this.getSwingField();
    }

    protected SwingTableModel getSwingTableModel() {
        return (SwingTableModel)this.getSwingTable().getModel();
    }

    protected SwingTableColumnModel getSwingTableColumnModel() {
        return (SwingTableColumnModel)this.getSwingTable().getColumnModel();
    }

    protected ListSelectionModel getSwingTableSelectionModel() {
        return this.getSwingTable().getSelectionModel();
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_swingScrollPane;
    }

    protected void setContextColumnFromSwing(int viewIndex) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        this.registerColumnHeaderPopupOwner(viewIndex);
        if (this.getScoutObject() != null) {
            final IColumn scoutCol = this.getSwingTableColumnModel().swingToScoutColumn(viewIndex);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().setContextColumnFromUI(scoutCol);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener == null) {
            this.m_scoutTableListener = new P_ScoutTableListener();
            ((ITable)this.getScoutObject()).addUITableListener((TableListener)this.m_scoutTableListener);
        }
        this.setMultiSelectFromScout(((ITable)this.getScoutObject()).isMultiSelect());
        this.setMultilineTextFromScout(((ITable)this.getScoutObject()).isMultilineText());
        this.setKeyboardNavigationFromScout();
        this.setHeaderVisibleFromScout(((ITable)this.getScoutObject()).isHeaderVisible());
        this.setColumnsAutoResizeFromScout(((ITable)this.getScoutObject()).isAutoResizeColumns());
        this.setKeyStrokesFromScout();
        this.m_swingScrollPane.getViewport().setTransferHandler(new P_SwingEmptySpaceTransferHandler());
        this.getSwingTable().setTransferHandler(new P_SwingRowTransferHandler());
        this.getSwingTable().setDragEnabled(((ITable)this.getScoutObject()).getDragType() != 0 || ((ITable)this.getScoutObject()).getDropType() != 0);
        this.setSelectionFromScout();
        if (((ITable)this.getScoutObject()).isCheckable()) {
            this.getSwingTable().getInputMap(0).put(SwingUtility.createKeystroke("SPACE"), "toggleRow");
            this.getSwingTable().getActionMap().put("toggleRow", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTable.this.handleSwingRowClick(SwingScoutTable.this.getSwingTable().getSelectedRow());
                }
            });
        }
        this.enqueueAutoOptimizeColumnWidths();
        final IEventHistory h = ((ITable)this.getScoutObject()).getEventHistory();
        if (h != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (TableEvent e : h.getRecentEvents()) {
                        SwingScoutTable.this.handleScoutTableEventInSwing(e);
                    }
                }
            });
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_editor != null) {
            this.m_editor.dispose();
        }
        if (this.m_scoutTableListener != null) {
            ((ITable)this.getScoutObject()).removeTableListener((TableListener)this.m_scoutTableListener);
            this.m_scoutTableListener = null;
        }
    }

    protected void setMultiSelectFromScout(boolean on) {
        if (on) {
            this.getSwingTable().setSelectionMode(2);
        } else {
            this.getSwingTable().setSelectionMode(0);
        }
    }

    protected void setScrollToSelectionFromScout() {
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void setMultilineTextFromScout(boolean on) {
        this.getSwingTable().setDynamicRowHeight(on);
    }

    protected void setKeyboardNavigationFromScout() {
        boolean hasKeyboardNavigation = ((ITable)this.getScoutObject()).hasKeyboardNavigation();
        if (hasKeyboardNavigation) {
            if (this.m_keyboardNavigationSupport == null) {
                this.m_keyboardNavigationSupport = new P_KeyboardNavigationSupport(this.getSwingTable());
            }
        } else if (this.m_keyboardNavigationSupport != null) {
            this.m_keyboardNavigationSupport.dispose();
            this.m_keyboardNavigationSupport = null;
        }
    }

    protected void setHeaderVisibleFromScout(boolean on) {
        if (on) {
            this.getSwingTable().setTableHeader(this.m_swingTableHeader);
        } else {
            this.getSwingTable().setTableHeader(null);
        }
    }

    protected void setColumnsAutoResizeFromScout(boolean on) {
        this.getSwingTable().setAutoResizeMode(on ? 4 : 0);
    }

    protected void setKeyStrokesFromScout() {
        JComponent component = this.getSwingContainer();
        if (component == null) {
            component = this.getSwingField();
        }
        if (component != null) {
            if (this.m_installedScoutKs != null) {
                for (IKeyStroke ks : this.m_installedScoutKs) {
                    KeyStroke swingKs = SwingUtility.createKeystroke(ks);
                    InputMap imap = component.getInputMap(1);
                    imap.remove(swingKs);
                    ActionMap amap = component.getActionMap();
                    amap.remove(ks.getActionId());
                }
            }
            this.m_installedScoutKs = null;
            for (IKeyStroke scoutKs : ((ITable)this.getScoutObject()).getKeyStrokes()) {
                int swingWhen = 1;
                KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                SwingScoutAction<IKeyStroke> action = new SwingScoutAction<IKeyStroke>();
                action.createField(scoutKs, this.getSwingEnvironment());
                InputMap imap = component.getInputMap(swingWhen);
                imap.put(swingKs, scoutKs.getActionId());
                ActionMap amap = component.getActionMap();
                amap.put(scoutKs.getActionId(), action.getSwingAction());
            }
            this.m_installedScoutKs = ((ITable)this.getScoutObject()).getKeyStrokes();
        }
    }

    protected void setSelectionFromScout() {
        if (this.getScoutObject() == null) {
            return;
        }
        List scoutRows = ((ITable)this.getScoutObject()).getSelectedRows();
        ListSelectionModel lsm = this.getSwingTableSelectionModel();
        int[] oldSwingRows = this.getSwingTable().getSelectedRows();
        int[] newSwingRows = this.scoutToSwingRows(scoutRows);
        Arrays.sort(oldSwingRows);
        Arrays.sort(newSwingRows);
        if (!CompareUtility.equals((Object)oldSwingRows, (Object)newSwingRows) && !lsm.getValueIsAdjusting()) {
            int index;
            HashSet<Integer> addSet = new HashSet<Integer>();
            HashSet<Integer> removeSet = new HashSet<Integer>();
            int[] nArray = newSwingRows;
            int n = newSwingRows.length;
            int n2 = 0;
            while (n2 < n) {
                index = nArray[n2];
                addSet.add(index);
                ++n2;
            }
            nArray = oldSwingRows;
            n = oldSwingRows.length;
            n2 = 0;
            while (n2 < n) {
                index = nArray[n2];
                addSet.remove(index);
                removeSet.add(index);
                ++n2;
            }
            nArray = newSwingRows;
            n = newSwingRows.length;
            n2 = 0;
            while (n2 < n) {
                index = nArray[n2];
                removeSet.remove(index);
                ++n2;
            }
            try {
                int index2;
                lsm.setValueIsAdjusting(true);
                int lastIndex = -1;
                Iterator iterator = addSet.iterator();
                while (iterator.hasNext()) {
                    index2 = (Integer)iterator.next();
                    lsm.addSelectionInterval(index2, index2);
                    lastIndex = index2;
                }
                iterator = removeSet.iterator();
                while (iterator.hasNext()) {
                    index2 = (Integer)iterator.next();
                    lsm.removeSelectionInterval(index2, index2);
                }
                if (lastIndex < 0) {
                    lastIndex = lsm.getMinSelectionIndex();
                }
                lsm.setAnchorSelectionIndex(lastIndex);
                lsm.setLeadSelectionIndex(lastIndex);
            }
            finally {
                lsm.setValueIsAdjusting(false);
            }
        }
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void setSelectionFromSwing(int[] swingRows) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            if (this.getSwingTable().getSelectionModel().getValueIsAdjusting()) {
                return;
            }
            final List<ITableRow> scoutRows = this.swingToScoutRows(swingRows);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwingScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "103");
                        ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().setSelectedRowsFromUI(scoutRows);
                    }
                    finally {
                        SwingScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "103");
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void scrollToSelection() {
        int[] swingRows = this.getSwingTable().getSelectedRows();
        if (swingRows.length > 0) {
            Rectangle viewRect = this.getSwingTable().getVisibleRect();
            if (viewRect.isEmpty()) {
                return;
            }
            Rectangle selBeginRect = this.getSwingTable().getCellRect(swingRows[0], 0, true);
            Rectangle selEndRect = this.getSwingTable().getCellRect(swingRows[swingRows.length - 1], 0, true);
            Rectangle selRect = selBeginRect.union(selEndRect);
            Rectangle rootRect = new Rectangle(selRect.x, 0, selRect.width, selRect.y + selRect.height);
            if (rootRect.height <= viewRect.height) {
                this.getSwingTable().scrollRectToVisible(rootRect);
            } else if (selRect.height <= viewRect.height) {
                this.getSwingTable().scrollRectToVisible(selRect);
            } else if (selBeginRect.height <= viewRect.height) {
                this.getSwingTable().scrollRectToVisible(selBeginRect);
            }
        }
    }

    protected void storeColumnWidthsFromSwing(List<TableColumn> swingColumns) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        SwingTableColumnModel cm = this.getSwingTableColumnModel();
        int n = cm.getColumnCount();
        final IColumn[] scoutCols = new IColumn[swingColumns.size()];
        final int[] scoutColWidths = new int[swingColumns.size()];
        int index = 0;
        while (index < swingColumns.size()) {
            TableColumn swingCol = swingColumns.get(index);
            int i = 0;
            while (i < n) {
                if (cm.getColumn(i) == swingCol) {
                    scoutCols[index] = ((SwingTableColumn)swingCol).getScoutColumn();
                    scoutColWidths[index] = swingCol.getPreferredWidth();
                    break;
                }
                ++i;
            }
            ++index;
        }
        if (this.m_storeColumnWidthsJob != null) {
            this.m_storeColumnWidthsJob.cancel();
        }
        this.m_storeColumnWidthsJob = new ClientSyncJob("Store column widths", this.getSwingEnvironment().getScoutSession()){

            protected IStatus runStatus(IProgressMonitor monitor) {
                if (SwingScoutTable.this.getScoutObject() != null) {
                    int i = 0;
                    while (i < scoutCols.length) {
                        if (scoutCols[i] != null) {
                            ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().setColumnWidthFromUI(scoutCols[i], scoutColWidths[i]);
                        }
                        ++i;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.m_storeColumnWidthsJob.schedule(400L);
    }

    @Override
    protected void handleScoutPropertyChange(String propName, Object newValue) {
        if (propName.equals("multiSelect")) {
            this.setMultiSelectFromScout((Boolean)newValue);
        } else if (propName.equals("multilineText")) {
            this.setMultilineTextFromScout((Boolean)newValue);
        } else if (propName.equals("headerVisible")) {
            this.setHeaderVisibleFromScout((Boolean)newValue);
        } else if (propName.equals("autoResizeColumns")) {
            this.setColumnsAutoResizeFromScout((Boolean)newValue);
        } else if (propName.equals("keyStroks")) {
            this.setKeyStrokesFromScout();
        } else if (propName.equals("dragType")) {
            this.getSwingTable().setDragEnabled(((ITable)this.getScoutObject()).getDragType() != 0 || ((ITable)this.getScoutObject()).getDropType() != 0);
        } else if (propName.equals("dropType")) {
            this.getSwingTable().setDragEnabled(((ITable)this.getScoutObject()).getDragType() != 0 || ((ITable)this.getScoutObject()).getDropType() != 0);
        } else if (propName.equals("keyboardNavigation")) {
            this.setKeyboardNavigationFromScout();
        } else if (propName.equals("scrollToSelection")) {
            this.setScrollToSelectionFromScout();
        }
    }

    protected boolean isHandleScoutTableEvent(List<? extends TableEvent> events) {
        for (TableEvent tableEvent : events) {
            switch (tableEvent.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 200: 
                case 210: 
                case 770: 
                case 780: 
                case 800: 
                case 805: 
                case 830: {
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleScoutTableEventInSwing(TableEvent e) {
        SwingTableModel swingTableModel = (SwingTableModel)this.getSwingTable().getModel();
        int newRowCount = ((ITable)this.getScoutObject()).getFilteredRowCount();
        switch (e.getType()) {
            case 800: {
                this.getSwingTable().requestFocus();
                break;
            }
            case 805: {
                TableColumnModel tcm = this.getSwingTable().getColumnModel();
                int swingCol = -1;
                int c = 0;
                while (c < tcm.getColumnCount()) {
                    if (tcm.getColumn(c) instanceof SwingTableColumn && ((SwingTableColumn)tcm.getColumn(c)).getScoutColumn() == e.getFirstColumn()) {
                        swingCol = c;
                        break;
                    }
                    ++c;
                }
                int swingRow = this.scoutToSwingRow(e.getFirstRow());
                if (swingRow < 0 || swingCol < 0) break;
                JTableEx table = this.getSwingTable();
                table.scrollRectToVisible(((JTable)table).getCellRect(swingRow, swingCol, true));
                table.editCellAt(swingRow, swingCol);
                break;
            }
            case 102: 
            case 105: {
                swingTableModel.updateModelState(newRowCount);
                break;
            }
            case 101: 
            case 200: {
                swingTableModel.updateModelState(newRowCount);
                break;
            }
            case 100: 
            case 210: {
                swingTableModel.updateModelState(newRowCount);
                break;
            }
            case 1: 
            case 770: 
            case 780: {
                SwingTableColumnModel swingColModel = (SwingTableColumnModel)this.getSwingTable().getColumnModel();
                swingColModel.initializeColumns();
                swingTableModel.updateModelState(newRowCount);
                break;
            }
            case 103: {
                break;
            }
            case 830: {
                this.scrollToSelection();
            }
        }
        switch (e.getType()) {
            case 1: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 200: 
            case 210: 
            case 770: 
            case 780: {
                this.setSelectionFromScout();
                this.getSwingTable().repaint();
            }
        }
        switch (e.getType()) {
            case 100: 
            case 101: 
            case 102: 
            case 105: {
                this.m_htmlViewCache = new HtmlViewCache();
            }
        }
        block16 : switch (e.getType()) {
            case 1: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 210: {
                for (IColumn c : ((ITable)this.getScoutObject()).getColumns()) {
                    if (!c.isAutoOptimizeWidth()) continue;
                    this.enqueueAutoOptimizeColumnWidths();
                    break block16;
                }
                break;
            }
        }
    }

    private void enqueueAutoOptimizeColumnWidths() {
        if (this.m_swingAutoOptimizeColumnWidthsJob != null) {
            this.m_swingAutoOptimizeColumnWidthsJob.cancel();
        }
        this.m_swingAutoOptimizeColumnWidthsJob = new P_SwingAutoOptimizeColumnWidthsJob();
        this.m_swingAutoOptimizeColumnWidthsJob.schedule(200L);
    }

    protected void handleSwingEmptySpaceSelection(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (e.getID() == 501) {
                        ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().setSelectedRowsFromUI(new ArrayList(0));
                    }
                    if (e.isPopupTrigger()) {
                        ITableContextMenu contextMenu = ((ITable)SwingScoutTable.this.getScoutObject()).getContextMenu();
                        new SwingPopupWorker(SwingScoutTable.this.getSwingEnvironment(), e.getComponent(), e.getPoint(), (IContextMenu)contextMenu, contextMenu.getActiveFilter()).enqueue();
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    protected void handleSwingDropAction(int rowIndex, Transferable swingTransferable) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null && swingTransferable != null) {
            final TransferObject scoutTransferable = SwingUtility.createScoutTransferable(swingTransferable);
            final ITableRow scoutRow = this.swingToScoutRow(rowIndex);
            if (scoutTransferable != null) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireRowDropActionFromUI(scoutRow, scoutTransferable);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    protected void handleSwingRowPopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ITableContextMenu contextMenu = ((ITable)SwingScoutTable.this.getScoutObject()).getContextMenu();
                    new SwingPopupWorker(SwingScoutTable.this.getSwingEnvironment(), e.getComponent(), null, e.getPoint(), (IContextMenu)contextMenu, contextMenu.getActiveFilter(), false).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    protected void handleSwingRowClick(int rowIndex) {
        ITableRow scoutRow;
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null && rowIndex >= 0 && (scoutRow = this.swingToScoutRow(rowIndex)) != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireRowClickFromUI(scoutRow);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwingHyperlinkAction(int rowIndex, int colIndex, final URL url) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null && rowIndex >= 0 && colIndex >= 0) {
            final ITableRow scoutRow = this.swingToScoutRow(rowIndex);
            final IColumn scoutCol = this.getSwingTableColumnModel().swingToScoutColumn(colIndex);
            if (scoutRow != null && scoutCol != null) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(scoutRow, scoutCol, url);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    protected void handleSwingRowAction(int rowIndex) {
        ITableRow scoutRow;
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null && rowIndex >= 0 && (scoutRow = this.swingToScoutRow(rowIndex)) != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireRowActionFromUI(scoutRow);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwingHeaderSort(final int sortIndex, boolean shiftDown, final boolean controlDown) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        this.setContextColumnFromSwing(sortIndex);
        if (sortIndex >= 0 && this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IColumn scoutCol = ((ITable)SwingScoutTable.this.getScoutObject()).getColumnSet().getVisibleColumn(sortIndex);
                    ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().setContextColumnFromUI(scoutCol);
                    ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireHeaderSortFromUI(scoutCol, controlDown);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 200L);
        }
    }

    protected void handleSwingHeaderPopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        int sortIndex = this.getSwingTable().getTableHeader().columnAtPoint(e.getPoint());
        this.setContextColumnFromSwing(sortIndex);
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    new SwingPopupWorker(SwingScoutTable.this.getSwingEnvironment(), e.getComponent(), null, e.getPoint(), (IContextMenu)((ITable)SwingScoutTable.this.getScoutObject()).getContextMenu(), ActionUtility.createMenuFilterVisibleAndMenuTypes((IMenuType[])new IMenuType[]{TableMenuType.EmptySpace, TableMenuType.Header}), false).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    private void registerColumnHeaderPopupOwner(int columnViewIndex) {
        this.getSwingEnvironment().setPopupOwner(null, null);
        if (columnViewIndex < 0) {
            return;
        }
        JTableHeader header = this.getSwingTable().getTableHeader();
        if (header == null) {
            return;
        }
        Point p = header.getLocationOnScreen();
        Point dp = header.getHeaderRect(columnViewIndex).getLocation();
        Rectangle headerCellRect = new Rectangle(p.x + dp.x, p.y + dp.y + header.getHeight(), 0, 0);
        this.getSwingEnvironment().setPopupOwner(this.getSwingTable(), headerCellRect);
    }

    protected Transferable handleSwingDragRequest() {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return null;
        }
        if (((ITable)this.getScoutObject()).getDragType() == 0) {
            return null;
        }
        final Holder result = new Holder(TransferObject.class, null);
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireRowsDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TransferObject scoutTransferable = (TransferObject)result.getValue();
        return SwingUtility.createSwingTransferable(scoutTransferable);
    }

    protected Transferable handleSwingCopyRequest() {
        TransferObject scoutTransferable;
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return null;
        }
        final Holder result = new Holder(TransferObject.class, null);
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (!ACCESS.check((Permission)new CopyToClipboardPermission())) {
                        return;
                    }
                    TransferObject scoutTransferable = ((ITable)SwingScoutTable.this.getScoutObject()).getUIFacade().fireRowsCopyRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((scoutTransferable = (TransferObject)result.getValue()) != null) {
            return SwingUtility.createSwingTransferable(scoutTransferable);
        }
        return null;
    }

    protected void handleKeyboardNavigationFromSwing(int rowIndex) {
        ListSelectionModel selectionModel = this.getSwingTable().getSelectionModel();
        selectionModel.setSelectionInterval(rowIndex, rowIndex);
        this.scrollToSelection();
    }

    protected ITableRow swingToScoutRow(int rowIndex) {
        ITable table = (ITable)this.getScoutObject();
        if (table != null && rowIndex >= 0) {
            return table.getFilteredRow(rowIndex);
        }
        return null;
    }

    protected List<ITableRow> swingToScoutRows(int[] swingRows) {
        if (swingRows == null || swingRows.length == 0) {
            return CollectionUtility.emptyArrayList();
        }
        ITable table = (ITable)this.getScoutObject();
        if (table != null) {
            ArrayList<ITableRow> result = new ArrayList<ITableRow>(swingRows.length);
            int[] nArray = swingRows;
            int n = swingRows.length;
            int n2 = 0;
            while (n2 < n) {
                int swingRowIndex = nArray[n2];
                ITableRow row = table.getFilteredRow(swingRowIndex);
                if (row != null) {
                    result.add(row);
                }
                ++n2;
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    protected int scoutToSwingRow(ITableRow row) {
        ITable table = (ITable)this.getScoutObject();
        if (table != null && row != null) {
            return table.getFilteredRowIndex(row);
        }
        return -1;
    }

    protected int[] scoutToSwingRows(List<? extends ITableRow> rows) {
        if (!CollectionUtility.hasElements(rows)) {
            return new int[0];
        }
        ITable table = (ITable)this.getScoutObject();
        if (table != null) {
            int mismatchCount = 0;
            int[] swingRows = new int[rows.size()];
            int i = 0;
            for (ITableRow iTableRow : rows) {
                int scoutIndex = table.getFilteredRowIndex(iTableRow);
                if (scoutIndex >= 0) {
                    swingRows[i] = scoutIndex;
                } else {
                    swingRows[i] = -1;
                    ++mismatchCount;
                }
                ++i;
            }
            if (mismatchCount > 0) {
                int[] nArray = new int[swingRows.length - mismatchCount];
                int index = 0;
                int[] nArray2 = swingRows;
                int n = swingRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray2[n2];
                    if (row >= 0) {
                        nArray[index] = row;
                        ++index;
                    }
                    ++n2;
                }
                swingRows = nArray;
            }
            return swingRows;
        }
        return new int[0];
    }

    private void closeEditor() {
        TableCellEditor cellEditor = this.getSwingTable().getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private class P_IconWithMarker
    implements Icon {
        private static final int MARKER_SIZE = 5;
        private Icon m_icon;

        private P_IconWithMarker(Icon icon) {
            this.m_icon = icon;
            if (this.m_icon == null) {
                this.m_icon = new ImageIcon();
            }
        }

        @Override
        public int getIconHeight() {
            return this.m_icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.m_icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color editableCellMarkerColor = UIManager.getColor("Table.cell.markerColorEditableCell");
            if (editableCellMarkerColor == null) {
                editableCellMarkerColor = Color.GRAY;
            }
            g.setColor(editableCellMarkerColor);
            int[] nArray = new int[3];
            nArray[1] = 5;
            int[] nArray2 = new int[3];
            nArray2[2] = 5;
            g.fillPolygon(nArray, nArray2, 3);
            this.m_icon.paintIcon(c, g, x, y);
        }
    }

    private class P_KeyboardNavigationSupport
    extends TableKeyboardNavigationSupport {
        public P_KeyboardNavigationSupport(JTableEx table) {
            super(table);
        }

        @Override
        void handleKeyboardNavigation(int rowIndex) {
            SwingScoutTable.this.handleKeyboardNavigationFromSwing(rowIndex);
        }
    }

    private class P_ScoutTableListener
    implements TableListener {
        private P_ScoutTableListener() {
        }

        public void tableChanged(final TableEvent e) {
            if (SwingScoutTable.this.isHandleScoutTableEvent(CollectionUtility.arrayList((Object)e))) {
                if (SwingScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingScoutTable.this.getUpdateSwingFromScoutLock().acquire();
                            SwingScoutTable.this.handleScoutTableEventInSwing(e);
                        }
                        finally {
                            SwingScoutTable.this.getUpdateSwingFromScoutLock().release();
                        }
                    }
                };
                SwingScoutTable.this.getSwingEnvironment().invokeSwingLater(t);
            }
        }

        public void tableChangedBatch(List<? extends TableEvent> events) {
            if (SwingScoutTable.this.isHandleScoutTableEvent(events)) {
                final ArrayList<TableEvent> filteredList = new ArrayList<TableEvent>();
                for (TableEvent tableEvent : events) {
                    if (SwingScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + tableEvent.getType())) continue;
                    filteredList.add(tableEvent);
                }
                if (CollectionUtility.hasElements(filteredList)) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingScoutTable.this.getUpdateSwingFromScoutLock().acquire();
                                for (TableEvent e : filteredList) {
                                    SwingScoutTable.this.handleScoutTableEventInSwing(e);
                                }
                            }
                            finally {
                                SwingScoutTable.this.getUpdateSwingFromScoutLock().release();
                            }
                        }
                    };
                    SwingScoutTable.this.getSwingEnvironment().invokeSwingLater(runnable);
                }
            }
        }
    }

    private class P_SwingAutoOptimizeColumnWidthsJob
    extends Job {
        public P_SwingAutoOptimizeColumnWidthsJob() {
            super("Swing:AutoOptimizeColumnWidths");
        }

        protected IStatus run(IProgressMonitor monitor) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingScoutTable.this.getSwingTable() == null) {
                        return;
                    }
                    SwingTableColumnModel tcm = SwingScoutTable.this.getSwingTableColumnModel();
                    if (tcm == null) {
                        return;
                    }
                    int tcCount = tcm.getColumnCount();
                    int i = 0;
                    while (i < tcCount) {
                        TableColumn tc = tcm.getColumn(i);
                        if (tc instanceof SwingTableColumn && ((SwingTableColumn)tc).getScoutColumn().isAutoOptimizeWidth()) {
                            ((P_SwingTable)SwingScoutTable.this.getSwingTable()).setOptimalColumnWidth(tc);
                        }
                        ++i;
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    private class P_SwingEmptySpaceMouseListener
    extends MouseAdapter {
        private P_SwingEmptySpaceMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SwingScoutTable.this.closeEditor();
            SwingScoutTable.this.handleSwingEmptySpaceSelection(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SwingScoutTable.this.handleSwingEmptySpaceSelection(e);
        }
    }

    private class P_SwingEmptySpaceTransferHandler
    extends TransferHandlerEx {
        private static final long serialVersionUID = 1L;

        private P_SwingEmptySpaceTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return SwingUtility.isSupportedTransfer(((ITable)SwingScoutTable.this.getScoutObject()).getDropType(), transferFlavors);
        }

        @Override
        public boolean importDataEx(JComponent comp, Transferable t, Point location) {
            int selectedRow = -1;
            SwingScoutTable.this.handleSwingDropAction(selectedRow, t);
            return true;
        }

        @Override
        public boolean canDrag() {
            return false;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return null;
        }
    }

    private class P_SwingHeadMouseListener
    extends MouseAdapter {
        private Point m_pressedPoint;
        MouseClickedBugFix fix;

        private P_SwingHeadMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SwingScoutTable.this.closeEditor();
            this.fix = new MouseClickedBugFix(e);
            this.m_pressedPoint = e.getPoint();
            JTableEx table = SwingScoutTable.this.getSwingTable();
            int colIndex = table.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
            if (colIndex >= 0) {
                table.setColumnSelectionInterval(colIndex, colIndex);
            }
            if (e.isPopupTrigger()) {
                SwingScoutTable.this.handleSwingHeaderPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableEx table = SwingScoutTable.this.getSwingTable();
            if (e.isPopupTrigger()) {
                SwingScoutTable.this.handleSwingHeaderPopup(e);
            } else {
                int index;
                if (this.m_pressedPoint == null) {
                    this.m_pressedPoint = e.getPoint();
                }
                this.m_pressedPoint.translate(-e.getX(), -e.getY());
                int r = Math.abs(this.m_pressedPoint.x) + Math.abs(this.m_pressedPoint.y);
                if (r < 4 && e.getClickCount() == 1 && table.getTableHeader().getCursor().getType() == 0 && (index = table.getTableHeader().columnAtPoint(e.getPoint())) >= 0) {
                    int scoutViewIndex = index;
                    SwingScoutTable.this.handleSwingHeaderSort(scoutViewIndex, e.isShiftDown(), e.isControlDown());
                }
            }
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.fix != null && this.fix.mouseClicked()) {
                return;
            }
            if (e.getClickCount() == 2 && SwingScoutTable.this.getSwingTable().getTableHeader().getCursor().getType() != 0) {
                int[] oldColumnWidths = new int[SwingScoutTable.this.getSwingTableColumnModel().getColumnCount()];
                int i = 0;
                while (i < oldColumnWidths.length) {
                    oldColumnWidths[i] = SwingScoutTable.this.getSwingTableColumnModel().getColumn(i).getWidth();
                    ++i;
                }
                ((P_SwingTable)SwingScoutTable.this.getSwingTable()).setOptimalColumnWidths();
                ArrayList<TableColumn> list = new ArrayList<TableColumn>();
                int i2 = 0;
                while (i2 < oldColumnWidths.length) {
                    TableColumn tc = SwingScoutTable.this.getSwingTableColumnModel().getColumn(i2);
                    int newWidth = tc.getPreferredWidth();
                    if (newWidth != oldColumnWidths[i2]) {
                        list.add(tc);
                    }
                    ++i2;
                }
                if (list.size() > 0) {
                    SwingScoutTable.this.storeColumnWidthsFromSwing(list);
                }
            }
        }
    }

    private class P_SwingRowMouseListener
    extends MouseInputAdapter {
        MouseClickedBugFix fix;

        private P_SwingRowMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point currentCell;
            JTableEx table = SwingScoutTable.this.getSwingTable();
            Point editingCell = new Point(table.getEditingColumn(), table.getEditingRow());
            if (CompareUtility.notEquals((Object)editingCell, (Object)(currentCell = new Point(table.columnAtPoint(e.getPoint()), table.rowAtPoint(e.getPoint()))))) {
                SwingScoutTable.this.closeEditor();
            }
            this.fix = new MouseClickedBugFix(e);
            int pressedRow = table.rowAtPoint(e.getPoint());
            if (e.isMetaDown() && table.isEnabled()) {
                boolean autoSelectRow = true;
                if (table.getSelectionModel().getSelectionMode() != 0 && (e.isControlDown() || e.isShiftDown()) && table.getSelectedRowCount() > 0) {
                    autoSelectRow = false;
                }
                if (autoSelectRow && pressedRow >= 0 && !table.isRowSelected(pressedRow)) {
                    table.setRowSelectionInterval(pressedRow, pressedRow);
                }
            }
            if (e.getClickCount() == 2 && pressedRow >= 0 && table.isEnabled() && pressedRow >= 0 && table.getSelectedRowCount() <= 1 && !table.isRowSelected(pressedRow)) {
                table.setRowSelectionInterval(pressedRow, pressedRow);
            }
            int swingViewIndex = SwingScoutTable.this.getSwingTable().columnAtPoint(e.getPoint());
            SwingScoutTable.this.setContextColumnFromSwing(swingViewIndex);
            if (e.isPopupTrigger()) {
                SwingScoutTable.this.handleSwingRowPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SwingScoutTable.this.handleSwingRowPopup(e);
            }
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int pressedRow;
            if (this.fix != null && this.fix.mouseClicked()) {
                return;
            }
            if (e.getClickCount() == 1 && e.getButton() == 1) {
                int pressedRow2 = SwingScoutTable.this.getSwingTable().rowAtPoint(e.getPoint());
                if (pressedRow2 >= 0) {
                    SwingScoutTable.this.handleSwingRowClick(pressedRow2);
                }
            } else if (e.getClickCount() == 2 && e.getButton() == 1 && (pressedRow = SwingScoutTable.this.getSwingTable().rowAtPoint(e.getPoint())) >= 0) {
                SwingScoutTable.this.handleSwingRowAction(pressedRow);
            }
        }
    }

    private class P_SwingRowTransferHandler
    extends TransferHandlerEx {
        private static final long serialVersionUID = 1L;

        private P_SwingRowTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean canDrag() {
            return ((ITable)SwingScoutTable.this.getScoutObject()).getDragType() != 0;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            Transferable transferable = SwingScoutTable.this.handleSwingCopyRequest();
            if (transferable != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
            }
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return SwingScoutTable.this.handleSwingDragRequest();
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return SwingUtility.isSupportedTransfer(((ITable)SwingScoutTable.this.getScoutObject()).getDropType(), transferFlavors);
        }

        @Override
        public boolean importDataEx(JComponent comp, Transferable t, Point location) {
            if (location != null) {
                int droppingRow = SwingScoutTable.this.getSwingTable().rowAtPoint(location);
                SwingScoutTable.this.handleSwingDropAction(droppingRow, t);
                return true;
            }
            return false;
        }
    }

    private class P_SwingSelectionListener
    implements ListSelectionListener {
        private P_SwingSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!SwingScoutTable.this.getSwingTable().getSelectionModel().getValueIsAdjusting()) {
                int[] swingRows = SwingScoutTable.this.getSwingTable().getSelectedRows();
                SwingScoutTable.this.setSelectionFromSwing(swingRows);
            }
        }
    }

    private class P_SwingTable
    extends SwingTable {
        private static final long serialVersionUID = 1L;

        private P_SwingTable() {
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            ICell cell;
            if (renderer instanceof JComponent) {
                JComponent jc = (JComponent)((Object)renderer);
                jc.putClientProperty("html", null);
                jc.putClientProperty("html.disable", Boolean.TRUE);
                jc.setBackground(this.getBackground());
                jc.setForeground(this.getForeground());
                jc.setFont(this.getFont());
            }
            JComponent c = (JComponent)super.prepareRenderer(renderer, row, column);
            boolean isSelected = this.isCellSelected(row, column);
            P_SwingTable swingTable = this;
            ITable scoutTable = (ITable)SwingScoutTable.this.getScoutObject();
            IColumn scoutCol = ((SwingTableColumn)swingTable.getColumnModel().getColumn(column)).getScoutColumn();
            ITableRow scoutRow = SwingScoutTable.this.swingToScoutRow(row);
            if (scoutTable != null && (cell = scoutTable.getCell(scoutRow, scoutCol)) != null) {
                Color color;
                String s;
                boolean wrapText;
                c.setEnabled(scoutTable.isEnabled() && scoutRow.isEnabled() && cell.isEnabled());
                if (c instanceof JLabel) {
                    IColumn sortCol;
                    JLabel label = (JLabel)c;
                    int align = cell.getHorizontalAlignment();
                    if (!(column != 0 || StringUtility.isNullOrEmpty((String)scoutRow.getIconId()) && StringUtility.isNullOrEmpty((String)cell.getIconId()))) {
                        align = -1;
                    }
                    if (align > 0) {
                        label.setHorizontalAlignment(4);
                    } else if (align == 0) {
                        label.setHorizontalAlignment(0);
                    } else {
                        label.setHorizontalAlignment(2);
                    }
                    if (scoutCol instanceof IBooleanColumn) {
                        switch (((IBooleanColumn)scoutCol).getVerticalAlignment()) {
                            case 0: {
                                label.setVerticalAlignment(0);
                                break;
                            }
                            case 1: {
                                label.setVerticalAlignment(3);
                                break;
                            }
                            default: {
                                label.setVerticalAlignment(1);
                            }
                        }
                    }
                    boolean firstCellOfCheckableTable = scoutTable.isCheckable() && column == 0;
                    Icon checkboxIcon = this.getCheckboxIcon(firstCellOfCheckableTable, scoutCol, scoutRow, label);
                    Icon decoIcon = this.getDecoIcon(column, scoutRow, cell);
                    Icon icon = this.getCompositeIcon(checkboxIcon, decoIcon);
                    if (cell.isEditable()) {
                        icon = new P_IconWithMarker(icon);
                    }
                    label.setIcon(icon);
                    label.setDisabledIcon(icon);
                    if (scoutCol instanceof ISortOrderColumn && (sortCol = (IColumn)cell.getValue()) != null && sortCol.isSortActive() && sortCol.isSortExplicit()) {
                        label.setIcon(SortIconUtility.createSortIcon(sortCol, sortCol.getTable().getColumnSet().getSortColumns(), sortCol.isSortAscending()));
                    }
                }
                if (cell.getForegroundColor() != null) {
                    Color color2 = ColorUtility.createColor(cell.getForegroundColor());
                    if (isSelected) {
                        Color selectionColor = ColorUtility.createColor(cell.getBackgroundColor());
                        color2 = ColorUtility.multiplyColors(selectionColor, color2);
                    }
                    c.setForeground(color2);
                }
                if (cell.getFont() != null) {
                    Font oldf = this.getFont();
                    Font newf = SwingUtility.createFont(cell.getFont(), oldf);
                    if (oldf != null) {
                        c.setFont(new Font(oldf.getName(), newf != null ? newf.getStyle() : oldf.getStyle(), oldf.getSize()));
                    }
                }
                String text = cell.getText();
                boolean bl = wrapText = scoutCol instanceof IStringColumn && ((IStringColumn)scoutCol).isTextWrap();
                if (!(scoutCol.getDataType() != Boolean.class || scoutCol instanceof ISmartColumn && ((ISmartColumn)scoutCol).getLookupCall() != null)) {
                    text = null;
                }
                if (wrapText || scoutTable.isMultilineText() && SwingUtility.isMultilineLabelText(text)) {
                    text = SwingUtility.createHtmlLabelText(text, wrapText);
                } else if (text != null) {
                    text = text.replaceAll("[\\n\\r]+", " ");
                }
                if (c instanceof JLabel) {
                    ((JLabel)c).setText(text);
                    if (SwingScoutTable.this.m_htmlViewCache != null) {
                        SwingScoutTable.this.m_htmlViewCache.updateHtmlView((JLabel)c, cell.getForegroundColor() != null);
                    }
                }
                if ((s = cell.getTooltipText()) != null && s.length() == 0) {
                    s = null;
                }
                s = SwingUtility.createHtmlLabelText(s, true);
                c.setToolTipText(s);
                if (cell.getBackgroundColor() != null) {
                    color = ColorUtility.createColor(cell.getBackgroundColor());
                    if (isSelected) {
                        if (c.getBackground() != null) {
                            if (c.getBackground().getRGB() == Color.WHITE.getRGB()) {
                                color = ColorUtility.mergeColors(c.getBackground(), 0.5f, color, 0.5f);
                            }
                            color = ColorUtility.multiplyColors(c.getBackground(), color);
                        } else {
                            color = color.darker();
                        }
                    }
                    c.setBackground(color);
                } else if (swingTable.getBackground() != null && isSelected) {
                    color = swingTable.getBackground();
                    if (c.getBackground() != null) {
                        if (c.getBackground().getRGB() == Color.WHITE.getRGB()) {
                            color = ColorUtility.mergeColors(c.getBackground(), 0.5f, color, 0.5f);
                        }
                        color = ColorUtility.multiplyColors(c.getBackground(), color);
                    } else {
                        color = color.darker();
                    }
                    c.setBackground(color);
                }
            }
            return c;
        }

        private Icon getCompositeIcon(Icon icon1, Icon icon2) {
            Icon icon = null;
            if (icon1 != null && icon2 != null) {
                icon = new CompositeIcon(0, icon1, icon2);
            } else if (icon1 != null) {
                icon = icon1;
            } else if (icon2 != null) {
                icon = icon2;
            }
            return icon;
        }

        private Icon getCheckboxIcon(boolean firstCellOfCheckableTable, IColumn scoutCol, ITableRow scoutRow, JLabel label) {
            boolean booleanColumn = scoutCol.getDataType() == Boolean.class && (!(scoutCol instanceof ISmartColumn) || ((ISmartColumn)scoutCol).getLookupCall() == null);
            CheckboxIcon checkboxIcon = null;
            if (firstCellOfCheckableTable) {
                checkboxIcon = SwingScoutTable.this.getSwingEnvironment().createCheckboxWithMarginIcon(new Insets(4, 0, 0, 5));
                checkboxIcon.setSelected(scoutRow.isChecked());
                checkboxIcon.setEnabled(label.isEnabled());
            } else if (booleanColumn) {
                int fontPaddingTop = 0;
                if (label.getVerticalAlignment() == 1) {
                    fontPaddingTop = 4;
                }
                checkboxIcon = SwingScoutTable.this.getSwingEnvironment().createCheckboxWithMarginIcon(new Insets(fontPaddingTop, 0, 0, 0));
                ICell cell = scoutRow.getCell(scoutCol);
                Boolean b = (Boolean)cell.getValue();
                checkboxIcon.setSelected(b != null && b != false);
                checkboxIcon.setEnabled(label.isEnabled());
            }
            return checkboxIcon;
        }

        private Icon getDecoIcon(int column, ITableRow scoutRow, ICell cell) {
            Icon decoIcon = null;
            if (cell.getErrorStatus() != null && cell.getErrorStatus().getSeverity() == 4) {
                decoIcon = SwingScoutTable.this.getSwingEnvironment().getIcon("status_error");
            } else if (cell.getIconId() != null) {
                decoIcon = SwingScoutTable.this.getSwingEnvironment().getIcon(cell.getIconId());
            } else if (column == 0) {
                decoIcon = SwingScoutTable.this.getSwingEnvironment().getIcon(scoutRow.getIconId());
            }
            return decoIcon;
        }

        @Override
        public boolean editCellAt(int row, int column, EventObject e) {
            MouseEvent me;
            if (e instanceof MouseEvent && 2 == SwingScoutTable.this.getSwingTable().getSelectionModel().getSelectionMode() && ((me = (MouseEvent)e).isControlDown() || me.isShiftDown())) {
                return false;
            }
            return super.editCellAt(row, column, e);
        }
    }
}

