/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.concurrency;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

class ConcurrencyQueue {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ConcurrencyQueue.class);
    private static long seqNoProvider;
    private long m_seqNo;
    private Object m_queueChangeLock;
    private boolean m_closed;
    private String m_name;
    private String m_infoCached;
    private Object m_listLock = new Object();
    private LinkedList<Runnable> m_list = new LinkedList();
    private LinkedList<Runnable> m_dispatchingList = new LinkedList();

    public ConcurrencyQueue(String name, Object queueChangeLock) {
        this.m_seqNo = seqNoProvider++;
        if (queueChangeLock == null) {
            queueChangeLock = new Object();
        }
        this.m_queueChangeLock = queueChangeLock;
        this.m_name = name;
        this.updateInternalInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.m_listLock;
        synchronized (object) {
            return this.m_list.size() + this.m_dispatchingList.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.m_closed = true;
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_listLock.notifyAll();
        }
        object = this.m_queueChangeLock;
        synchronized (object) {
            this.m_queueChangeLock.notifyAll();
        }
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable r) {
        if (r != null) {
            Object object = this.m_listLock;
            synchronized (object) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.valueOf(this.m_infoCached) + " add: " + r);
                }
                this.m_list.add(r);
                this.updateInternalInfo();
                this.m_listLock.notifyAll();
            }
            object = this.m_queueChangeLock;
            synchronized (object) {
                this.m_queueChangeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Runnable r) {
        if (r != null) {
            boolean ok;
            Object object = this.m_listLock;
            synchronized (object) {
                ok = this.m_list.remove(r);
                this.updateInternalInfo();
                this.m_listLock.notifyAll();
            }
            object = this.m_queueChangeLock;
            synchronized (object) {
                this.m_queueChangeLock.notifyAll();
            }
            return ok;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPending(Runnable r) {
        if (r != null) {
            Object object = this.m_listLock;
            synchronized (object) {
                return this.m_dispatchingList.contains(r) || this.m_list.contains(r);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Object object = this.m_listLock;
        synchronized (object) {
            return !this.m_list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> removeAllJobs() {
        Object object = this.m_listLock;
        synchronized (object) {
            ArrayList<Runnable> a = new ArrayList<Runnable>(this.m_list);
            this.m_list.clear();
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNext(long waitTime) {
        long deadline = System.currentTimeMillis() + waitTime;
        Object object = this.m_listLock;
        synchronized (object) {
            long dt;
            while (this.m_list.isEmpty() && (dt = deadline - System.currentTimeMillis()) > 0L) {
                try {
                    this.m_listLock.wait(dt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.m_list.isEmpty()) return true;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchNext() {
        Runnable r = null;
        Object object = this.m_listLock;
        synchronized (object) {
            if (!this.m_list.isEmpty()) {
                r = this.m_list.removeFirst();
                this.m_dispatchingList.add(r);
            }
        }
        if (r != null) {
            try {
                long startTime = System.currentTimeMillis();
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.valueOf(this.m_infoCached) + " dispatchStart: " + r);
                }
                r.run();
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.valueOf(this.m_infoCached) + " dispatchEnd " + (System.currentTimeMillis() - startTime) + " ms:   " + r);
                }
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
            Object object2 = this.m_listLock;
            synchronized (object2) {
                this.m_dispatchingList.remove(r);
                this.updateInternalInfo();
                this.m_listLock.notifyAll();
            }
            object2 = this.m_queueChangeLock;
            synchronized (object2) {
                this.m_queueChangeLock.notifyAll();
            }
        }
    }

    private void updateInternalInfo() {
        int a = this.m_list.size();
        int b = this.m_dispatchingList.size();
        this.m_infoCached = String.valueOf(this.m_name) + "#" + this.m_seqNo + "[" + a + (b > 0 ? "+" + b : "") + " jobs]";
    }

    public String toString() {
        return this.m_infoCached;
    }
}

