/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.button;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.JButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JDropDownButton;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JRadioButtonEx;
import org.eclipse.scout.rt.ui.swing.ext.JToggleButtonEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.button.ISwingScoutButton;

public class SwingScoutButton<T extends IButton>
extends SwingScoutFieldComposite<T>
implements ISwingScoutButton<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutButton.class);
    private ButtonListener m_scoutButtonListener;
    private boolean m_handleActionPending;

    @Override
    protected void initializeSwing() {
        JPanelEx container;
        AbstractButton swingFieldAsButton = null;
        switch (this.getScoutButton().getDisplayStyle()) {
            case 2: {
                swingFieldAsButton = this.createSwingRadioButton();
                break;
            }
            case 1: {
                swingFieldAsButton = this.createSwingToggleButton();
                break;
            }
            default: {
                swingFieldAsButton = this.createSwingPushButton();
            }
        }
        swingFieldAsButton.setName(this.getScoutButton().getClass().getSimpleName());
        SwingUtility.installDefaultFocusHandling(swingFieldAsButton);
        swingFieldAsButton.setHorizontalTextPosition(4);
        swingFieldAsButton.setVerifyInputWhenFocusTarget(true);
        swingFieldAsButton.setRequestFocusEnabled(true);
        swingFieldAsButton.addActionListener(new P_SwingActionListener());
        if (((IButton)this.getScoutObject()).getContextMenu().hasChildActions()) {
            JDropDownButton dropDownButton = new JDropDownButton(swingFieldAsButton);
            dropDownButton.getMenuButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutButton.this.handleSwingPopup((Component)e.getSource());
                }
            });
            container = new JPanelEx();
            container.add(dropDownButton);
        } else {
            container = new JPanelEx();
            container.add(swingFieldAsButton);
        }
        container.setName(String.valueOf(this.getScoutButton().getClass().getSimpleName()) + ".container");
        this.setSwingLabel(null);
        this.setSwingField(swingFieldAsButton);
        LogicalGridData gd = (LogicalGridData)swingFieldAsButton.getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME);
        this.adaptButtonLayoutData(gd);
        ((JComponent)container.getComponent(0)).putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, gd);
        this.setSwingContainer(container);
        container.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 0, 0));
    }

    protected void adaptButtonLayoutData(LogicalGridData gd) {
        if (((IButton)this.getScoutObject()).isProcessButton() && !gd.useUiHeight) {
            gd.useUiHeight = true;
            gd.heightHint = this.getSwingEnvironment().getProcessButtonHeight();
        }
    }

    protected JRadioButton createSwingRadioButton() {
        JRadioButtonEx swingButton = new JRadioButtonEx();
        swingButton.setOpaque(false);
        swingButton.setRolloverEnabled(false);
        swingButton.addItemListener(new P_SwingSelectionListener());
        swingButton.setAlignmentX(0.0f);
        swingButton.setVerticalAlignment(1);
        return swingButton;
    }

    protected JToggleButtonEx createSwingToggleButton() {
        JToggleButtonEx swingButton = new JToggleButtonEx();
        swingButton.addItemListener(new P_SwingSelectionListener());
        swingButton.setAlignmentX(0.5f);
        return swingButton;
    }

    protected JButtonEx createSwingPushButton() {
        JButtonEx swingButton = new JButtonEx();
        swingButton.setAlignmentX(0.5f);
        return swingButton;
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutButtonListener != null) {
            this.getScoutButton().removeButtonListener(this.m_scoutButtonListener);
            this.m_scoutButtonListener = null;
        }
    }

    public T getScoutButton() {
        return (T)((IButton)this.getScoutObject());
    }

    @Override
    public AbstractButton getSwingButton() {
        return (AbstractButton)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutButtonListener == null) {
            this.m_scoutButtonListener = new P_ScoutButtonListener();
            this.getScoutButton().addButtonListener(this.m_scoutButtonListener);
        }
        T b = this.getScoutButton();
        this.setIconIdFromScout(b.getIconId());
        this.setImageFromScout(b.getImage());
        this.setSelectionFromScout(b.isSelected());
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (this.getScoutButton().getDisplayStyle() == 3 && scoutColor == null) {
            scoutColor = "445599";
        }
        super.setForegroundFromScout(scoutColor);
    }

    protected void setIconIdFromScout(String s) {
        AbstractButton comp;
        if (s != null && (comp = this.getSwingButton()) instanceof AbstractButton) {
            AbstractButton b = comp;
            IconGroup iconGroup = new IconGroup(this.getSwingEnvironment(), s);
            b.setIcon(iconGroup.getIcon(IconGroup.IconState.NORMAL));
            if (iconGroup.hasIcon(IconGroup.IconState.DISABLED)) {
                b.setDisabledIcon(iconGroup.getIcon(IconGroup.IconState.DISABLED));
            }
            if (iconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
                b.setRolloverIcon(iconGroup.getIcon(IconGroup.IconState.ROLLOVER));
            }
            if (iconGroup.hasIcon(IconGroup.IconState.SELECTED)) {
                b.setPressedIcon(iconGroup.getIcon(IconGroup.IconState.SELECTED));
                b.setSelectedIcon(iconGroup.getIcon(IconGroup.IconState.SELECTED));
            }
        }
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        this.getSwingButton().setAlignmentX(SwingUtility.createAlignmentX(scoutAlign));
        if (this.getSwingContainer().isShowing()) {
            this.getSwingContainer().revalidate();
        }
    }

    @Override
    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        this.getSwingButton().setAlignmentY(SwingUtility.createAlignmentY(scoutAlign));
        if (this.getSwingContainer().isShowing()) {
            this.getSwingContainer().revalidate();
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        String label = StringUtility.removeMnemonic((String)s);
        AbstractButton comp = this.getSwingButton();
        if (comp instanceof AbstractButton) {
            AbstractButton b = comp;
            b.setText(label);
            if (StringUtility.getMnemonic((String)s) != '\u0000') {
                b.setMnemonic(StringUtility.getMnemonic((String)s));
            }
        }
        SwingLayoutUtility.invalidateAncestors(comp);
    }

    protected void setSelectionFromScout(boolean b) {
        if (this.getSwingButton() instanceof JToggleButton) {
            ((JToggleButton)this.getSwingButton()).setSelected(b);
        } else if (this.getSwingButton() instanceof JRadioButton && b) {
            ((JRadioButton)this.getSwingButton()).setSelected(b);
        }
    }

    protected void setSelectionFromSwing(final boolean b) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutButton().isSelected() != b) {
            if (this.getSwingButton() instanceof JRadioButton && !b) {
                ((JRadioButton)this.getSwingButton()).setSelected(this.getScoutButton().isSelected());
            } else {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutButton.this.getScoutButton().getUIFacade().setSelectedFromUI(b);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    protected void setImageFromScout(Object img) {
        AbstractButton comp;
        if (img instanceof Image && (comp = this.getSwingButton()) instanceof AbstractButton) {
            AbstractButton b = comp;
            b.setIcon(new ImageIcon((Image)img));
            b.setHorizontalAlignment(10);
        }
    }

    protected void disarmButtonFromScout() {
        AbstractButton comp = this.getSwingButton();
        if (comp instanceof AbstractButton) {
            AbstractButton b = comp;
            b.getModel().setArmed(false);
        }
    }

    protected void requestPopupFromScout() {
        this.handleSwingPopup(this.getSwingButton());
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("image")) {
            this.setImageFromScout(newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    protected void handleSwingAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwingScoutButton.this.getScoutButton().getUIFacade().fireButtonClickedFromUI();
                    }
                    finally {
                        SwingScoutButton.this.m_handleActionPending = false;
                    }
                }
            };
            switch (this.getScoutButton().getDisplayStyle()) {
                default: 
            }
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwingPopup(final Component source) {
        final Point point = new Point(0, source.getHeight());
        Runnable t = new Runnable(){

            @Override
            public void run() {
                new SwingPopupWorker(SwingScoutButton.this.getSwingEnvironment(), source, point, SwingScoutButton.this.getScoutButton().getContextMenu()).enqueue();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 5678L);
    }

    private class P_ScoutButtonListener
    implements ButtonListener,
    WeakEventListener {
        private P_ScoutButtonListener() {
        }

        public void buttonChanged(ButtonEvent e) {
            if (SwingScoutButton.this.isIgnoredScoutEvent(ButtonEvent.class, "" + e.getType())) {
                return;
            }
            switch (e.getType()) {
                case 3: {
                    SwingScoutButton.this.getSwingEnvironment().invokeSwingLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingScoutButton.this.getUpdateSwingFromScoutLock().acquire();
                                SwingScoutButton.this.disarmButtonFromScout();
                            }
                            finally {
                                SwingScoutButton.this.getUpdateSwingFromScoutLock().release();
                            }
                        }
                    });
                    break;
                }
                case 4: {
                    SwingScoutButton.this.getSwingEnvironment().invokeSwingLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingScoutButton.this.getUpdateSwingFromScoutLock().acquire();
                                SwingScoutButton.this.requestPopupFromScout();
                            }
                            finally {
                                SwingScoutButton.this.getUpdateSwingFromScoutLock().release();
                            }
                        }
                    });
                }
            }
        }
    }

    private class P_SwingActionListener
    implements ActionListener {
        private P_SwingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutButton.this.handleSwingAction();
        }
    }

    private class P_SwingSelectionListener
    implements ItemListener {
        private P_SwingSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SwingScoutButton.this.setSelectionFromSwing(SwingScoutButton.this.getSwingButton().isSelected());
        }
    }
}

