/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.inject;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;

public class AppendActionsInjector {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AppendActionsInjector.class);

    public void inject(ISwingEnvironment env, JComponent parent, List<? extends IAction> actions, IActionFilter filter) {
        List normalizedActions = ActionUtility.visibleNormalizedActions(actions, (IActionFilter)filter);
        for (IAction a : normalizedActions) {
            if (a.isSeparator()) {
                if (parent instanceof JPopupMenu) {
                    ((JPopupMenu)parent).addSeparator();
                    continue;
                }
                if (parent instanceof JMenu) {
                    ((JMenu)parent).addSeparator();
                    continue;
                }
                LOG.warn("invalid container for separator: " + parent);
                continue;
            }
            ISwingScoutAction menuComposite = env.createAction(parent, a, filter);
            JComponent child = menuComposite.getSwingField();
            parent.add(child);
            if (!(a instanceof IActionNode) || !((IActionNode)a).hasChildActions()) continue;
            this.inject(env, child, ((IActionNode)a).getChildActions(), filter);
        }
    }
}

