/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayoutInfo;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ILayoutExtension;

public class LogicalGridLayout
extends Layout
implements ILayoutExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LogicalGridLayout.class);
    public static final int MIN = 0;
    public static final int PREF = 1;
    public static final int MAX = 2;
    public static final float EPS = 1.0E-6f;
    private boolean m_debug;
    private int m_hgap;
    private int m_vgap;
    private LogicalGridLayoutInfo m_info;
    private CompositeObject m_infoCacheKey;

    public LogicalGridLayout(int hgap, int vgap) {
        this.m_hgap = hgap;
        this.m_vgap = vgap;
    }

    public LogicalGridLayoutInfo getInfo() {
        return this.m_info;
    }

    public int computeMinimumWidth(Composite parent, boolean changed) {
        return this.computeMinimumSize((Composite)parent, (boolean)changed).x;
    }

    public Point computeMinimumSize(Composite parent, boolean changed) {
        return this.computeSize(parent, changed, -1, -1, 0);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return this.computeSize(composite, flushCache, wHint, hHint, 1);
    }

    public int computeMaximumWidth(Composite parent, boolean changed) {
        return this.computeSize((Composite)parent, (boolean)changed, (int)-1, (int)-1, (int)2).x;
    }

    public Point computeSize(Composite composite, boolean changed, int wHint, int hHint, int sizeFlag) {
        if (changed) {
            this.m_info = null;
        }
        if (wHint <= 0) {
            wHint = -1;
        }
        this.validateLayout(composite, wHint, changed);
        Point min = new Point(0, 0);
        Point pref = new Point(0, 0);
        Point max = new Point(0, 0);
        int useCount = 0;
        int i = 0;
        while (i < this.m_info.cols) {
            if (useCount > 0) {
                min.x += this.m_hgap;
                pref.x += this.m_hgap;
                max.x += this.m_hgap;
            }
            min.x += this.m_info.width[i][0];
            pref.x += this.m_info.width[i][1];
            max.x += this.m_info.width[i][2];
            ++useCount;
            ++i;
        }
        useCount = 0;
        i = 0;
        while (i < this.m_info.rows) {
            if (useCount > 0) {
                min.y += this.m_vgap;
                pref.y += this.m_vgap;
                max.y += this.m_vgap;
            }
            min.y += this.m_info.height[i][0];
            pref.y += this.m_info.height[i][1];
            max.y += this.m_info.height[i][2];
            ++useCount;
            ++i;
        }
        Point size = new Point(0, 0);
        switch (sizeFlag) {
            case 0: {
                size.x = min.x;
                size.y = min.y;
                break;
            }
            case 2: {
                size.x = min.x;
                size.y = min.y;
                break;
            }
            default: {
                if (wHint == -1) {
                    size.x = pref.x;
                } else {
                    size.x = wHint;
                    size.x = Math.min(max.x, size.x);
                    size.x = Math.max(min.x, size.x);
                }
                if (hHint == -1) {
                    size.y = pref.y;
                    break;
                }
                size.y = hHint;
                size.y = Math.min(max.y, size.y);
                size.y = Math.max(min.y, size.y);
            }
        }
        return size;
    }

    protected void layout(Composite parent, boolean flushCache) {
        if (flushCache) {
            this.m_info = null;
        }
        this.validateLayout(parent, parent.getSize().x, flushCache);
        Rectangle clientArea = parent.getClientArea();
        Point size = new Point(clientArea.width, clientArea.height);
        Rectangle[][] cellBounds = this.m_info.layoutCellBounds(size);
        if (this.m_debug || LOG.isDebugEnabled()) {
            this.dumpLayoutInfo(parent);
        }
        int n = this.m_info.components.length;
        int i = 0;
        while (i < n) {
            Control comp = this.m_info.components[i];
            LogicalGridData data = this.m_info.gridDatas[i];
            Rectangle r1 = cellBounds[data.gridy][data.gridx];
            Rectangle r2 = cellBounds[data.gridy + data.gridh - 1][data.gridx + data.gridw - 1];
            Rectangle r = r1.union(r2);
            if (data.topInset > 0) {
                r.y += data.topInset;
                r.height -= data.topInset;
            }
            if (!data.fillHorizontal || !data.fillVertical) {
                int delta;
                Point d = new Point(this.m_info.componentWidths[i], this.m_info.componentHeights[i]);
                if (!data.fillHorizontal && d.x < r.width) {
                    delta = r.width - d.x;
                    r.width = d.x;
                    if (data.horizontalAlignment == 0) {
                        r.x += delta / 2;
                    } else if (data.horizontalAlignment > 0) {
                        r.x += delta;
                    }
                }
                if (!data.fillVertical && d.y < r.height) {
                    delta = r.height - d.y;
                    r.height = data.heightHint == 0 ? d.y : data.heightHint;
                    if (data.verticalAlignment == 0) {
                        r.y += delta / 2;
                    } else if (data.verticalAlignment > 0) {
                        r.y += delta;
                    }
                }
            }
            comp.setBounds(r);
            ++i;
        }
    }

    public void setDebug(boolean b) {
        this.m_debug = b;
    }

    public void dumpLayoutInfo(Composite parent) {
        this.dumpLayoutInfo(parent, new PrintWriter(System.out));
    }

    public void dumpLayoutInfo(Composite parent, PrintWriter out) {
        Point parentSize = parent.getSize();
        Rectangle[][] cellBounds = this.m_info.layoutCellBounds(parentSize);
        IPropertyObserver field = SwtScoutComposite.getScoutModelOnWidget((Widget)parent);
        String className = "undefined (PROP_SCOUT_OBJECT not set!)";
        if (field != null) {
            className = field.getClass().getSimpleName();
        }
        out.println("DUMP layout of: " + className + " compSize= " + parentSize);
        out.println("  containerBounds = " + parent.getClientArea());
        out.println("  Fields ---");
        int i = 0;
        while (i < this.m_info.components.length) {
            Control c = this.m_info.components[i];
            LogicalGridData data = this.m_info.gridDatas[i];
            try {
                Rectangle r1 = cellBounds[data.gridy][data.gridx];
                Rectangle r2 = cellBounds[data.gridy + data.gridh - 1][data.gridx + data.gridw - 1];
                Rectangle r = r1.union(r2);
                String scoutObjectName = "NOT DEFINED";
                IPropertyObserver scoutObject = SwtScoutComposite.getScoutModelOnWidget((Widget)c);
                if (scoutObject != null) {
                    scoutObjectName = scoutObject.getClass().getSimpleName();
                }
                out.println("   b=" + r + " " + scoutObjectName);
                if (scoutObject instanceof IFormField) {
                    out.println("   model grid: " + ((IFormField)scoutObject).getGridData().toString());
                }
                out.println("   uiGridData: " + data.toString());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                out.print("unable to print layout info of: " + data);
                e.printStackTrace();
            }
            ++i;
        }
        out.flush();
    }

    protected void validateLayout(Composite parent, int wHint, boolean flushCache) {
        Object[] objectArray = new Object[2];
        objectArray[0] = parent.getSize();
        objectArray[1] = wHint == -1 ? (this.m_infoCacheKey != null ? this.m_infoCacheKey.getComponent(1) : Integer.valueOf(wHint)) : Integer.valueOf(wHint);
        CompositeObject newKey = new CompositeObject(objectArray);
        if (!(this.m_info == null || this.m_infoCacheKey != null && this.m_infoCacheKey.equals((Object)newKey))) {
            this.m_info = null;
            this.m_infoCacheKey = null;
        }
        if (this.m_info != null && this.m_infoCacheKey != null) {
            return;
        }
        ArrayList<Control> visibleComps = new ArrayList<Control>();
        ArrayList<LogicalGridData> visibleCons = new ArrayList<LogicalGridData>();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control comp = controlArray[n2];
            if (comp.getVisible() && comp.getLayoutData() instanceof LogicalGridData) {
                visibleComps.add(comp);
                LogicalGridData cons = (LogicalGridData)comp.getLayoutData();
                cons.validate();
                visibleCons.add(cons);
            }
            ++n2;
        }
        this.m_info = new LogicalGridLayoutInfo(visibleComps.toArray(new Control[visibleComps.size()]), visibleCons.toArray(new LogicalGridData[visibleCons.size()]), this.m_hgap, this.m_vgap, wHint, flushCache);
        this.m_infoCacheKey = newKey;
    }
}

