/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarItemContainer;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCalendarItem;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractCalendarItem
extends Composite
implements PaintListener,
MouseTrackListener {
    private CalendarItemContainer m_item;
    private AbstractCell m_cell;
    private Menu m_contextMenu;

    public AbstractCalendarItem(AbstractCell parent, int style, CalendarItemContainer item) {
        super((Composite)parent, style);
        this.m_item = item;
        this.m_cell = parent;
        this.createControls();
        this.setLayout();
        this.setupMenu();
        this.hookListeners();
    }

    protected CalendarItemContainer getItem() {
        return this.m_item;
    }

    protected void setItem(CalendarItemContainer item) {
        this.m_item = item;
    }

    protected AbstractCell getCell() {
        return this.m_cell;
    }

    protected void setCell(AbstractCell cell) {
        this.m_cell = cell;
    }

    protected void createControls() {
    }

    protected void setLayout() {
    }

    private void setupMenu() {
        this.m_contextMenu = new Menu((Decorations)this.getShell(), 8);
        this.setMenu(this.m_contextMenu);
    }

    protected void hookListeners() {
        this.addPaintListener(this);
        this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractCalendarItem.this.m_cell.getCalendar().setSelectedDateFromUI(AbstractCalendarItem.this.m_cell.getDate());
                AbstractCalendarItem.this.m_cell.getCalendar().setSelectedItem(AbstractCalendarItem.this.m_item.getItem());
            }
        });
        this.addMouseTrackListener(this);
    }

    public void paintControl(PaintEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        this.setToolTipText(this.m_cell.getCalendar().getModel().getTooltip(this.m_item.getItem(), this.m_cell.getDate().getTime()));
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        this.setToolTipText("");
    }

    public String toString() {
        String s = this.m_cell.getCalendar().getModel().getLabel(this.m_item.getItem(), this.m_cell.getDate().getTime());
        if (this instanceof WeekCalendarItem) {
            return "WeekCalendarItem {" + s + "}";
        }
        return "MonthCalendarItem {" + s + "}";
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private P_ContextMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            if (AbstractCalendarItem.this.m_contextMenu != null) {
                MenuItem[] menuItemArray = AbstractCalendarItem.this.m_contextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    this.disposeMenuItem(item);
                    ++n2;
                }
            }
            AbstractCalendarItem.this.m_cell.getCalendar().showItemContextMenu(AbstractCalendarItem.this.m_contextMenu, AbstractCalendarItem.this.m_item.getItem());
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }
}

