/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.CentralPanel;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TimelineColumn
extends Composite
implements PaintListener {
    private boolean m_drawHeader;
    private int m_realOffsetY;
    private CentralPanel m_centralPanel;

    public TimelineColumn(CentralPanel parent, int style) {
        this(parent, style, true);
    }

    public TimelineColumn(CentralPanel parent, int style, boolean drawHeader) {
        super((Composite)parent, style);
        this.m_centralPanel = parent;
        this.m_drawHeader = drawHeader;
        this.m_realOffsetY = this.m_drawHeader ? 13 : 0;
    }

    public void init() {
        this.createControls(this.m_centralPanel);
        this.addPaintListener(this);
    }

    protected void createControls(Composite parent) {
        GridData gd = new GridData();
        gd.widthHint = 50;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
        this.setBackground(SwtColors.getInstance().getWhite());
    }

    public void paintControl(PaintEvent e) {
        e.gc.setForeground(SwtColors.getInstance().getGray());
        this.drawBorder(e);
        this.drawTimeline(e);
    }

    protected void drawBorder(PaintEvent e) {
        Rectangle bounds = this.getBounds();
        e.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
    }

    protected void drawTimeline(PaintEvent e) {
        Rectangle bounds = this.getBounds();
        int timelessHeight = Math.min(24 * this.m_centralPanel.getTimelessMaxCount(), 33 * bounds.height / 100);
        int hTimeless = Math.max(0, timelessHeight - 1);
        int yTimed = this.m_realOffsetY + hTimeless + 1;
        int slots = this.m_centralPanel.getCalendar().getEndHour() - this.m_centralPanel.getCalendar().getStartHour();
        double deltaY = (double)(bounds.height - yTimed) / ((double)slots * 1.0);
        int x1 = 1;
        int y1 = (int)Math.round(deltaY * (double)(12 - this.m_centralPanel.getCalendar().getStartHour())) + yTimed;
        int x2 = bounds.width - 3;
        int y2 = (int)Math.round(deltaY);
        Rectangle noon = new Rectangle(x1, y1, x2, y2);
        if (this.m_centralPanel.getCalendar().getMarkNoonHour()) {
            e.gc.setBackground(SwtColors.getInstance().getLightgray());
        } else {
            e.gc.setBackground(SwtColors.getInstance().getWhite());
        }
        e.gc.fillRectangle(noon);
        e.gc.setBackground(SwtColors.getInstance().getWhite());
        int time = this.m_centralPanel.getCalendar().getStartHour();
        int i = 0;
        while (i < slots) {
            int y = (int)Math.round(deltaY * (double)i) + yTimed;
            e.gc.drawLine(0, y, bounds.width - 1, y);
            if (time <= this.m_centralPanel.getCalendar().getStartHour() && this.m_centralPanel.getCalendar().getUseOverflowCells()) {
                e.gc.drawText(SwtUtility.getNlsText(Display.getCurrent(), "Calendar_earlier", new String[0]), 3, y + 1, true);
            } else if (time >= this.m_centralPanel.getCalendar().getEndHour() - 1 && this.m_centralPanel.getCalendar().getUseOverflowCells()) {
                e.gc.drawText(SwtUtility.getNlsText(Display.getCurrent(), "Calendar_later", new String[0]), 3, y + 1, true);
            } else {
                String hours = time < 10 ? "0" + time + ":00" : time + ":00";
                e.gc.drawText(hours, 3, y + 1, true);
            }
            ++time;
            ++i;
        }
    }
}

