/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageViewer
extends Canvas {
    protected static final int FOCUS_BORDER_OFFSET_PX = 2;
    protected static final Rectangle FOCUS_BORDER_OFFSET = new Rectangle(2, 2, -4, -4);
    protected static final Rectangle NO_FOCUS_BORDER_OFFSET = new Rectangle(0, 0, 0, 0);
    private int m_xAglin = 0x1000000;
    private int m_yAglin = 0x1000000;
    private boolean m_autoFit = false;
    private Image m_image;
    private Image m_scaledImage;
    private KeyListener m_keyListener;

    public ImageViewer(Composite parent) {
        super(parent, 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageViewer.this.handleSwtPaintEvent(e.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageViewer.this.freeResources();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ImageViewer.this.redraw();
            }

            public void focusGained(FocusEvent e) {
                ImageViewer.this.redraw();
            }
        });
    }

    private void freeResources() {
        if (this.m_scaledImage != null && !this.m_scaledImage.isDisposed()) {
            this.m_scaledImage.dispose();
            this.m_scaledImage = null;
        }
    }

    private Image scaleImage(Image img) {
        this.freeResources();
        if (this.m_autoFit && img != null) {
            Rectangle clientArea = this.getClientArea();
            if (clientArea.width == 0 || clientArea.height == 0) {
                return img;
            }
            Rectangle imageBounds = img.getBounds();
            if (imageBounds.width == 0 || imageBounds.height == 0) {
                return null;
            }
            double scaleFactor = (double)clientArea.width / (double)imageBounds.width;
            scaleFactor = Math.min(scaleFactor, (double)clientArea.height / (double)img.getBounds().height);
            this.m_scaledImage = new Image((Device)this.getDisplay(), img.getImageData().scaledTo((int)(scaleFactor * (double)img.getBounds().width), (int)(scaleFactor * (double)img.getBounds().height)));
            return this.m_scaledImage;
        }
        return img;
    }

    public Rectangle getClientArea() {
        Rectangle clientArea = super.getClientArea();
        if (this.isFocusable()) {
            clientArea.x += ImageViewer.FOCUS_BORDER_OFFSET.x;
            clientArea.y += ImageViewer.FOCUS_BORDER_OFFSET.y;
            clientArea.width += ImageViewer.FOCUS_BORDER_OFFSET.width;
            clientArea.height += ImageViewer.FOCUS_BORDER_OFFSET.height;
        }
        return clientArea;
    }

    protected Point getImageLocation(Rectangle bounds, Rectangle imgBounds) {
        Rectangle focusBorderOffset = this.getFocusBorderOffset();
        Point location = new Point(focusBorderOffset.x, focusBorderOffset.y);
        if (imgBounds.width <= bounds.width) {
            switch (this.getAlignmentX()) {
                case 0x1000000: {
                    location.x = (bounds.width - imgBounds.width + focusBorderOffset.width) / 2;
                    break;
                }
                case 131072: {
                    location.x = bounds.width - imgBounds.width + focusBorderOffset.width;
                    break;
                }
                default: {
                    location.x = focusBorderOffset.x;
                }
            }
        }
        if (imgBounds.height <= bounds.height) {
            switch (this.getAlignmentY()) {
                case 0: {
                    location.y = (bounds.height - imgBounds.height + focusBorderOffset.height) / 2;
                    break;
                }
                case 1024: {
                    location.y = bounds.height - imgBounds.height + focusBorderOffset.height;
                    break;
                }
                default: {
                    location.y = focusBorderOffset.y;
                }
            }
        }
        return location;
    }

    protected void handleSwtPaintEvent(GC gc) {
        Image img = this.getImage();
        if (img != null) {
            if (this.isAutoFit()) {
                img = this.scaleImage(img);
            }
            Rectangle imgBounds = img.getBounds();
            Rectangle focusBorderOffset = this.getFocusBorderOffset();
            Point imageLocation = this.getImageLocation(gc.getClipping(), imgBounds);
            gc.drawImage(img, imageLocation.x, imageLocation.y);
            if (this.isFocusable() && this.isFocusControl()) {
                int lineStyleBackup = gc.getLineStyle();
                Color foregroundBackup = gc.getForeground();
                try {
                    gc.setLineStyle(3);
                    gc.setForeground(gc.getDevice().getSystemColor(10));
                    gc.drawRectangle(imageLocation.x - focusBorderOffset.x, imageLocation.y - focusBorderOffset.y, imgBounds.width - focusBorderOffset.width, imgBounds.height - focusBorderOffset.height);
                }
                finally {
                    gc.setLineStyle(lineStyleBackup);
                    gc.setForeground(foregroundBackup);
                }
            }
        }
    }

    protected Rectangle getFocusBorderOffset() {
        if (this.isFocusable()) {
            return FOCUS_BORDER_OFFSET;
        }
        return NO_FOCUS_BORDER_OFFSET;
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point size = super.computeSize(hint, hint2, changed);
        if (this.getImage() != null) {
            Rectangle imgBounds = this.getImage().getBounds();
            size.x = imgBounds.width;
            size.y = imgBounds.height;
        }
        return size;
    }

    public void setAlignmentX(int alignment) {
        this.m_xAglin = alignment;
    }

    public int getAlignmentX() {
        return this.m_xAglin;
    }

    public void setAlignmentY(int alignment) {
        this.m_yAglin = alignment;
    }

    public int getAlignmentY() {
        return this.m_yAglin;
    }

    public synchronized boolean isFocusable() {
        return this.m_keyListener != null;
    }

    public synchronized void setFocusable(boolean focusable) {
        if (focusable) {
            if (this.m_keyListener == null) {
                this.m_keyListener = new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        ImageViewer.this.traverse(0, e);
                    }
                };
                this.addKeyListener(this.m_keyListener);
            }
        } else if (this.m_keyListener != null) {
            this.removeKeyListener(this.m_keyListener);
            this.m_keyListener = null;
        }
    }

    public boolean isAutoFit() {
        return this.m_autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.m_autoFit = autoFit;
    }

    public void setImage(Image img) {
        this.m_image = img;
    }

    public Image getImage() {
        return this.m_image;
    }
}

