/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext.table.internal;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditableTableMarkerSupport {
    private Table m_table;
    private Listener m_markerPaintListener;
    private Image m_editableMarkerImage;

    public EditableTableMarkerSupport(Table table) {
        this.m_table = table;
        this.m_editableMarkerImage = Activator.getIcon("cell_editable");
        this.m_markerPaintListener = new P_EditableMarkerPaintLiastener();
        this.m_table.addListener(42, this.m_markerPaintListener);
        this.m_table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditableTableMarkerSupport.this.m_table.removeListener(42, EditableTableMarkerSupport.this.m_markerPaintListener);
            }
        });
    }

    private boolean isEditableIconNeeded(Event event, TableItem item) {
        IColumn col = (IColumn)item.getParent().getColumn(event.index).getData("scoutColumn");
        return col != null && col.isEditable() && !col.getDataType().isAssignableFrom(Boolean.class);
    }

    private class P_EditableMarkerPaintLiastener
    implements Listener {
        private P_EditableMarkerPaintLiastener() {
        }

        public void handleEvent(Event event) {
            TableItem item = (TableItem)event.item;
            switch (event.type) {
                case 42: {
                    if (!EditableTableMarkerSupport.this.isEditableIconNeeded(event, item)) break;
                    IColumn col = (IColumn)item.getParent().getColumn(event.index).getData("scoutColumn");
                    ICell cell = ((ITableRow)item.getData()).getCell(col);
                    Image markerIcon = EditableTableMarkerSupport.this.m_editableMarkerImage;
                    if (markerIcon == null || !cell.isEditable()) break;
                    event.gc.drawImage(markerIcon, event.x, event.y);
                }
            }
        }
    }
}

