/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.ISwtScoutTimeField;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.TimeChooserDialog;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutTimeField
extends SwtScoutBasicFieldComposite<IDateField>
implements ISwtScoutTimeField,
IPopupSupport {
    private Button m_timeChooserButton;
    private TextFieldEditableSupport m_editableSupport;
    private Set<IPopupSupport.IPopupSupportListener> m_popupEventListeners;
    private Object m_popupEventListenerLock;

    @Override
    protected void initializeSwt(Composite parent) {
        this.m_popupEventListeners = new HashSet<IPopupSupport.IPopupSupportListener>();
        this.m_popupEventListenerLock = new Object();
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText(container, 2052);
        Button timeChooserButton = this.getEnvironment().getFormToolkit().createButton(container, 8);
        timeChooserButton.setImage(this.getEnvironment().getIcon("datefield_time"));
        container.setTabList(new Control[]{textField});
        this.getEnvironment().addKeyStroke((Widget)container, new P_TimeChooserOpenKeyStroke());
        timeChooserButton.addSelectionListener((SelectionListener)new P_SwtBrowseButtonListener());
        this.addModifyListenerForBasicField((Widget)textField);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setTimeChooserButton(timeChooserButton);
        this.setSwtField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        timeChooserButton.setLayoutData((Object)LogicalGridDataBuilder.createButton1());
    }

    @Override
    public Button getTimeChooserButton() {
        return this.m_timeChooserButton;
    }

    public void setTimeChooserButton(Button timeChooserButton) {
        this.m_timeChooserButton = timeChooserButton;
    }

    @Override
    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_timeChooserButton.setEnabled(b);
    }

    @Override
    protected String getText() {
        return this.getSwtField().getText();
    }

    @Override
    protected void setText(String text) {
        this.getSwtField().setText(text);
    }

    @Override
    protected Point getSelection() {
        return this.getSwtField().getSelection();
    }

    @Override
    protected void setSelection(int startIndex, int endIndex) {
        this.getSwtField().setSelection(startIndex, endIndex);
    }

    @Override
    protected int getCaretOffset() {
        return this.getSwtField().getCaretOffset();
    }

    @Override
    protected void setCaretOffset(int caretPosition) {
        this.getSwtField().setCaretOffset(caretPosition);
    }

    @Override
    protected TextFieldEditableSupport createEditableSupport() {
        return new TextFieldEditableSupport(this.getSwtField());
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
        super.handleSwtFocusGained();
        this.getSwtField().setCaretOffset(0);
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IDateField)this.getScoutObject()).getDisplayText()) && ((IDateField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)SwtScoutTimeField.this.getScoutObject()).getUIFacade().setTimeTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.scheduleSelectAll();
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }

    private void handleSwtTimeChooserAction() {
        if (this.getTimeChooserButton().isVisible() && this.getTimeChooserButton().isEnabled()) {
            Date d = (Date)((IDateField)this.getScoutObject()).getValue();
            if (d == null) {
                d = new Date();
            }
            this.notifyPopupEventListeners(2);
            try {
                TimeChooserDialog dialog = new TimeChooserDialog(this.getSwtField().getShell(), d, this.getEnvironment());
                Date newDate = dialog.openDateChooser((Control)this.getSwtField());
                if (newDate != null) {
                    this.getSwtField().setText(DateFormat.getTimeInstance(3).format(newDate));
                    this.handleSwtInputVerifier();
                }
            }
            finally {
                this.notifyPopupEventListeners(4);
                if (!this.getSwtField().isDisposed()) {
                    this.getSwtField().setFocus();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPopupEventListeners(int eventType) {
        IPopupSupport.IPopupSupportListener[] listeners;
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            listeners = this.m_popupEventListeners.toArray(new IPopupSupport.IPopupSupportListener[this.m_popupEventListeners.size()]);
        }
        IPopupSupport.IPopupSupportListener[] iPopupSupportListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPopupSupport.IPopupSupportListener listener = iPopupSupportListenerArray[n2];
            listener.handleEvent(eventType);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.remove(listener);
        }
    }

    private class P_SwtBrowseButtonListener
    extends SelectionAdapter {
        private P_SwtBrowseButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutTimeField.this.handleSwtTimeChooserAction();
        }
    }

    private class P_TimeChooserOpenKeyStroke
    extends SwtKeyStroke {
        public P_TimeChooserOpenKeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleSwtAction(Event e) {
            SwtScoutTimeField.this.handleSwtTimeChooserAction();
        }
    }
}

